/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.registration;

import io.quarkus.eureka.client.InstanceInfo;
import io.quarkus.eureka.client.Status;
import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.operation.OperationFactory;
import io.quarkus.eureka.operation.heartbeat.HeartBeatOperation;
import io.quarkus.eureka.operation.query.ApplicationResult;
import io.quarkus.eureka.operation.query.InstanceResult;
import io.quarkus.eureka.operation.query.MultipleInstanceQueryOperation;
import io.quarkus.eureka.operation.register.RegisterOperation;
import io.quarkus.eureka.registration.InstanceHealthCheckService;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;

class EurekaSingleInstanceRegister {
    private final OperationFactory operationFactory;
    private final InstanceInfo instanceInfo;
    private final InstanceHealthCheckService instanceHealthCheckService;

    public EurekaSingleInstanceRegister(InstanceInfo instanceInfo, OperationFactory operationFactory) {
        this.instanceInfo = instanceInfo;
        this.operationFactory = operationFactory;
        this.instanceHealthCheckService = new InstanceHealthCheckService();
    }

    Runnable registerLocation(Location location) {
        return () -> ((InstanceResult)RegistrationFlow.instanceHealthCheck(() -> this.instanceHealthCheckService.healthCheck(this.instanceInfo.getHealthCheckUrl())).eurekaHealthCheck(() -> this.getApplicationStatus(location)).isRegistered(queryResponse -> this.operationFactory.get(HeartBeatOperation.class).heartbeat(location, this.instanceInfo))).isNotRegistered(queryResponse -> this.operationFactory.get(RegisterOperation.class).register(location, this.instanceInfo));
    }

    private InstanceResult getApplicationStatus(Location location) {
        ApplicationResult applicationResult = this.operationFactory.get(MultipleInstanceQueryOperation.class).findInstance(location, this.instanceInfo.getApp());
        List<InstanceResult> instanceResults = applicationResult.getInstanceResults();
        return instanceResults.stream().filter(instanceResult -> this.instanceInfo.getInstanceId().equals(instanceResult.getInstanceId())).findFirst().orElse(InstanceResult.error());
    }

    private record RegistrationFlow(Status status) {
        private static final Logger LOGGER = Logger.getLogger(RegistrationFlow.class.getName());

        private static RegistrationFlow instanceHealthCheck(Supplier<Status> statusSupplier) {
            try {
                return new RegistrationFlow(statusSupplier.get());
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
                throw e;
            }
        }

        private InstanceResult eurekaHealthCheck(Supplier<InstanceResult> eurekaHealthSupplier) {
            if (Status.UP.equals((Object)this.status)) {
                return eurekaHealthSupplier.get();
            }
            return InstanceResult.error();
        }
    }
}

