/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.registration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.eureka.client.Status;
import io.quarkus.eureka.exception.HealthCheckException;
import io.quarkus.runtime.util.StringUtil;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Map;

class InstanceHealthCheckService {
    private final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * Enabled aggressive exception aggregation
     */
    Status healthCheck(String healthCheckUrl) {
        try (Client client = ClientBuilder.newClient();){
            Status status;
            block15: {
                Response response = client.target(healthCheckUrl).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
                try {
                    if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.CLIENT_ERROR)) {
                        throw new HealthCheckException("Instance can't reach own application health check. Ensure this has been implemented");
                    }
                    status = this.getStatusFromResponse(response);
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return status;
        }
        catch (ProcessingException ex) {
            throw new HealthCheckException(String.format("Health check not reachable: %s", healthCheckUrl), ex);
        }
    }

    private Status getStatusFromResponse(Response response) {
        String body = (String)response.readEntity(String.class);
        try {
            Map result = (Map)this.objectMapper.readValue(body, (TypeReference)new TypeReference<Map<String, String>>(this){});
            String status = (String)result.get("status");
            if (StringUtil.isNullOrEmpty((String)status)) {
                return Status.UNKNOWN;
            }
            return Status.valueOf(status.toUpperCase());
        }
        catch (JsonProcessingException e) {
            return Status.UNKNOWN;
        }
    }
}

