/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.util;

import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.config.ServiceLocationConfig;
import io.quarkus.eureka.operation.OperationFactory;
import io.quarkus.eureka.operation.query.ApplicationResult;
import io.quarkus.eureka.operation.query.InstanceResult;
import io.quarkus.eureka.operation.query.MultipleInstanceQueryOperation;
import java.util.stream.Stream;

public class ServiceDiscovery {
    private final ServiceLocationConfig serviceLocationConfig;
    private final OperationFactory operationFactory;

    public ServiceDiscovery(ServiceLocationConfig serviceLocationConfig, OperationFactory operationFactory) {
        this.serviceLocationConfig = serviceLocationConfig;
        this.operationFactory = operationFactory;
    }

    public Stream<String> findServiceLocations(String appId) {
        return this.serviceLocationConfig.getLocations().stream().map(location -> this.operationFactory.get(MultipleInstanceQueryOperation.class).findInstance((Location)location, appId.toUpperCase())).filter(ApplicationResult::success).flatMap(applicationResult -> applicationResult.getInstanceResults().stream().map(this::getBaseUrl));
    }

    private String getBaseUrl(InstanceResult instanceResult) {
        String contextPath = instanceResult.getMetadata().getOrDefault("context", "/");
        String homePageUrl = instanceResult.getHomePageUrl();
        if (homePageUrl.endsWith("/")) {
            homePageUrl = homePageUrl.substring(0, homePageUrl.length() - 1);
        }
        return homePageUrl.concat(contextPath);
    }
}

