/* Copyright 2013 Samuel Halliday (generated Java and C).
 * Copyright 2003-2007 Keith Seymour (Fortran to Java translation).
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 *
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <jni.h>
#include <netlib-jni.h>
#include <lapacke.h>
#include <com_github_fommil_netlib_NativeRefLAPACK.h>

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dbdsdc (JNIEnv * env, jobject calling_obj, jstring uplo, jstring compq, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jdoubleArray q, jintArray iq, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jint * jni_iq = NULL;
  if (iq != NULL) {
    jni_iq = (*env)->GetPrimitiveArrayCritical(env, iq, JNI_FALSE);
    check_memory(env, jni_iq);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dbdsdc_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_compq[0], n, jni_d, jni_e, jni_u, ldu, jni_vt, ldvt, jni_q, jni_iq, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (iq != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iq, jni_iq, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dbdsdc_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring compq, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray u, jint _u_offset, jint ldu, jdoubleArray vt, jint _vt_offset, jint ldvt, jdoubleArray q, jint _q_offset, jintArray iq, jint _iq_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jint * jni_iq = NULL;
  if (iq != NULL) {
    jni_iq = (*env)->GetPrimitiveArrayCritical(env, iq, JNI_FALSE);
    check_memory(env, jni_iq);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dbdsdc_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_compq[0], n, jni_d + _d_offset, jni_e + _e_offset, jni_u + _u_offset, ldu, jni_vt + _vt_offset, ldvt, jni_q + _q_offset, jni_iq + _iq_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (iq != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iq, jni_iq, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dbdsqr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint ncvt, jint nru, jint ncc, jdoubleArray d, jdoubleArray e, jdoubleArray vt, jint ldvt, jdoubleArray u, jint ldu, jdoubleArray c, jint Ldc, jdoubleArray work, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dbdsqr_work(LAPACK_COL_MAJOR, jni_uplo[0], n, ncvt, nru, ncc, jni_d, jni_e, jni_vt, ldvt, jni_u, ldu, jni_c, Ldc, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dbdsqr_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint ncvt, jint nru, jint ncc, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray vt, jint _vt_offset, jint ldvt, jdoubleArray u, jint _u_offset, jint ldu, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dbdsqr_work(LAPACK_COL_MAJOR, jni_uplo[0], n, ncvt, nru, ncc, jni_d + _d_offset, jni_e + _e_offset, jni_vt + _vt_offset, ldvt, jni_u + _u_offset, ldu, jni_c + _c_offset, Ldc, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_ddisna (JNIEnv * env, jobject calling_obj, jstring job, jint m, jint n, jdoubleArray d, jdoubleArray sep, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_sep = NULL;
  if (sep != NULL) {
    jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
    check_memory(env, jni_sep);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_ddisna_work(jni_job[0], m, n, jni_d, jni_sep);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (sep != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_ddisna_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jint m, jint n, jdoubleArray d, jint _d_offset, jdoubleArray sep, jint _sep_offset, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_sep = NULL;
  if (sep != NULL) {
    jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
    check_memory(env, jni_sep);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_ddisna_work(jni_job[0], m, n, jni_d + _d_offset, jni_sep + _sep_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (sep != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbbrd (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint ncc, jint kl, jint ku, jdoubleArray ab, jint ldab, jdoubleArray d, jdoubleArray e, jdoubleArray q, jint ldq, jdoubleArray pt, jint ldpt, jdoubleArray c, jint Ldc, jdoubleArray work, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_pt = NULL;
  if (pt != NULL) {
    jni_pt = (*env)->GetPrimitiveArrayCritical(env, pt, JNI_FALSE);
    check_memory(env, jni_pt);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbbrd_work(LAPACK_COL_MAJOR, jni_vect[0], m, n, ncc, kl, ku, jni_ab, ldab, jni_d, jni_e, jni_q, ldq, jni_pt, ldpt, jni_c, Ldc, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (pt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, pt, jni_pt, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbbrd_1offsets (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint ncc, jint kl, jint ku, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray pt, jint _pt_offset, jint ldpt, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_pt = NULL;
  if (pt != NULL) {
    jni_pt = (*env)->GetPrimitiveArrayCritical(env, pt, JNI_FALSE);
    check_memory(env, jni_pt);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbbrd_work(LAPACK_COL_MAJOR, jni_vect[0], m, n, ncc, kl, ku, jni_ab + _ab_offset, ldab, jni_d + _d_offset, jni_e + _e_offset, jni_q + _q_offset, ldq, jni_pt + _pt_offset, ldpt, jni_c + _c_offset, Ldc, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (pt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, pt, jni_pt, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbcon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jint kl, jint ku, jdoubleArray ab, jint ldab, jintArray ipiv, jdouble anorm, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbcon_work(LAPACK_COL_MAJOR, jni_norm[0], n, kl, ku, jni_ab, ldab, jni_ipiv, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbcon_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jint kl, jint ku, jdoubleArray ab, jint _ab_offset, jint ldab, jintArray ipiv, jint _ipiv_offset, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbcon_work(LAPACK_COL_MAJOR, jni_norm[0], n, kl, ku, jni_ab + _ab_offset, ldab, jni_ipiv + _ipiv_offset, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbequ (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jdoubleArray ab, jint ldab, jdoubleArray r, jdoubleArray c, jdoublew rowcnd, jdoublew colcnd, jdoublew amax, jintw info) {
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
  jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "D");
  jdouble jni_rowcnd = (*env)->GetDoubleField(env, rowcnd, jni_rowcndId);
  jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
  jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "D");
  jdouble jni_colcnd = (*env)->GetDoubleField(env, colcnd, jni_colcndId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbequ_work(LAPACK_COL_MAJOR, m, n, kl, ku, jni_ab, ldab, jni_r, jni_c, &jni_rowcnd, &jni_colcnd, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, colcnd, jni_colcndId, jni_colcnd);
  (*env)->SetDoubleField(env, rowcnd, jni_rowcndId, jni_rowcnd);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbequ_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray r, jint _r_offset, jdoubleArray c, jint _c_offset, jdoublew rowcnd, jdoublew colcnd, jdoublew amax, jintw info) {
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
  jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "D");
  jdouble jni_rowcnd = (*env)->GetDoubleField(env, rowcnd, jni_rowcndId);
  jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
  jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "D");
  jdouble jni_colcnd = (*env)->GetDoubleField(env, colcnd, jni_colcndId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbequ_work(LAPACK_COL_MAJOR, m, n, kl, ku, jni_ab + _ab_offset, ldab, jni_r + _r_offset, jni_c + _c_offset, &jni_rowcnd, &jni_colcnd, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, colcnd, jni_colcndId, jni_colcnd);
  (*env)->SetDoubleField(env, rowcnd, jni_rowcndId, jni_rowcnd);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbrfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray afb, jint ldafb, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbrfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, kl, ku, nrhs, jni_ab, ldab, jni_afb, ldafb, jni_ipiv, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbrfs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray afb, jint _afb_offset, jint ldafb, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbrfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, kl, ku, nrhs, jni_ab + _ab_offset, ldab, jni_afb + _afb_offset, ldafb, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbsv (JNIEnv * env, jobject calling_obj, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint ldab, jintArray ipiv, jdoubleArray b, jint ldb, jintw info) {
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbsv_work(LAPACK_COL_MAJOR, n, kl, ku, nrhs, jni_ab, ldab, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbsv_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbsv_work(LAPACK_COL_MAJOR, n, kl, ku, nrhs, jni_ab + _ab_offset, ldab, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray afb, jint ldafb, jintArray ipiv, jstringw equed, jdoubleArray r, jdoubleArray c, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, kl, ku, nrhs, jni_ab, ldab, jni_afb, ldafb, jni_ipiv, jni_equed, jni_r, jni_c, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbsvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray afb, jint _afb_offset, jint ldafb, jintArray ipiv, jint _ipiv_offset, jstringw equed, jdoubleArray r, jint _r_offset, jdoubleArray c, jint _c_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, kl, ku, nrhs, jni_ab + _ab_offset, ldab, jni_afb + _afb_offset, ldafb, jni_ipiv + _ipiv_offset, jni_equed, jni_r + _r_offset, jni_c + _c_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbtrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jdoubleArray ab, jint ldab, jintArray ipiv, jintw info) {
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbtrf_work(LAPACK_COL_MAJOR, m, n, kl, ku, jni_ab, ldab, jni_ipiv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbtrf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jdoubleArray ab, jint _ab_offset, jint ldab, jintArray ipiv, jint _ipiv_offset, jintw info) {
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbtrf_work(LAPACK_COL_MAJOR, m, n, kl, ku, jni_ab + _ab_offset, ldab, jni_ipiv + _ipiv_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbtrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint ldab, jintArray ipiv, jdoubleArray b, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbtrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, kl, ku, nrhs, jni_ab, ldab, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgbtrs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgbtrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, kl, ku, nrhs, jni_ab + _ab_offset, ldab, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgebak (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jdoubleArray scale, jint m, jdoubleArray v, jint ldv, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jdouble * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgebak_work(LAPACK_COL_MAJOR, jni_job[0], jni_side[0], n, ilo, ihi, jni_scale, m, jni_v, ldv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgebak_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jdoubleArray scale, jint _scale_offset, jint m, jdoubleArray v, jint _v_offset, jint ldv, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jdouble * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgebak_work(LAPACK_COL_MAJOR, jni_job[0], jni_side[0], n, ilo, ihi, jni_scale + _scale_offset, m, jni_v + _v_offset, ldv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgebal (JNIEnv * env, jobject calling_obj, jstring job, jint n, jdoubleArray a, jint lda, jintw ilo, jintw ihi, jdoubleArray scale, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jdouble * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgebal_work(LAPACK_COL_MAJOR, jni_job[0], n, jni_a, lda, &jni_ilo, &jni_ihi, jni_scale);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgebal_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jint n, jdoubleArray a, jint _a_offset, jint lda, jintw ilo, jintw ihi, jdoubleArray scale, jint _scale_offset, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jdouble * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgebal_work(LAPACK_COL_MAJOR, jni_job[0], n, jni_a + _a_offset, lda, &jni_ilo, &jni_ihi, jni_scale + _scale_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgebrd (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray d, jdoubleArray e, jdoubleArray tauq, jdoubleArray taup, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_tauq = NULL;
  if (tauq != NULL) {
    jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
    check_memory(env, jni_tauq);
  }
  jdouble * jni_taup = NULL;
  if (taup != NULL) {
    jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
    check_memory(env, jni_taup);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgebrd_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_d, jni_e, jni_tauq, jni_taup, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (taup != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
  }
  if (tauq != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgebrd_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray tauq, jint _tauq_offset, jdoubleArray taup, jint _taup_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_tauq = NULL;
  if (tauq != NULL) {
    jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
    check_memory(env, jni_tauq);
  }
  jdouble * jni_taup = NULL;
  if (taup != NULL) {
    jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
    check_memory(env, jni_taup);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgebrd_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_d + _d_offset, jni_e + _e_offset, jni_tauq + _tauq_offset, jni_taup + _taup_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (taup != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
  }
  if (tauq != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgecon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jdoubleArray a, jint lda, jdouble anorm, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgecon_work(LAPACK_COL_MAJOR, jni_norm[0], n, jni_a, lda, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgecon_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jdoubleArray a, jint _a_offset, jint lda, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgecon_work(LAPACK_COL_MAJOR, jni_norm[0], n, jni_a + _a_offset, lda, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeequ (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray r, jdoubleArray c, jdoublew rowcnd, jdoublew colcnd, jdoublew amax, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
  jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "D");
  jdouble jni_rowcnd = (*env)->GetDoubleField(env, rowcnd, jni_rowcndId);
  jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
  jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "D");
  jdouble jni_colcnd = (*env)->GetDoubleField(env, colcnd, jni_colcndId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeequ_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_r, jni_c, &jni_rowcnd, &jni_colcnd, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, colcnd, jni_colcndId, jni_colcnd);
  (*env)->SetDoubleField(env, rowcnd, jni_rowcndId, jni_rowcnd);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeequ_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray r, jint _r_offset, jdoubleArray c, jint _c_offset, jdoublew rowcnd, jdoublew colcnd, jdoublew amax, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
  jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "D");
  jdouble jni_rowcnd = (*env)->GetDoubleField(env, rowcnd, jni_rowcndId);
  jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
  jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "D");
  jdouble jni_colcnd = (*env)->GetDoubleField(env, colcnd, jni_colcndId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeequ_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_r + _r_offset, jni_c + _c_offset, &jni_rowcnd, &jni_colcnd, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, colcnd, jni_colcndId, jni_colcnd);
  (*env)->SetDoubleField(env, rowcnd, jni_rowcndId, jni_rowcnd);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeev (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jdoubleArray a, jint lda, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray work, jint lwork, jintw info) {
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeev_work(LAPACK_COL_MAJOR, jni_jobvl[0], jni_jobvr[0], n, jni_a, lda, jni_wr, jni_wi, jni_vl, ldvl, jni_vr, ldvr, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeev_1offsets (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray wr, jint _wr_offset, jdoubleArray wi, jint _wi_offset, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeev_work(LAPACK_COL_MAJOR, jni_jobvl[0], jni_jobvr[0], n, jni_a + _a_offset, lda, jni_wr + _wr_offset, jni_wi + _wi_offset, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeevx (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jdoubleArray a, jint lda, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jintw ilo, jintw ihi, jdoubleArray scale, jdoublew abnrm, jdoubleArray rconde, jdoubleArray rcondv, jdoubleArray work, jint lwork, jintArray iwork, jintw info) {
  char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jdouble * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
  jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "D");
  jdouble jni_abnrm = (*env)->GetDoubleField(env, abnrm, jni_abnrmId);
  jdouble * jni_rconde = NULL;
  if (rconde != NULL) {
    jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
    check_memory(env, jni_rconde);
  }
  jdouble * jni_rcondv = NULL;
  if (rcondv != NULL) {
    jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
    check_memory(env, jni_rcondv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeevx_work(LAPACK_COL_MAJOR, jni_balanc[0], jni_jobvl[0], jni_jobvr[0], jni_sense[0], n, jni_a, lda, jni_wr, jni_wi, jni_vl, ldvl, jni_vr, ldvr, &jni_ilo, &jni_ihi, jni_scale, &jni_abnrm, jni_rconde, jni_rcondv, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rcondv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
  }
  if (rconde != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
  }
  (*env)->SetDoubleField(env, abnrm, jni_abnrmId, jni_abnrm);
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, sense, jni_sense);
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
  (*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeevx_1offsets (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray wr, jint _wr_offset, jdoubleArray wi, jint _wi_offset, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jintw ilo, jintw ihi, jdoubleArray scale, jint _scale_offset, jdoublew abnrm, jdoubleArray rconde, jint _rconde_offset, jdoubleArray rcondv, jint _rcondv_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jdouble * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
  jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "D");
  jdouble jni_abnrm = (*env)->GetDoubleField(env, abnrm, jni_abnrmId);
  jdouble * jni_rconde = NULL;
  if (rconde != NULL) {
    jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
    check_memory(env, jni_rconde);
  }
  jdouble * jni_rcondv = NULL;
  if (rcondv != NULL) {
    jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
    check_memory(env, jni_rcondv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeevx_work(LAPACK_COL_MAJOR, jni_balanc[0], jni_jobvl[0], jni_jobvr[0], jni_sense[0], n, jni_a + _a_offset, lda, jni_wr + _wr_offset, jni_wi + _wi_offset, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, &jni_ilo, &jni_ihi, jni_scale + _scale_offset, &jni_abnrm, jni_rconde + _rconde_offset, jni_rcondv + _rcondv_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rcondv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
  }
  if (rconde != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
  }
  (*env)->SetDoubleField(env, abnrm, jni_abnrmId, jni_abnrm);
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, sense, jni_sense);
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
  (*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgehrd (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgehrd_work(LAPACK_COL_MAJOR, n, ilo, ihi, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgehrd_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgehrd_work(LAPACK_COL_MAJOR, n, ilo, ihi, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelq2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelq2_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelq2_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelq2_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelqf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelqf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelqf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgels (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray work, jint lwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgels_work(LAPACK_COL_MAJOR, jni_trans[0], m, n, nrhs, jni_a, lda, jni_b, ldb, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgels_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgels_work(LAPACK_COL_MAJOR, jni_trans[0], m, n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelsd (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray s, jdouble rcond, jintw rank, jdoubleArray work, jint lwork, jintArray iwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelsd_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a, lda, jni_b, ldb, jni_s, rcond, &jni_rank, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelsd_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray s, jint _s_offset, jdouble rcond, jintw rank, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelsd_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_s + _s_offset, rcond, &jni_rank, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelss (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray s, jdouble rcond, jintw rank, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelss_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a, lda, jni_b, ldb, jni_s, rcond, &jni_rank, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelss_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray s, jint _s_offset, jdouble rcond, jintw rank, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelss_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_s + _s_offset, rcond, &jni_rank, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelsy (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jintArray jpvt, jdouble rcond, jintw rank, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelsy_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a, lda, jni_b, ldb, jni_jpvt, rcond, &jni_rank, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgelsy_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jintArray jpvt, jint _jpvt_offset, jdouble rcond, jintw rank, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgelsy_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_jpvt + _jpvt_offset, rcond, &jni_rank, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqlf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqlf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqlf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqlf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqp3 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jintArray jpvt, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqp3_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_jpvt, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqp3_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jintArray jpvt, jint _jpvt_offset, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqp3_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_jpvt + _jpvt_offset, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqpf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jintArray jpvt, jdoubleArray tau, jdoubleArray work, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqpf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_jpvt, jni_tau, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqpf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jintArray jpvt, jint _jpvt_offset, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqpf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_jpvt + _jpvt_offset, jni_tau + _tau_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqr2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqr2_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqr2_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqr2_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqrf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgeqrf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgeqrf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgerfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgerfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_a, lda, jni_af, ldaf, jni_ipiv, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgerfs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray af, jint _af_offset, jint ldaf, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgerfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_a + _a_offset, lda, jni_af + _af_offset, ldaf, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgerqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgerqf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgerqf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgerqf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgesdd (JNIEnv * env, jobject calling_obj, jstring jobz, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray s, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jdoubleArray work, jint lwork, jintArray iwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgesdd_work(LAPACK_COL_MAJOR, jni_jobz[0], m, n, jni_a, lda, jni_s, jni_u, ldu, jni_vt, ldvt, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgesdd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray s, jint _s_offset, jdoubleArray u, jint _u_offset, jint ldu, jdoubleArray vt, jint _vt_offset, jint ldvt, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgesdd_work(LAPACK_COL_MAJOR, jni_jobz[0], m, n, jni_a + _a_offset, lda, jni_s + _s_offset, jni_u + _u_offset, ldu, jni_vt + _vt_offset, ldvt, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgesv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgesv_work(LAPACK_COL_MAJOR, n, nrhs, jni_a, lda, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgesv_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgesv_work(LAPACK_COL_MAJOR, n, nrhs, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgesvd (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobvt, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray s, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jdoubleArray work, jint lwork, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobvt = (char *)(*env)->GetStringUTFChars(env, jobvt, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgesvd_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobvt[0], m, n, jni_a, lda, jni_s, jni_u, ldu, jni_vt, ldvt, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvt, jni_jobvt);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgesvd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobvt, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray s, jint _s_offset, jdoubleArray u, jint _u_offset, jint ldu, jdoubleArray vt, jint _vt_offset, jint ldvt, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobvt = (char *)(*env)->GetStringUTFChars(env, jobvt, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgesvd_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobvt[0], m, n, jni_a + _a_offset, lda, jni_s + _s_offset, jni_u + _u_offset, ldu, jni_vt + _vt_offset, ldvt, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvt, jni_jobvt);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgesvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jintArray ipiv, jstringw equed, jdoubleArray r, jdoubleArray c, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgesvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, nrhs, jni_a, lda, jni_af, ldaf, jni_ipiv, jni_equed, jni_r, jni_c, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgesvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray af, jint _af_offset, jint ldaf, jintArray ipiv, jint _ipiv_offset, jstringw equed, jdoubleArray r, jint _r_offset, jdoubleArray c, jint _c_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgesvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, nrhs, jni_a + _a_offset, lda, jni_af + _af_offset, ldaf, jni_ipiv + _ipiv_offset, jni_equed, jni_r + _r_offset, jni_c + _c_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgetf2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jintArray ipiv, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgetf2_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_ipiv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgetf2_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgetf2_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgetrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jintArray ipiv, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgetrf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_ipiv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgetrf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgetrf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgetri (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgetri_work(LAPACK_COL_MAJOR, n, jni_a, lda, jni_ipiv, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgetri_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgetri_work(LAPACK_COL_MAJOR, n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgetrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgetrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_a, lda, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgetrs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgetrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggbak (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jdoubleArray lscale, jdoubleArray rscale, jint m, jdoubleArray v, jint ldv, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jdouble * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jdouble * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggbak_work(LAPACK_COL_MAJOR, jni_job[0], jni_side[0], n, ilo, ihi, jni_lscale, jni_rscale, m, jni_v, ldv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggbak_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jdoubleArray lscale, jint _lscale_offset, jdoubleArray rscale, jint _rscale_offset, jint m, jdoubleArray v, jint _v_offset, jint ldv, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jdouble * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jdouble * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggbak_work(LAPACK_COL_MAJOR, jni_job[0], jni_side[0], n, ilo, ihi, jni_lscale + _lscale_offset, jni_rscale + _rscale_offset, m, jni_v + _v_offset, ldv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggbal (JNIEnv * env, jobject calling_obj, jstring job, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jintw ilo, jintw ihi, jdoubleArray lscale, jdoubleArray rscale, jdoubleArray work, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jdouble * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jdouble * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggbal_work(LAPACK_COL_MAJOR, jni_job[0], n, jni_a, lda, jni_b, ldb, &jni_ilo, &jni_ihi, jni_lscale, jni_rscale, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggbal_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jintw ilo, jintw ihi, jdoubleArray lscale, jint _lscale_offset, jdoubleArray rscale, jint _rscale_offset, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jdouble * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jdouble * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggbal_work(LAPACK_COL_MAJOR, jni_job[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, &jni_ilo, &jni_ihi, jni_lscale + _lscale_offset, jni_rscale + _rscale_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggev (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray work, jint lwork, jintw info) {
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jdouble * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggev_work(LAPACK_COL_MAJOR, jni_jobvl[0], jni_jobvr[0], n, jni_a, lda, jni_b, ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, ldvl, jni_vr, ldvr, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggev_1offsets (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray alphar, jint _alphar_offset, jdoubleArray alphai, jint _alphai_offset, jdoubleArray beta, jint _beta_offset, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jdouble * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggev_work(LAPACK_COL_MAJOR, jni_jobvl[0], jni_jobvr[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_alphar + _alphar_offset, jni_alphai + _alphai_offset, jni_beta + _beta_offset, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggevx (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jintw ilo, jintw ihi, jdoubleArray lscale, jdoubleArray rscale, jdoublew abnrm, jdoublew bbnrm, jdoubleArray rconde, jdoubleArray rcondv, jdoubleArray work, jint lwork, jintArray iwork, jbooleanArray bwork, jintw info) {
  char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jdouble * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jdouble * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jdouble * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
  jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "D");
  jdouble jni_abnrm = (*env)->GetDoubleField(env, abnrm, jni_abnrmId);
  jclass jni_bbnrmClass = (*env)->GetObjectClass(env, bbnrm);
  jfieldID jni_bbnrmId = (*env)->GetFieldID(env, jni_bbnrmClass, "val", "D");
  jdouble jni_bbnrm = (*env)->GetDoubleField(env, bbnrm, jni_bbnrmId);
  jdouble * jni_rconde = NULL;
  if (rconde != NULL) {
    jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
    check_memory(env, jni_rconde);
  }
  jdouble * jni_rcondv = NULL;
  if (rcondv != NULL) {
    jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
    check_memory(env, jni_rcondv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jboolean * jni_bwork_raw = NULL;
  jint jni_bwork_size = 0;
  int* jni_bwork = NULL;
  if (bwork != NULL) {
    jni_bwork_raw = (*env)->GetPrimitiveArrayCritical(env, bwork, JNI_FALSE);
    check_memory(env, jni_bwork_raw);
    jni_bwork_size = (*env)->GetArrayLength(env, bwork);
    jni_bwork = jbooleanArray2intArray(env, jni_bwork_raw, jni_bwork_size);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggevx_work(LAPACK_COL_MAJOR, jni_balanc[0], jni_jobvl[0], jni_jobvr[0], jni_sense[0], n, jni_a, lda, jni_b, ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, ldvl, jni_vr, ldvr, &jni_ilo, &jni_ihi, jni_lscale, jni_rscale, &jni_abnrm, &jni_bbnrm, jni_rconde, jni_rcondv, jni_work, lwork, jni_iwork, jni_bwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (bwork != NULL) {
    intArray2jbooleanArray(jni_bwork, jni_bwork_raw, jni_bwork_size);
    free(jni_bwork);
    (*env)->ReleasePrimitiveArrayCritical(env, bwork, jni_bwork_raw, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rcondv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
  }
  if (rconde != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
  }
  (*env)->SetDoubleField(env, bbnrm, jni_bbnrmId, jni_bbnrm);
  (*env)->SetDoubleField(env, abnrm, jni_abnrmId, jni_abnrm);
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, sense, jni_sense);
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
  (*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggevx_1offsets (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray alphar, jint _alphar_offset, jdoubleArray alphai, jint _alphai_offset, jdoubleArray beta, jint _beta_offset, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jintw ilo, jintw ihi, jdoubleArray lscale, jint _lscale_offset, jdoubleArray rscale, jint _rscale_offset, jdoublew abnrm, jdoublew bbnrm, jdoubleArray rconde, jint _rconde_offset, jdoubleArray rcondv, jint _rcondv_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jbooleanArray bwork, jint _bwork_offset, jintw info) {
  char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jdouble * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jdouble * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jdouble * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
  jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "D");
  jdouble jni_abnrm = (*env)->GetDoubleField(env, abnrm, jni_abnrmId);
  jclass jni_bbnrmClass = (*env)->GetObjectClass(env, bbnrm);
  jfieldID jni_bbnrmId = (*env)->GetFieldID(env, jni_bbnrmClass, "val", "D");
  jdouble jni_bbnrm = (*env)->GetDoubleField(env, bbnrm, jni_bbnrmId);
  jdouble * jni_rconde = NULL;
  if (rconde != NULL) {
    jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
    check_memory(env, jni_rconde);
  }
  jdouble * jni_rcondv = NULL;
  if (rcondv != NULL) {
    jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
    check_memory(env, jni_rcondv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jboolean * jni_bwork_raw = NULL;
  jint jni_bwork_size = 0;
  int* jni_bwork = NULL;
  if (bwork != NULL) {
    jni_bwork_raw = (*env)->GetPrimitiveArrayCritical(env, bwork, JNI_FALSE);
    check_memory(env, jni_bwork_raw);
    jni_bwork_size = (*env)->GetArrayLength(env, bwork);
    jni_bwork = jbooleanArray2intArray(env, jni_bwork_raw, jni_bwork_size);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggevx_work(LAPACK_COL_MAJOR, jni_balanc[0], jni_jobvl[0], jni_jobvr[0], jni_sense[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_alphar + _alphar_offset, jni_alphai + _alphai_offset, jni_beta + _beta_offset, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, &jni_ilo, &jni_ihi, jni_lscale + _lscale_offset, jni_rscale + _rscale_offset, &jni_abnrm, &jni_bbnrm, jni_rconde + _rconde_offset, jni_rcondv + _rcondv_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, jni_bwork + _bwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (bwork != NULL) {
    intArray2jbooleanArray(jni_bwork, jni_bwork_raw, jni_bwork_size);
    free(jni_bwork);
    (*env)->ReleasePrimitiveArrayCritical(env, bwork, jni_bwork_raw, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rcondv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
  }
  if (rconde != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
  }
  (*env)->SetDoubleField(env, bbnrm, jni_bbnrmId, jni_bbnrm);
  (*env)->SetDoubleField(env, abnrm, jni_abnrmId, jni_abnrm);
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, sense, jni_sense);
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
  (*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggglm (JNIEnv * env, jobject calling_obj, jint n, jint m, jint p, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray d, jdoubleArray x, jdoubleArray y, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggglm_work(LAPACK_COL_MAJOR, n, m, p, jni_a, lda, jni_b, ldb, jni_d, jni_x, jni_y, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggglm_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint m, jint p, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray d, jint _d_offset, jdoubleArray x, jint _x_offset, jdoubleArray y, jint _y_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggglm_work(LAPACK_COL_MAJOR, n, m, p, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_d + _d_offset, jni_x + _x_offset, jni_y + _y_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgghrd (JNIEnv * env, jobject calling_obj, jstring compq, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jintw info) {
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgghrd_work(LAPACK_COL_MAJOR, jni_compq[0], jni_compz[0], n, ilo, ihi, jni_a, lda, jni_b, ldb, jni_q, ldq, jni_z, ldz);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgghrd_1offsets (JNIEnv * env, jobject calling_obj, jstring compq, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray z, jint _z_offset, jint ldz, jintw info) {
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgghrd_work(LAPACK_COL_MAJOR, jni_compq[0], jni_compz[0], n, ilo, ihi, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_q + _q_offset, ldq, jni_z + _z_offset, ldz);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgglse (JNIEnv * env, jobject calling_obj, jint m, jint n, jint p, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray c, jdoubleArray d, jdoubleArray x, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgglse_work(LAPACK_COL_MAJOR, m, n, p, jni_a, lda, jni_b, ldb, jni_c, jni_d, jni_x, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgglse_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint p, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray c, jint _c_offset, jdoubleArray d, jint _d_offset, jdoubleArray x, jint _x_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgglse_work(LAPACK_COL_MAJOR, m, n, p, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_c + _c_offset, jni_d + _d_offset, jni_x + _x_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggqrf (JNIEnv * env, jobject calling_obj, jint n, jint m, jint p, jdoubleArray a, jint lda, jdoubleArray taua, jdoubleArray b, jint ldb, jdoubleArray taub, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_taua = NULL;
  if (taua != NULL) {
    jni_taua = (*env)->GetPrimitiveArrayCritical(env, taua, JNI_FALSE);
    check_memory(env, jni_taua);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_taub = NULL;
  if (taub != NULL) {
    jni_taub = (*env)->GetPrimitiveArrayCritical(env, taub, JNI_FALSE);
    check_memory(env, jni_taub);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggqrf_work(LAPACK_COL_MAJOR, n, m, p, jni_a, lda, jni_taua, jni_b, ldb, jni_taub, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (taub != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taub, jni_taub, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (taua != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taua, jni_taua, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggqrf_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint m, jint p, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray taua, jint _taua_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray taub, jint _taub_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_taua = NULL;
  if (taua != NULL) {
    jni_taua = (*env)->GetPrimitiveArrayCritical(env, taua, JNI_FALSE);
    check_memory(env, jni_taua);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_taub = NULL;
  if (taub != NULL) {
    jni_taub = (*env)->GetPrimitiveArrayCritical(env, taub, JNI_FALSE);
    check_memory(env, jni_taub);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggqrf_work(LAPACK_COL_MAJOR, n, m, p, jni_a + _a_offset, lda, jni_taua + _taua_offset, jni_b + _b_offset, ldb, jni_taub + _taub_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (taub != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taub, jni_taub, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (taua != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taua, jni_taua, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggrqf (JNIEnv * env, jobject calling_obj, jint m, jint p, jint n, jdoubleArray a, jint lda, jdoubleArray taua, jdoubleArray b, jint ldb, jdoubleArray taub, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_taua = NULL;
  if (taua != NULL) {
    jni_taua = (*env)->GetPrimitiveArrayCritical(env, taua, JNI_FALSE);
    check_memory(env, jni_taua);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_taub = NULL;
  if (taub != NULL) {
    jni_taub = (*env)->GetPrimitiveArrayCritical(env, taub, JNI_FALSE);
    check_memory(env, jni_taub);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggrqf_work(LAPACK_COL_MAJOR, m, p, n, jni_a, lda, jni_taua, jni_b, ldb, jni_taub, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (taub != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taub, jni_taub, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (taua != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taua, jni_taua, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggrqf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint p, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray taua, jint _taua_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray taub, jint _taub_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_taua = NULL;
  if (taua != NULL) {
    jni_taua = (*env)->GetPrimitiveArrayCritical(env, taua, JNI_FALSE);
    check_memory(env, jni_taua);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_taub = NULL;
  if (taub != NULL) {
    jni_taub = (*env)->GetPrimitiveArrayCritical(env, taub, JNI_FALSE);
    check_memory(env, jni_taub);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggrqf_work(LAPACK_COL_MAJOR, m, p, n, jni_a + _a_offset, lda, jni_taua + _taua_offset, jni_b + _b_offset, ldb, jni_taub + _taub_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (taub != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taub, jni_taub, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (taua != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taua, jni_taua, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggsvd (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint n, jint p, jintw k, jintw l, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alpha, jdoubleArray beta, jdoubleArray u, jint ldu, jdoubleArray v, jint ldv, jdoubleArray q, jint ldq, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
  char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
  jclass jni_kClass = (*env)->GetObjectClass(env, k);
  jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
  jint jni_k = (*env)->GetIntField(env, k, jni_kId);
  jclass jni_lClass = (*env)->GetObjectClass(env, l);
  jfieldID jni_lId = (*env)->GetFieldID(env, jni_lClass, "val", "I");
  jint jni_l = (*env)->GetIntField(env, l, jni_lId);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alpha = NULL;
  if (alpha != NULL) {
    jni_alpha = (*env)->GetPrimitiveArrayCritical(env, alpha, JNI_FALSE);
    check_memory(env, jni_alpha);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggsvd_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobv[0], jni_jobq[0], m, n, p, &jni_k, &jni_l, jni_a, lda, jni_b, ldb, jni_alpha, jni_beta, jni_u, ldu, jni_v, ldv, jni_q, ldq, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alpha != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alpha, jni_alpha, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->SetIntField(env, l, jni_lId, jni_l);
  (*env)->SetIntField(env, k, jni_kId, jni_k);
  (*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
  (*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggsvd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint n, jint p, jintw k, jintw l, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray alpha, jint _alpha_offset, jdoubleArray beta, jint _beta_offset, jdoubleArray u, jint _u_offset, jint ldu, jdoubleArray v, jint _v_offset, jint ldv, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
  char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
  jclass jni_kClass = (*env)->GetObjectClass(env, k);
  jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
  jint jni_k = (*env)->GetIntField(env, k, jni_kId);
  jclass jni_lClass = (*env)->GetObjectClass(env, l);
  jfieldID jni_lId = (*env)->GetFieldID(env, jni_lClass, "val", "I");
  jint jni_l = (*env)->GetIntField(env, l, jni_lId);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alpha = NULL;
  if (alpha != NULL) {
    jni_alpha = (*env)->GetPrimitiveArrayCritical(env, alpha, JNI_FALSE);
    check_memory(env, jni_alpha);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggsvd_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobv[0], jni_jobq[0], m, n, p, &jni_k, &jni_l, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_alpha + _alpha_offset, jni_beta + _beta_offset, jni_u + _u_offset, ldu, jni_v + _v_offset, ldv, jni_q + _q_offset, ldq, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alpha != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alpha, jni_alpha, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->SetIntField(env, l, jni_lId, jni_l);
  (*env)->SetIntField(env, k, jni_kId, jni_k);
  (*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
  (*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggsvp (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint p, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble tola, jdouble tolb, jintw k, jintw l, jdoubleArray u, jint ldu, jdoubleArray v, jint ldv, jdoubleArray q, jint ldq, jintArray iwork, jdoubleArray tau, jdoubleArray work, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
  char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_kClass = (*env)->GetObjectClass(env, k);
  jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
  jint jni_k = (*env)->GetIntField(env, k, jni_kId);
  jclass jni_lClass = (*env)->GetObjectClass(env, l);
  jfieldID jni_lId = (*env)->GetFieldID(env, jni_lClass, "val", "I");
  jint jni_l = (*env)->GetIntField(env, l, jni_lId);
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggsvp_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobv[0], jni_jobq[0], m, p, n, jni_a, lda, jni_b, ldb, tola, tolb, &jni_k, &jni_l, jni_u, ldu, jni_v, ldv, jni_q, ldq, jni_iwork, jni_tau, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  (*env)->SetIntField(env, l, jni_lId, jni_l);
  (*env)->SetIntField(env, k, jni_kId, jni_k);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
  (*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dggsvp_1offsets (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint p, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdouble tola, jdouble tolb, jintw k, jintw l, jdoubleArray u, jint _u_offset, jint ldu, jdoubleArray v, jint _v_offset, jint ldv, jdoubleArray q, jint _q_offset, jint ldq, jintArray iwork, jint _iwork_offset, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
  char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_kClass = (*env)->GetObjectClass(env, k);
  jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
  jint jni_k = (*env)->GetIntField(env, k, jni_kId);
  jclass jni_lClass = (*env)->GetObjectClass(env, l);
  jfieldID jni_lId = (*env)->GetFieldID(env, jni_lClass, "val", "I");
  jint jni_l = (*env)->GetIntField(env, l, jni_lId);
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dggsvp_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobv[0], jni_jobq[0], m, p, n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, tola, tolb, &jni_k, &jni_l, jni_u + _u_offset, ldu, jni_v + _v_offset, ldv, jni_q + _q_offset, ldq, jni_iwork + _iwork_offset, jni_tau + _tau_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  (*env)->SetIntField(env, l, jni_lId, jni_l);
  (*env)->SetIntField(env, k, jni_kId, jni_k);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
  (*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgtcon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jdouble anorm, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgtcon_work(jni_norm[0], n, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgtcon_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jdoubleArray dl, jint _dl_offset, jdoubleArray d, jint _d_offset, jdoubleArray du, jint _du_offset, jdoubleArray du2, jint _du2_offset, jintArray ipiv, jint _ipiv_offset, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgtcon_work(jni_norm[0], n, jni_dl + _dl_offset, jni_d + _d_offset, jni_du + _du_offset, jni_du2 + _du2_offset, jni_ipiv + _ipiv_offset, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgtrfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray dlf, jdoubleArray df, jdoubleArray duf, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_dlf = NULL;
  if (dlf != NULL) {
    jni_dlf = (*env)->GetPrimitiveArrayCritical(env, dlf, JNI_FALSE);
    check_memory(env, jni_dlf);
  }
  jdouble * jni_df = NULL;
  if (df != NULL) {
    jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
    check_memory(env, jni_df);
  }
  jdouble * jni_duf = NULL;
  if (duf != NULL) {
    jni_duf = (*env)->GetPrimitiveArrayCritical(env, duf, JNI_FALSE);
    check_memory(env, jni_duf);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgtrfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_dl, jni_d, jni_du, jni_dlf, jni_df, jni_duf, jni_du2, jni_ipiv, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (duf != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, duf, jni_duf, 0);
  }
  if (df != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
  }
  if (dlf != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dlf, jni_dlf, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgtrfs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray dl, jint _dl_offset, jdoubleArray d, jint _d_offset, jdoubleArray du, jint _du_offset, jdoubleArray dlf, jint _dlf_offset, jdoubleArray df, jint _df_offset, jdoubleArray duf, jint _duf_offset, jdoubleArray du2, jint _du2_offset, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_dlf = NULL;
  if (dlf != NULL) {
    jni_dlf = (*env)->GetPrimitiveArrayCritical(env, dlf, JNI_FALSE);
    check_memory(env, jni_dlf);
  }
  jdouble * jni_df = NULL;
  if (df != NULL) {
    jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
    check_memory(env, jni_df);
  }
  jdouble * jni_duf = NULL;
  if (duf != NULL) {
    jni_duf = (*env)->GetPrimitiveArrayCritical(env, duf, JNI_FALSE);
    check_memory(env, jni_duf);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgtrfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_dl + _dl_offset, jni_d + _d_offset, jni_du + _du_offset, jni_dlf + _dlf_offset, jni_df + _df_offset, jni_duf + _duf_offset, jni_du2 + _du2_offset, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (duf != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, duf, jni_duf, 0);
  }
  if (df != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
  }
  if (dlf != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dlf, jni_dlf, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgtsv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray b, jint ldb, jintw info) {
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgtsv_work(LAPACK_COL_MAJOR, n, nrhs, jni_dl, jni_d, jni_du, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgtsv_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray dl, jint _dl_offset, jdoubleArray d, jint _d_offset, jdoubleArray du, jint _du_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgtsv_work(LAPACK_COL_MAJOR, n, nrhs, jni_dl + _dl_offset, jni_d + _d_offset, jni_du + _du_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgtsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray dlf, jdoubleArray df, jdoubleArray duf, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_dlf = NULL;
  if (dlf != NULL) {
    jni_dlf = (*env)->GetPrimitiveArrayCritical(env, dlf, JNI_FALSE);
    check_memory(env, jni_dlf);
  }
  jdouble * jni_df = NULL;
  if (df != NULL) {
    jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
    check_memory(env, jni_df);
  }
  jdouble * jni_duf = NULL;
  if (duf != NULL) {
    jni_duf = (*env)->GetPrimitiveArrayCritical(env, duf, JNI_FALSE);
    check_memory(env, jni_duf);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgtsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, nrhs, jni_dl, jni_d, jni_du, jni_dlf, jni_df, jni_duf, jni_du2, jni_ipiv, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (duf != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, duf, jni_duf, 0);
  }
  if (df != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
  }
  if (dlf != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dlf, jni_dlf, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgtsvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jdoubleArray dl, jint _dl_offset, jdoubleArray d, jint _d_offset, jdoubleArray du, jint _du_offset, jdoubleArray dlf, jint _dlf_offset, jdoubleArray df, jint _df_offset, jdoubleArray duf, jint _duf_offset, jdoubleArray du2, jint _du2_offset, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_dlf = NULL;
  if (dlf != NULL) {
    jni_dlf = (*env)->GetPrimitiveArrayCritical(env, dlf, JNI_FALSE);
    check_memory(env, jni_dlf);
  }
  jdouble * jni_df = NULL;
  if (df != NULL) {
    jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
    check_memory(env, jni_df);
  }
  jdouble * jni_duf = NULL;
  if (duf != NULL) {
    jni_duf = (*env)->GetPrimitiveArrayCritical(env, duf, JNI_FALSE);
    check_memory(env, jni_duf);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgtsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, nrhs, jni_dl + _dl_offset, jni_d + _d_offset, jni_du + _du_offset, jni_dlf + _dlf_offset, jni_df + _df_offset, jni_duf + _duf_offset, jni_du2 + _du2_offset, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (duf != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, duf, jni_duf, 0);
  }
  if (df != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
  }
  if (dlf != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dlf, jni_dlf, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgttrf (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jintw info) {
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgttrf_work(n, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgttrf_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dl, jint _dl_offset, jdoubleArray d, jint _d_offset, jdoubleArray du, jint _du_offset, jdoubleArray du2, jint _du2_offset, jintArray ipiv, jint _ipiv_offset, jintw info) {
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgttrf_work(n, jni_dl + _dl_offset, jni_d + _d_offset, jni_du + _du_offset, jni_du2 + _du2_offset, jni_ipiv + _ipiv_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgttrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgttrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dgttrs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray dl, jint _dl_offset, jdoubleArray d, jint _d_offset, jdoubleArray du, jint _du_offset, jdoubleArray du2, jint _du2_offset, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_dl = NULL;
  if (dl != NULL) {
    jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
    check_memory(env, jni_dl);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_du = NULL;
  if (du != NULL) {
    jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
    check_memory(env, jni_du);
  }
  jdouble * jni_du2 = NULL;
  if (du2 != NULL) {
    jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
    check_memory(env, jni_du2);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dgttrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_dl + _dl_offset, jni_d + _d_offset, jni_du + _du_offset, jni_du2 + _du2_offset, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (du2 != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
  }
  if (du != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (dl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dhgeqz (JNIEnv * env, jobject calling_obj, jstring job, jstring compq, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray h, jint ldh, jdoubleArray t, jint ldt, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_h = NULL;
  if (h != NULL) {
    jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
    check_memory(env, jni_h);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jdouble * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dhgeqz_work(LAPACK_COL_MAJOR, jni_job[0], jni_compq[0], jni_compz[0], n, ilo, ihi, jni_h, ldh, jni_t, ldt, jni_alphar, jni_alphai, jni_beta, jni_q, ldq, jni_z, ldz, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (h != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dhgeqz_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring compq, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray h, jint _h_offset, jint ldh, jdoubleArray t, jint _t_offset, jint ldt, jdoubleArray alphar, jint _alphar_offset, jdoubleArray alphai, jint _alphai_offset, jdoubleArray beta, jint _beta_offset, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_h = NULL;
  if (h != NULL) {
    jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
    check_memory(env, jni_h);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jdouble * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dhgeqz_work(LAPACK_COL_MAJOR, jni_job[0], jni_compq[0], jni_compz[0], n, ilo, ihi, jni_h + _h_offset, ldh, jni_t + _t_offset, ldt, jni_alphar + _alphar_offset, jni_alphai + _alphai_offset, jni_beta + _beta_offset, jni_q + _q_offset, ldq, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (h != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dhsein (JNIEnv * env, jobject calling_obj, jstring side, jstring eigsrc, jstring initv, jbooleanArray select, jint n, jdoubleArray h, jint ldh, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jint mm, jintw m, jdoubleArray work, jintArray ifaill, jintArray ifailr, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_eigsrc = (char *)(*env)->GetStringUTFChars(env, eigsrc, JNI_FALSE);
  char * jni_initv = (char *)(*env)->GetStringUTFChars(env, initv, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_h = NULL;
  if (h != NULL) {
    jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
    check_memory(env, jni_h);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_ifaill = NULL;
  if (ifaill != NULL) {
    jni_ifaill = (*env)->GetPrimitiveArrayCritical(env, ifaill, JNI_FALSE);
    check_memory(env, jni_ifaill);
  }
  jint * jni_ifailr = NULL;
  if (ifailr != NULL) {
    jni_ifailr = (*env)->GetPrimitiveArrayCritical(env, ifailr, JNI_FALSE);
    check_memory(env, jni_ifailr);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dhsein_work(LAPACK_COL_MAJOR, jni_side[0], jni_eigsrc[0], jni_initv[0], jni_select, n, jni_h, ldh, jni_wr, jni_wi, jni_vl, ldvl, jni_vr, ldvr, mm, &jni_m, jni_work, jni_ifaill, jni_ifailr);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifailr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifailr, jni_ifailr, 0);
  }
  if (ifaill != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifaill, jni_ifaill, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (h != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, initv, jni_initv);
  (*env)->ReleaseStringUTFChars(env, eigsrc, jni_eigsrc);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dhsein_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring eigsrc, jstring initv, jbooleanArray select, jint _select_offset, jint n, jdoubleArray h, jint _h_offset, jint ldh, jdoubleArray wr, jint _wr_offset, jdoubleArray wi, jint _wi_offset, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jint mm, jintw m, jdoubleArray work, jint _work_offset, jintArray ifaill, jint _ifaill_offset, jintArray ifailr, jint _ifailr_offset, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_eigsrc = (char *)(*env)->GetStringUTFChars(env, eigsrc, JNI_FALSE);
  char * jni_initv = (char *)(*env)->GetStringUTFChars(env, initv, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_h = NULL;
  if (h != NULL) {
    jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
    check_memory(env, jni_h);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_ifaill = NULL;
  if (ifaill != NULL) {
    jni_ifaill = (*env)->GetPrimitiveArrayCritical(env, ifaill, JNI_FALSE);
    check_memory(env, jni_ifaill);
  }
  jint * jni_ifailr = NULL;
  if (ifailr != NULL) {
    jni_ifailr = (*env)->GetPrimitiveArrayCritical(env, ifailr, JNI_FALSE);
    check_memory(env, jni_ifailr);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dhsein_work(LAPACK_COL_MAJOR, jni_side[0], jni_eigsrc[0], jni_initv[0], jni_select + _select_offset, n, jni_h + _h_offset, ldh, jni_wr + _wr_offset, jni_wi + _wi_offset, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, mm, &jni_m, jni_work + _work_offset, jni_ifaill + _ifaill_offset, jni_ifailr + _ifailr_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifailr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifailr, jni_ifailr, 0);
  }
  if (ifaill != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifaill, jni_ifaill, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (h != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, initv, jni_initv);
  (*env)->ReleaseStringUTFChars(env, eigsrc, jni_eigsrc);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dhseqr (JNIEnv * env, jobject calling_obj, jstring job, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray h, jint ldh, jdoubleArray wr, jdoubleArray wi, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_h = NULL;
  if (h != NULL) {
    jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
    check_memory(env, jni_h);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dhseqr_work(LAPACK_COL_MAJOR, jni_job[0], jni_compz[0], n, ilo, ihi, jni_h, ldh, jni_wr, jni_wi, jni_z, ldz, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (h != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dhseqr_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray h, jint _h_offset, jint ldh, jdoubleArray wr, jint _wr_offset, jdoubleArray wi, jint _wi_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_h = NULL;
  if (h != NULL) {
    jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
    check_memory(env, jni_h);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dhseqr_work(LAPACK_COL_MAJOR, jni_job[0], jni_compz[0], n, ilo, ihi, jni_h + _h_offset, ldh, jni_wr + _wr_offset, jni_wi + _wi_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (h != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlacpy (JNIEnv * env, jobject calling_obj, jstring uplo, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
LAPACKE_dlacpy_work(LAPACK_COL_MAJOR, jni_uplo[0], m, n, jni_a, lda, jni_b, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlacpy_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
LAPACKE_dlacpy_work(LAPACK_COL_MAJOR, jni_uplo[0], m, n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlag2s (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jfloatArray sa, jint ldsa, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_sa = NULL;
  if (sa != NULL) {
    jni_sa = (*env)->GetPrimitiveArrayCritical(env, sa, JNI_FALSE);
    check_memory(env, jni_sa);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dlag2s_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_sa, ldsa);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (sa != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sa, jni_sa, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlag2s_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jfloatArray sa, jint _sa_offset, jint ldsa, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_sa = NULL;
  if (sa != NULL) {
    jni_sa = (*env)->GetPrimitiveArrayCritical(env, sa, JNI_FALSE);
    check_memory(env, jni_sa);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dlag2s_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_sa + _sa_offset, ldsa);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (sa != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sa, jni_sa, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlange (JNIEnv * env, jobject calling_obj, jstring norm, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray work) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jdouble returnValue = LAPACKE_dlange_work(LAPACK_COL_MAJOR, jni_norm[0], m, n, jni_a, lda, jni_work);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlange_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray work, jint _work_offset) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jdouble returnValue = LAPACKE_dlange_work(LAPACK_COL_MAJOR, jni_norm[0], m, n, jni_a + _a_offset, lda, jni_work + _work_offset);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlansy (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray work) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jdouble returnValue = LAPACKE_dlansy_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], n, jni_a, lda, jni_work);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlansy_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray work, jint _work_offset) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jdouble returnValue = LAPACKE_dlansy_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], n, jni_a + _a_offset, lda, jni_work + _work_offset);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlantr (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray work) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jdouble returnValue = LAPACKE_dlantr_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], jni_diag[0], m, n, jni_a, lda, jni_work);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlantr_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray work, jint _work_offset) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jdouble returnValue = LAPACKE_dlantr_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], jni_diag[0], m, n, jni_a + _a_offset, lda, jni_work + _work_offset);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlapy2 (JNIEnv * env, jobject calling_obj, jdouble x, jdouble y) {
  jdouble returnValue = LAPACKE_dlapy2_work(x, y);
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlapy3 (JNIEnv * env, jobject calling_obj, jdouble x, jdouble y, jdouble z) {
  jdouble returnValue = LAPACKE_dlapy3_work(x, y, z);
  return returnValue;
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarfb (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jstring direct, jstring storev, jint m, jint n, jint k, jdoubleArray v, jint ldv, jdoubleArray t, jint ldt, jdoubleArray c, jint Ldc, jdoubleArray work, jint ldwork) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
  char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
LAPACKE_dlarfb_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], jni_direct[0], jni_storev[0], m, n, k, jni_v, ldv, jni_t, ldt, jni_c, Ldc, jni_work, ldwork);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  (*env)->ReleaseStringUTFChars(env, storev, jni_storev);
  (*env)->ReleaseStringUTFChars(env, direct, jni_direct);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarfb_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jstring direct, jstring storev, jint m, jint n, jint k, jdoubleArray v, jint _v_offset, jint ldv, jdoubleArray t, jint _t_offset, jint ldt, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint ldwork) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
  char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
LAPACKE_dlarfb_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], jni_direct[0], jni_storev[0], m, n, k, jni_v + _v_offset, ldv, jni_t + _t_offset, ldt, jni_c + _c_offset, Ldc, jni_work + _work_offset, ldwork);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  (*env)->ReleaseStringUTFChars(env, storev, jni_storev);
  (*env)->ReleaseStringUTFChars(env, direct, jni_direct);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarfg (JNIEnv * env, jobject calling_obj, jint n, jdoublew alpha, jdoubleArray x, jint incx, jdoublew tau) {
  jclass jni_alphaClass = (*env)->GetObjectClass(env, alpha);
  jfieldID jni_alphaId = (*env)->GetFieldID(env, jni_alphaClass, "val", "D");
  jdouble jni_alpha = (*env)->GetDoubleField(env, alpha, jni_alphaId);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_tauClass = (*env)->GetObjectClass(env, tau);
  jfieldID jni_tauId = (*env)->GetFieldID(env, jni_tauClass, "val", "D");
  jdouble jni_tau = (*env)->GetDoubleField(env, tau, jni_tauId);
LAPACKE_dlarfg_work(n, &jni_alpha, jni_x, incx, &jni_tau);
  (*env)->SetDoubleField(env, tau, jni_tauId, jni_tau);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->SetDoubleField(env, alpha, jni_alphaId, jni_alpha);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarfg_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoublew alpha, jdoubleArray x, jint _x_offset, jint incx, jdoublew tau) {
  jclass jni_alphaClass = (*env)->GetObjectClass(env, alpha);
  jfieldID jni_alphaId = (*env)->GetFieldID(env, jni_alphaClass, "val", "D");
  jdouble jni_alpha = (*env)->GetDoubleField(env, alpha, jni_alphaId);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_tauClass = (*env)->GetObjectClass(env, tau);
  jfieldID jni_tauId = (*env)->GetFieldID(env, jni_tauClass, "val", "D");
  jdouble jni_tau = (*env)->GetDoubleField(env, tau, jni_tauId);
LAPACKE_dlarfg_work(n, &jni_alpha, jni_x + _x_offset, incx, &jni_tau);
  (*env)->SetDoubleField(env, tau, jni_tauId, jni_tau);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->SetDoubleField(env, alpha, jni_alphaId, jni_alpha);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarft (JNIEnv * env, jobject calling_obj, jstring direct, jstring storev, jint n, jint k, jdoubleArray v, jint ldv, jdoubleArray tau, jdoubleArray t, jint ldt) {
  char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
  char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
LAPACKE_dlarft_work(LAPACK_COL_MAJOR, jni_direct[0], jni_storev[0], n, k, jni_v, ldv, jni_tau, jni_t, ldt);
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  (*env)->ReleaseStringUTFChars(env, storev, jni_storev);
  (*env)->ReleaseStringUTFChars(env, direct, jni_direct);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarft_1offsets (JNIEnv * env, jobject calling_obj, jstring direct, jstring storev, jint n, jint k, jdoubleArray v, jint _v_offset, jint ldv, jdoubleArray tau, jint _tau_offset, jdoubleArray t, jint _t_offset, jint ldt) {
  char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
  char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
LAPACKE_dlarft_work(LAPACK_COL_MAJOR, jni_direct[0], jni_storev[0], n, k, jni_v + _v_offset, ldv, jni_tau + _tau_offset, jni_t + _t_offset, ldt);
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  (*env)->ReleaseStringUTFChars(env, storev, jni_storev);
  (*env)->ReleaseStringUTFChars(env, direct, jni_direct);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarfx (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jdoubleArray v, jdouble tau, jdoubleArray c, jint Ldc, jdoubleArray work) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
LAPACKE_dlarfx_work(LAPACK_COL_MAJOR, jni_side[0], m, n, jni_v, tau, jni_c, Ldc, jni_work);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarfx_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jdoubleArray v, jint _v_offset, jdouble tau, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
LAPACKE_dlarfx_work(LAPACK_COL_MAJOR, jni_side[0], m, n, jni_v + _v_offset, tau, jni_c + _c_offset, Ldc, jni_work + _work_offset);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarnv (JNIEnv * env, jobject calling_obj, jint idist, jintArray iseed, jint n, jdoubleArray x) {
  jint * jni_iseed = NULL;
  if (iseed != NULL) {
    jni_iseed = (*env)->GetPrimitiveArrayCritical(env, iseed, JNI_FALSE);
    check_memory(env, jni_iseed);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
LAPACKE_dlarnv_work(idist, jni_iseed, n, jni_x);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (iseed != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iseed, jni_iseed, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlarnv_1offsets (JNIEnv * env, jobject calling_obj, jint idist, jintArray iseed, jint _iseed_offset, jint n, jdoubleArray x, jint _x_offset) {
  jint * jni_iseed = NULL;
  if (iseed != NULL) {
    jni_iseed = (*env)->GetPrimitiveArrayCritical(env, iseed, JNI_FALSE);
    check_memory(env, jni_iseed);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
LAPACKE_dlarnv_work(idist, jni_iseed + _iseed_offset, n, jni_x + _x_offset);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (iseed != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iseed, jni_iseed, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlaset (JNIEnv * env, jobject calling_obj, jstring uplo, jint m, jint n, jdouble alpha, jdouble beta, jdoubleArray a, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
LAPACKE_dlaset_work(LAPACK_COL_MAJOR, jni_uplo[0], m, n, alpha, beta, jni_a, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlaset_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint m, jint n, jdouble alpha, jdouble beta, jdoubleArray a, jint _a_offset, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
LAPACKE_dlaset_work(LAPACK_COL_MAJOR, jni_uplo[0], m, n, alpha, beta, jni_a + _a_offset, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlasrt (JNIEnv * env, jobject calling_obj, jstring id, jint n, jdoubleArray d, jintw info) {
  char * jni_id = (char *)(*env)->GetStringUTFChars(env, id, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dlasrt_work(jni_id[0], n, jni_d);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, id, jni_id);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlasrt_1offsets (JNIEnv * env, jobject calling_obj, jstring id, jint n, jdoubleArray d, jint _d_offset, jintw info) {
  char * jni_id = (char *)(*env)->GetStringUTFChars(env, id, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dlasrt_work(jni_id[0], n, jni_d + _d_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, id, jni_id);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlaswp (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint lda, jint k1, jint k2, jintArray ipiv, jint incx) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
LAPACKE_dlaswp_work(LAPACK_COL_MAJOR, n, jni_a, lda, k1, k2, jni_ipiv, incx);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlaswp_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint _a_offset, jint lda, jint k1, jint k2, jintArray ipiv, jint _ipiv_offset, jint incx) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
LAPACKE_dlaswp_work(LAPACK_COL_MAJOR, n, jni_a + _a_offset, lda, k1, k2, jni_ipiv + _ipiv_offset, incx);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlauum (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dlauum_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dlauum_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dlauum_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dopgtr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdoubleArray tau, jdoubleArray q, jint ldq, jdoubleArray work, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dopgtr_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap, jni_tau, jni_q, ldq, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dopgtr_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray tau, jint _tau_offset, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dopgtr_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset, jni_tau + _tau_offset, jni_q + _q_offset, ldq, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dopmtr (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring trans, jint m, jint n, jdoubleArray ap, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dopmtr_work(LAPACK_COL_MAJOR, jni_side[0], jni_uplo[0], jni_trans[0], m, n, jni_ap, jni_tau, jni_c, Ldc, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dopmtr_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring trans, jint m, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dopmtr_work(LAPACK_COL_MAJOR, jni_side[0], jni_uplo[0], jni_trans[0], m, n, jni_ap + _ap_offset, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgbr (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgbr_work(LAPACK_COL_MAJOR, jni_vect[0], m, n, k, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgbr_1offsets (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgbr_work(LAPACK_COL_MAJOR, jni_vect[0], m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorghr (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorghr_work(LAPACK_COL_MAJOR, n, ilo, ihi, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorghr_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorghr_work(LAPACK_COL_MAJOR, n, ilo, ihi, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorglq (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorglq_work(LAPACK_COL_MAJOR, m, n, k, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorglq_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorglq_work(LAPACK_COL_MAJOR, m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgql (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgql_work(LAPACK_COL_MAJOR, m, n, k, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgql_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgql_work(LAPACK_COL_MAJOR, m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgqr (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgqr_work(LAPACK_COL_MAJOR, m, n, k, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgqr_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgqr_work(LAPACK_COL_MAJOR, m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgrq (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgrq_work(LAPACK_COL_MAJOR, m, n, k, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgrq_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgrq_work(LAPACK_COL_MAJOR, m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgtr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgtr_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dorgtr_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dorgtr_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormbr (JNIEnv * env, jobject calling_obj, jstring vect, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormbr_work(LAPACK_COL_MAJOR, jni_vect[0], jni_side[0], jni_trans[0], m, n, k, jni_a, lda, jni_tau, jni_c, Ldc, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormbr_1offsets (JNIEnv * env, jobject calling_obj, jstring vect, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormbr_work(LAPACK_COL_MAJOR, jni_vect[0], jni_side[0], jni_trans[0], m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormhr (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormhr_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, ilo, ihi, jni_a, lda, jni_tau, jni_c, Ldc, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormhr_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint ilo, jint ihi, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormhr_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, ilo, ihi, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormlq (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormlq_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, jni_a, lda, jni_tau, jni_c, Ldc, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormlq_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormlq_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormql (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormql_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, jni_a, lda, jni_tau, jni_c, Ldc, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormql_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormql_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormqr (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormqr_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, jni_a, lda, jni_tau, jni_c, Ldc, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormqr_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormqr_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormrq (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormrq_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, jni_a, lda, jni_tau, jni_c, Ldc, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormrq_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormrq_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormrz (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jint l, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormrz_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, l, jni_a, lda, jni_tau, jni_c, Ldc, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormrz_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jint l, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormrz_work(LAPACK_COL_MAJOR, jni_side[0], jni_trans[0], m, n, k, l, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormtr (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring trans, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormtr_work(LAPACK_COL_MAJOR, jni_side[0], jni_uplo[0], jni_trans[0], m, n, jni_a, lda, jni_tau, jni_c, Ldc, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dormtr_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring trans, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dormtr_work(LAPACK_COL_MAJOR, jni_side[0], jni_uplo[0], jni_trans[0], m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_c + _c_offset, Ldc, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdouble anorm, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbcon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, jni_ab, ldab, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbcon_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbcon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, jni_ab + _ab_offset, ldab, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbequ (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray s, jdoublew scond, jdoublew amax, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
  jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
  jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbequ_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, jni_ab, ldab, jni_s, &jni_scond, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbequ_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray s, jint _s_offset, jdoublew scond, jdoublew amax, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
  jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
  jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbequ_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, jni_ab + _ab_offset, ldab, jni_s + _s_offset, &jni_scond, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray afb, jint ldafb, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbrfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, nrhs, jni_ab, ldab, jni_afb, ldafb, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbrfs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray afb, jint _afb_offset, jint ldafb, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbrfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, nrhs, jni_ab + _ab_offset, ldab, jni_afb + _afb_offset, ldafb, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbstf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbstf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, jni_ab, ldab);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbstf_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbstf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, jni_ab + _ab_offset, ldab);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbsv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, nrhs, jni_ab, ldab, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbsv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, nrhs, jni_ab + _ab_offset, ldab, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray afb, jint ldafb, jstringw equed, jdoubleArray s, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, kd, nrhs, jni_ab, ldab, jni_afb, ldafb, jni_equed, jni_s, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbsvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray afb, jint _afb_offset, jint ldafb, jstringw equed, jdoubleArray s, jint _s_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, kd, nrhs, jni_ab + _ab_offset, ldab, jni_afb + _afb_offset, ldafb, jni_equed, jni_s + _s_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbtrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbtrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, jni_ab, ldab);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbtrf_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbtrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, jni_ab + _ab_offset, ldab);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbtrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbtrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, nrhs, jni_ab, ldab, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpbtrs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpbtrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, kd, nrhs, jni_ab + _ab_offset, ldab, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpocon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jdouble anorm, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpocon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpocon_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpocon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpoequ (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint lda, jdoubleArray s, jdoublew scond, jdoublew amax, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
  jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
  jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpoequ_work(LAPACK_COL_MAJOR, n, jni_a, lda, jni_s, &jni_scond, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpoequ_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray s, jint _s_offset, jdoublew scond, jdoublew amax, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
  jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
  jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpoequ_work(LAPACK_COL_MAJOR, n, jni_a + _a_offset, lda, jni_s + _s_offset, &jni_scond, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dporfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dporfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a, lda, jni_af, ldaf, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dporfs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray af, jint _af_offset, jint ldaf, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dporfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a + _a_offset, lda, jni_af + _af_offset, ldaf, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dposv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dposv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a, lda, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dposv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dposv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dposvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jstringw equed, jdoubleArray s, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dposvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, nrhs, jni_a, lda, jni_af, ldaf, jni_equed, jni_s, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dposvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray af, jint _af_offset, jint ldaf, jstringw equed, jdoubleArray s, jint _s_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dposvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, nrhs, jni_a + _a_offset, lda, jni_af + _af_offset, ldaf, jni_equed, jni_s + _s_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpotrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpotrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpotrf_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpotrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpotri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpotri_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpotri_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpotri_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpotrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpotrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a, lda, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpotrs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpotrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dppcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdouble anorm, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dppcon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dppcon_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dppcon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dppequ (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdoubleArray s, jdoublew scond, jdoublew amax, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
  jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
  jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dppequ_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap, jni_s, &jni_scond, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dppequ_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray s, jint _s_offset, jdoublew scond, jdoublew amax, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
  jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
  jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
  jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dppequ_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset, jni_s + _s_offset, &jni_scond, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray afp, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_afp = NULL;
  if (afp != NULL) {
    jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
    check_memory(env, jni_afp);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpprfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap, jni_afp, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (afp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpprfs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jdoubleArray afp, jint _afp_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_afp = NULL;
  if (afp != NULL) {
    jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
    check_memory(env, jni_afp);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpprfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap + _ap_offset, jni_afp + _afp_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (afp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dppsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dppsv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dppsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dppsv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap + _ap_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dppsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray afp, jstringw equed, jdoubleArray s, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_afp = NULL;
  if (afp != NULL) {
    jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
    check_memory(env, jni_afp);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dppsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, nrhs, jni_ap, jni_afp, jni_equed, jni_s, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (afp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dppsvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jdoubleArray afp, jint _afp_offset, jstringw equed, jdoubleArray s, jint _s_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_afp = NULL;
  if (afp != NULL) {
    jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
    check_memory(env, jni_afp);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dppsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, nrhs, jni_ap + _ap_offset, jni_afp + _afp_offset, jni_equed, jni_s + _s_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (afp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpptrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpptrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpptrf_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpptrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpptri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpptri_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpptri_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpptri_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpptrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpptrs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpptrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap + _ap_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dptcon (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jdouble anorm, jdoublew rcond, jdoubleArray work, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dptcon_work(n, jni_d, jni_e, anorm, &jni_rcond, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dptcon_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dptcon_work(n, jni_d + _d_offset, jni_e + _e_offset, anorm, &jni_rcond, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpteqr (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jintw info) {
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpteqr_work(LAPACK_COL_MAJOR, jni_compz[0], n, jni_d, jni_e, jni_z, ldz, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpteqr_1offsets (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpteqr_work(LAPACK_COL_MAJOR, jni_compz[0], n, jni_d + _d_offset, jni_e + _e_offset, jni_z + _z_offset, ldz, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dptrfs (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray df, jdoubleArray ef, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_df = NULL;
  if (df != NULL) {
    jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
    check_memory(env, jni_df);
  }
  jdouble * jni_ef = NULL;
  if (ef != NULL) {
    jni_ef = (*env)->GetPrimitiveArrayCritical(env, ef, JNI_FALSE);
    check_memory(env, jni_ef);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dptrfs_work(LAPACK_COL_MAJOR, n, nrhs, jni_d, jni_e, jni_df, jni_ef, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ef != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ef, jni_ef, 0);
  }
  if (df != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dptrfs_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray df, jint _df_offset, jdoubleArray ef, jint _ef_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_df = NULL;
  if (df != NULL) {
    jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
    check_memory(env, jni_df);
  }
  jdouble * jni_ef = NULL;
  if (ef != NULL) {
    jni_ef = (*env)->GetPrimitiveArrayCritical(env, ef, JNI_FALSE);
    check_memory(env, jni_ef);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dptrfs_work(LAPACK_COL_MAJOR, n, nrhs, jni_d + _d_offset, jni_e + _e_offset, jni_df + _df_offset, jni_ef + _ef_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ef != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ef, jni_ef, 0);
  }
  if (df != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dptsv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jint ldb, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dptsv_work(LAPACK_COL_MAJOR, n, nrhs, jni_d, jni_e, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dptsv_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dptsv_work(LAPACK_COL_MAJOR, n, nrhs, jni_d + _d_offset, jni_e + _e_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dptsvx (JNIEnv * env, jobject calling_obj, jstring fact, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray df, jdoubleArray ef, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_df = NULL;
  if (df != NULL) {
    jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
    check_memory(env, jni_df);
  }
  jdouble * jni_ef = NULL;
  if (ef != NULL) {
    jni_ef = (*env)->GetPrimitiveArrayCritical(env, ef, JNI_FALSE);
    check_memory(env, jni_ef);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dptsvx_work(LAPACK_COL_MAJOR, jni_fact[0], n, nrhs, jni_d, jni_e, jni_df, jni_ef, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ef != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ef, jni_ef, 0);
  }
  if (df != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dptsvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jint n, jint nrhs, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray df, jint _df_offset, jdoubleArray ef, jint _ef_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_df = NULL;
  if (df != NULL) {
    jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
    check_memory(env, jni_df);
  }
  jdouble * jni_ef = NULL;
  if (ef != NULL) {
    jni_ef = (*env)->GetPrimitiveArrayCritical(env, ef, JNI_FALSE);
    check_memory(env, jni_ef);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dptsvx_work(LAPACK_COL_MAJOR, jni_fact[0], n, nrhs, jni_d + _d_offset, jni_e + _e_offset, jni_df + _df_offset, jni_ef + _ef_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ef != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ef, jni_ef, 0);
  }
  if (df != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpttrf (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpttrf_work(n, jni_d, jni_e);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpttrf_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpttrf_work(n, jni_d + _d_offset, jni_e + _e_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpttrs (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jint ldb, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpttrs_work(LAPACK_COL_MAJOR, n, nrhs, jni_d, jni_e, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dpttrs_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dpttrs_work(LAPACK_COL_MAJOR, n, nrhs, jni_d + _d_offset, jni_e + _e_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbev_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, kd, jni_ab, ldab, jni_w, jni_z, ldz, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbev_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbev_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, kd, jni_ab + _ab_offset, ldab, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbevd_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, kd, jni_ab, ldab, jni_w, jni_z, ldz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbevd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbevd_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, kd, jni_ab + _ab_offset, ldab, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray q, jint ldq, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbevx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, kd, jni_ab, ldab, jni_q, ldq, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_work, jni_iwork, jni_ifail);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbevx_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray q, jint _q_offset, jint ldq, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintArray ifail, jint _ifail_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbevx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, kd, jni_ab + _ab_offset, ldab, jni_q + _q_offset, ldq, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, jni_iwork + _iwork_offset, jni_ifail + _ifail_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbgst (JNIEnv * env, jobject calling_obj, jstring vect, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint ldab, jdoubleArray bb, jint ldbb, jdoubleArray x, jint ldx, jdoubleArray work, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_bb = NULL;
  if (bb != NULL) {
    jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
    check_memory(env, jni_bb);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbgst_work(LAPACK_COL_MAJOR, jni_vect[0], jni_uplo[0], n, ka, kb, jni_ab, ldab, jni_bb, ldbb, jni_x, ldx, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (bb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbgst_1offsets (JNIEnv * env, jobject calling_obj, jstring vect, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray bb, jint _bb_offset, jint ldbb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_bb = NULL;
  if (bb != NULL) {
    jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
    check_memory(env, jni_bb);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbgst_work(LAPACK_COL_MAJOR, jni_vect[0], jni_uplo[0], n, ka, kb, jni_ab + _ab_offset, ldab, jni_bb + _bb_offset, ldbb, jni_x + _x_offset, ldx, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (bb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbgv (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint ldab, jdoubleArray bb, jint ldbb, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_bb = NULL;
  if (bb != NULL) {
    jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
    check_memory(env, jni_bb);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbgv_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, ka, kb, jni_ab, ldab, jni_bb, ldbb, jni_w, jni_z, ldz, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (bb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbgv_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray bb, jint _bb_offset, jint ldbb, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_bb = NULL;
  if (bb != NULL) {
    jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
    check_memory(env, jni_bb);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbgv_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, ka, kb, jni_ab + _ab_offset, ldab, jni_bb + _bb_offset, ldbb, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (bb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbgvd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint ldab, jdoubleArray bb, jint ldbb, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_bb = NULL;
  if (bb != NULL) {
    jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
    check_memory(env, jni_bb);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbgvd_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, ka, kb, jni_ab, ldab, jni_bb, ldbb, jni_w, jni_z, ldz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (bb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbgvd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray bb, jint _bb_offset, jint ldbb, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_bb = NULL;
  if (bb != NULL) {
    jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
    check_memory(env, jni_bb);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbgvd_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, ka, kb, jni_ab + _ab_offset, ldab, jni_bb + _bb_offset, ldbb, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (bb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbgvx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint ldab, jdoubleArray bb, jint ldbb, jdoubleArray q, jint ldq, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_bb = NULL;
  if (bb != NULL) {
    jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
    check_memory(env, jni_bb);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbgvx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, ka, kb, jni_ab, ldab, jni_bb, ldbb, jni_q, ldq, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_work, jni_iwork, jni_ifail);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (bb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbgvx_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray bb, jint _bb_offset, jint ldbb, jdoubleArray q, jint _q_offset, jint ldq, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintArray ifail, jint _ifail_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_bb = NULL;
  if (bb != NULL) {
    jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
    check_memory(env, jni_bb);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbgvx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, ka, kb, jni_ab + _ab_offset, ldab, jni_bb + _bb_offset, ldbb, jni_q + _q_offset, ldq, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, jni_iwork + _iwork_offset, jni_ifail + _ifail_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (bb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbtrd (JNIEnv * env, jobject calling_obj, jstring vect, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray d, jdoubleArray e, jdoubleArray q, jint ldq, jdoubleArray work, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbtrd_work(LAPACK_COL_MAJOR, jni_vect[0], jni_uplo[0], n, kd, jni_ab, ldab, jni_d, jni_e, jni_q, ldq, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsbtrd_1offsets (JNIEnv * env, jobject calling_obj, jstring vect, jstring uplo, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsbtrd_work(LAPACK_COL_MAJOR, jni_vect[0], jni_uplo[0], n, kd, jni_ab + _ab_offset, ldab, jni_d + _d_offset, jni_e + _e_offset, jni_q + _q_offset, ldq, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsgesv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray work, jfloatArray swork, jintw iter, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jfloat * jni_swork = NULL;
  if (swork != NULL) {
    jni_swork = (*env)->GetPrimitiveArrayCritical(env, swork, JNI_FALSE);
    check_memory(env, jni_swork);
  }
  jclass jni_iterClass = (*env)->GetObjectClass(env, iter);
  jfieldID jni_iterId = (*env)->GetFieldID(env, jni_iterClass, "val", "I");
  jint jni_iter = (*env)->GetIntField(env, iter, jni_iterId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsgesv_work(LAPACK_COL_MAJOR, n, nrhs, jni_a, lda, jni_ipiv, jni_b, ldb, jni_x, ldx, jni_work, jni_swork, &jni_iter);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetIntField(env, iter, jni_iterId, jni_iter);
  if (swork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, swork, jni_swork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsgesv_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray work, jint _work_offset, jfloatArray swork, jint _swork_offset, jintw iter, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jfloat * jni_swork = NULL;
  if (swork != NULL) {
    jni_swork = (*env)->GetPrimitiveArrayCritical(env, swork, JNI_FALSE);
    check_memory(env, jni_swork);
  }
  jclass jni_iterClass = (*env)->GetObjectClass(env, iter);
  jfieldID jni_iterId = (*env)->GetFieldID(env, jni_iterClass, "val", "I");
  jint jni_iter = (*env)->GetIntField(env, iter, jni_iterId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsgesv_work(LAPACK_COL_MAJOR, n, nrhs, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_work + _work_offset, jni_swork + _swork_offset, &jni_iter);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetIntField(env, iter, jni_iterId, jni_iter);
  if (swork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, swork, jni_swork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jintArray ipiv, jdouble anorm, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspcon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap, jni_ipiv, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspcon_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jintArray ipiv, jint _ipiv_offset, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspcon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset, jni_ipiv + _ipiv_offset, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspev_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, jni_ap, jni_w, jni_z, ldz, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspev_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspev_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, jni_ap + _ap_offset, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspevd_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, jni_ap, jni_w, jni_z, ldz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspevd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspevd_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, jni_ap + _ap_offset, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray ap, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspevx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_ap, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_work, jni_iwork, jni_ifail);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspevx_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintArray ifail, jint _ifail_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspevx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_ap + _ap_offset, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, jni_iwork + _iwork_offset, jni_ifail + _ifail_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspgst (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jdoubleArray ap, jdoubleArray bp, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_bp = NULL;
  if (bp != NULL) {
    jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
    check_memory(env, jni_bp);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspgst_work(LAPACK_COL_MAJOR, itype, jni_uplo[0], n, jni_ap, jni_bp);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (bp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspgst_1offsets (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray bp, jint _bp_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_bp = NULL;
  if (bp != NULL) {
    jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
    check_memory(env, jni_bp);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspgst_work(LAPACK_COL_MAJOR, itype, jni_uplo[0], n, jni_ap + _ap_offset, jni_bp + _bp_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (bp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspgv (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jdoubleArray bp, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_bp = NULL;
  if (bp != NULL) {
    jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
    check_memory(env, jni_bp);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspgv_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_uplo[0], n, jni_ap, jni_bp, jni_w, jni_z, ldz, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (bp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspgv_1offsets (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray bp, jint _bp_offset, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_bp = NULL;
  if (bp != NULL) {
    jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
    check_memory(env, jni_bp);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspgv_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_uplo[0], n, jni_ap + _ap_offset, jni_bp + _bp_offset, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (bp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspgvd (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jdoubleArray bp, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_bp = NULL;
  if (bp != NULL) {
    jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
    check_memory(env, jni_bp);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspgvd_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_uplo[0], n, jni_ap, jni_bp, jni_w, jni_z, ldz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (bp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspgvd_1offsets (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray bp, jint _bp_offset, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_bp = NULL;
  if (bp != NULL) {
    jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
    check_memory(env, jni_bp);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspgvd_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_uplo[0], n, jni_ap + _ap_offset, jni_bp + _bp_offset, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (bp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspgvx (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray ap, jdoubleArray bp, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_bp = NULL;
  if (bp != NULL) {
    jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
    check_memory(env, jni_bp);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspgvx_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_ap, jni_bp, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_work, jni_iwork, jni_ifail);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (bp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspgvx_1offsets (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray bp, jint _bp_offset, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintArray ifail, jint _ifail_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_bp = NULL;
  if (bp != NULL) {
    jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
    check_memory(env, jni_bp);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspgvx_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_ap + _ap_offset, jni_bp + _bp_offset, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, jni_iwork + _iwork_offset, jni_ifail + _ifail_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (bp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray afp, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_afp = NULL;
  if (afp != NULL) {
    jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
    check_memory(env, jni_afp);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsprfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap, jni_afp, jni_ipiv, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsprfs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jdoubleArray afp, jint _afp_offset, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_afp = NULL;
  if (afp != NULL) {
    jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
    check_memory(env, jni_afp);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsprfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap + _ap_offset, jni_afp + _afp_offset, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jintArray ipiv, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspsv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspsv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap + _ap_offset, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray afp, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_afp = NULL;
  if (afp != NULL) {
    jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
    check_memory(env, jni_afp);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, nrhs, jni_ap, jni_afp, jni_ipiv, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dspsvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jdoubleArray afp, jint _afp_offset, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_afp = NULL;
  if (afp != NULL) {
    jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
    check_memory(env, jni_afp);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dspsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, nrhs, jni_ap + _ap_offset, jni_afp + _afp_offset, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afp != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsptrd (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdoubleArray d, jdoubleArray e, jdoubleArray tau, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsptrd_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap, jni_d, jni_e, jni_tau);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsptrd_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray tau, jint _tau_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsptrd_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset, jni_d + _d_offset, jni_e + _e_offset, jni_tau + _tau_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsptrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jintArray ipiv, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsptrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap, jni_ipiv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsptrf_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jintArray ipiv, jint _ipiv_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsptrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset, jni_ipiv + _ipiv_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsptri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jintArray ipiv, jdoubleArray work, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsptri_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap, jni_ipiv, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsptri_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jint _ap_offset, jintArray ipiv, jint _ipiv_offset, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsptri_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_ap + _ap_offset, jni_ipiv + _ipiv_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jintArray ipiv, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsptrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsptrs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsptrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_ap + _ap_offset, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstebz (JNIEnv * env, jobject calling_obj, jstring range, jstring order, jint n, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jdoubleArray d, jdoubleArray e, jintw m, jintw nsplit, jdoubleArray w, jintArray iblock, jintArray isplit, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_order = (char *)(*env)->GetStringUTFChars(env, order, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jclass jni_nsplitClass = (*env)->GetObjectClass(env, nsplit);
  jfieldID jni_nsplitId = (*env)->GetFieldID(env, jni_nsplitClass, "val", "I");
  jint jni_nsplit = (*env)->GetIntField(env, nsplit, jni_nsplitId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jint * jni_iblock = NULL;
  if (iblock != NULL) {
    jni_iblock = (*env)->GetPrimitiveArrayCritical(env, iblock, JNI_FALSE);
    check_memory(env, jni_iblock);
  }
  jint * jni_isplit = NULL;
  if (isplit != NULL) {
    jni_isplit = (*env)->GetPrimitiveArrayCritical(env, isplit, JNI_FALSE);
    check_memory(env, jni_isplit);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstebz_work(jni_range[0], jni_order[0], n, vl, vu, il, iu, abstol, jni_d, jni_e, &jni_m, &jni_nsplit, jni_w, jni_iblock, jni_isplit, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (isplit != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isplit, jni_isplit, 0);
  }
  if (iblock != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iblock, jni_iblock, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, nsplit, jni_nsplitId, jni_nsplit);
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, order, jni_order);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstebz_1offsets (JNIEnv * env, jobject calling_obj, jstring range, jstring order, jint n, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jintw m, jintw nsplit, jdoubleArray w, jint _w_offset, jintArray iblock, jint _iblock_offset, jintArray isplit, jint _isplit_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_order = (char *)(*env)->GetStringUTFChars(env, order, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jclass jni_nsplitClass = (*env)->GetObjectClass(env, nsplit);
  jfieldID jni_nsplitId = (*env)->GetFieldID(env, jni_nsplitClass, "val", "I");
  jint jni_nsplit = (*env)->GetIntField(env, nsplit, jni_nsplitId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jint * jni_iblock = NULL;
  if (iblock != NULL) {
    jni_iblock = (*env)->GetPrimitiveArrayCritical(env, iblock, JNI_FALSE);
    check_memory(env, jni_iblock);
  }
  jint * jni_isplit = NULL;
  if (isplit != NULL) {
    jni_isplit = (*env)->GetPrimitiveArrayCritical(env, isplit, JNI_FALSE);
    check_memory(env, jni_isplit);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstebz_work(jni_range[0], jni_order[0], n, vl, vu, il, iu, abstol, jni_d + _d_offset, jni_e + _e_offset, &jni_m, &jni_nsplit, jni_w + _w_offset, jni_iblock + _iblock_offset, jni_isplit + _isplit_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (isplit != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isplit, jni_isplit, 0);
  }
  if (iblock != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iblock, jni_iblock, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, nsplit, jni_nsplitId, jni_nsplit);
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, order, jni_order);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstedc (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstedc_work(LAPACK_COL_MAJOR, jni_compz[0], n, jni_d, jni_e, jni_z, ldz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstedc_1offsets (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstedc_work(LAPACK_COL_MAJOR, jni_compz[0], n, jni_d + _d_offset, jni_e + _e_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstegr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jdoubleArray e, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jintArray isuppz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jint * jni_isuppz = NULL;
  if (isuppz != NULL) {
    jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
    check_memory(env, jni_isuppz);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstegr_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], n, jni_d, jni_e, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_isuppz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (isuppz != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstegr_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jintArray isuppz, jint _isuppz_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jint * jni_isuppz = NULL;
  if (isuppz != NULL) {
    jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
    check_memory(env, jni_isuppz);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstegr_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], n, jni_d + _d_offset, jni_e + _e_offset, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_isuppz + _isuppz_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (isuppz != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstein (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jint m, jdoubleArray w, jintArray iblock, jintArray isplit, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jint * jni_iblock = NULL;
  if (iblock != NULL) {
    jni_iblock = (*env)->GetPrimitiveArrayCritical(env, iblock, JNI_FALSE);
    check_memory(env, jni_iblock);
  }
  jint * jni_isplit = NULL;
  if (isplit != NULL) {
    jni_isplit = (*env)->GetPrimitiveArrayCritical(env, isplit, JNI_FALSE);
    check_memory(env, jni_isplit);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstein_work(LAPACK_COL_MAJOR, n, jni_d, jni_e, m, jni_w, jni_iblock, jni_isplit, jni_z, ldz, jni_work, jni_iwork, jni_ifail);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (isplit != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isplit, jni_isplit, 0);
  }
  if (iblock != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iblock, jni_iblock, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstein_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jint m, jdoubleArray w, jint _w_offset, jintArray iblock, jint _iblock_offset, jintArray isplit, jint _isplit_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintArray ifail, jint _ifail_offset, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jint * jni_iblock = NULL;
  if (iblock != NULL) {
    jni_iblock = (*env)->GetPrimitiveArrayCritical(env, iblock, JNI_FALSE);
    check_memory(env, jni_iblock);
  }
  jint * jni_isplit = NULL;
  if (isplit != NULL) {
    jni_isplit = (*env)->GetPrimitiveArrayCritical(env, isplit, JNI_FALSE);
    check_memory(env, jni_isplit);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstein_work(LAPACK_COL_MAJOR, n, jni_d + _d_offset, jni_e + _e_offset, m, jni_w + _w_offset, jni_iblock + _iblock_offset, jni_isplit + _isplit_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, jni_iwork + _iwork_offset, jni_ifail + _ifail_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (isplit != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isplit, jni_isplit, 0);
  }
  if (iblock != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iblock, jni_iblock, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstemr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jdoubleArray e, jdouble vl, jdouble vu, jint il, jint iu, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jint nzc, jintArray isuppz, jbooleanw tryrac, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jint * jni_isuppz = NULL;
  if (isuppz != NULL) {
    jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
    check_memory(env, jni_isuppz);
  }
  jclass jni_tryracClass = (*env)->GetObjectClass(env, tryrac);
  jfieldID jni_tryracId = (*env)->GetFieldID(env, jni_tryracClass, "val", "Z");
  jboolean jni_tryrac_raw = (*env)->GetBooleanField(env, tryrac, jni_tryracId);
  int jni_tryrac = jboolean2int(jni_tryrac_raw);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstemr_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], n, jni_d, jni_e, vl, vu, il, iu, &jni_m, jni_w, jni_z, ldz, nzc, jni_isuppz, &jni_tryrac, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  jni_tryrac_raw = int2jboolean(jni_tryrac);
  (*env)->SetIntField(env, tryrac, jni_tryracId, jni_tryrac_raw);
  if (isuppz != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstemr_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdouble vl, jdouble vu, jint il, jint iu, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jint nzc, jintArray isuppz, jint _isuppz_offset, jbooleanw tryrac, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jint * jni_isuppz = NULL;
  if (isuppz != NULL) {
    jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
    check_memory(env, jni_isuppz);
  }
  jclass jni_tryracClass = (*env)->GetObjectClass(env, tryrac);
  jfieldID jni_tryracId = (*env)->GetFieldID(env, jni_tryracClass, "val", "Z");
  jboolean jni_tryrac_raw = (*env)->GetBooleanField(env, tryrac, jni_tryracId);
  int jni_tryrac = jboolean2int(jni_tryrac_raw);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstemr_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], n, jni_d + _d_offset, jni_e + _e_offset, vl, vu, il, iu, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, nzc, jni_isuppz + _isuppz_offset, &jni_tryrac, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  jni_tryrac_raw = int2jboolean(jni_tryrac);
  (*env)->SetIntField(env, tryrac, jni_tryracId, jni_tryrac_raw);
  if (isuppz != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsteqr (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jintw info) {
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsteqr_work(LAPACK_COL_MAJOR, jni_compz[0], n, jni_d, jni_e, jni_z, ldz, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsteqr_1offsets (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsteqr_work(LAPACK_COL_MAJOR, jni_compz[0], n, jni_d + _d_offset, jni_e + _e_offset, jni_z + _z_offset, ldz, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compz, jni_compz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsterf (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsterf_work(n, jni_d, jni_e);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsterf_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jintw info) {
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsterf_work(n, jni_d + _d_offset, jni_e + _e_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstev (JNIEnv * env, jobject calling_obj, jstring jobz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstev_work(LAPACK_COL_MAJOR, jni_jobz[0], n, jni_d, jni_e, jni_z, ldz, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstev_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstev_work(LAPACK_COL_MAJOR, jni_jobz[0], n, jni_d + _d_offset, jni_e + _e_offset, jni_z + _z_offset, ldz, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstevd (JNIEnv * env, jobject calling_obj, jstring jobz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstevd_work(LAPACK_COL_MAJOR, jni_jobz[0], n, jni_d, jni_e, jni_z, ldz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstevd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstevd_work(LAPACK_COL_MAJOR, jni_jobz[0], n, jni_d + _d_offset, jni_e + _e_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstevr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jdoubleArray e, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jintArray isuppz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jint * jni_isuppz = NULL;
  if (isuppz != NULL) {
    jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
    check_memory(env, jni_isuppz);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstevr_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], n, jni_d, jni_e, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_isuppz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (isuppz != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstevr_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jintArray isuppz, jint _isuppz_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jint * jni_isuppz = NULL;
  if (isuppz != NULL) {
    jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
    check_memory(env, jni_isuppz);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstevr_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], n, jni_d + _d_offset, jni_e + _e_offset, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_isuppz + _isuppz_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (isuppz != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jdoubleArray e, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstevx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], n, jni_d, jni_e, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_work, jni_iwork, jni_ifail);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dstevx_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintArray ifail, jint _ifail_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dstevx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], n, jni_d + _d_offset, jni_e + _e_offset, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, jni_iwork + _iwork_offset, jni_ifail + _ifail_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsycon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintArray ipiv, jdouble anorm, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsycon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda, jni_ipiv, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsycon_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdouble anorm, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsycon_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray w, jdoubleArray work, jint lwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyev_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, jni_a, lda, jni_w, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyev_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray w, jint _w_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyev_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, jni_a + _a_offset, lda, jni_w + _w_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray w, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyevd_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, jni_a, lda, jni_w, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyevd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray w, jint _w_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyevd_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_uplo[0], n, jni_a + _a_offset, lda, jni_w + _w_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyevr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint lda, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jintArray isuppz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jint * jni_isuppz = NULL;
  if (isuppz != NULL) {
    jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
    check_memory(env, jni_isuppz);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyevr_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_a, lda, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_isuppz, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (isuppz != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyevr_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jintArray isuppz, jint _isuppz_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jint * jni_isuppz = NULL;
  if (isuppz != NULL) {
    jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
    check_memory(env, jni_isuppz);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyevr_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_a + _a_offset, lda, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_isuppz + _isuppz_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (isuppz != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint lda, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jintArray ifail, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyevx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_a, lda, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_work, lwork, jni_iwork, jni_ifail);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyevx_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintArray ifail, jint _ifail_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyevx_work(LAPACK_COL_MAJOR, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_a + _a_offset, lda, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, jni_ifail + _ifail_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsygst (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsygst_work(LAPACK_COL_MAJOR, itype, jni_uplo[0], n, jni_a, lda, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsygst_1offsets (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsygst_work(LAPACK_COL_MAJOR, itype, jni_uplo[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsygv (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray w, jdoubleArray work, jint lwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsygv_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_uplo[0], n, jni_a, lda, jni_b, ldb, jni_w, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsygv_1offsets (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray w, jint _w_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsygv_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_uplo[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_w + _w_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsygvd (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray w, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsygvd_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_uplo[0], n, jni_a, lda, jni_b, ldb, jni_w, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsygvd_1offsets (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray w, jint _w_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsygvd_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_uplo[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_w + _w_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsygvx (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jintArray ifail, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsygvx_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_a, lda, jni_b, ldb, vl, vu, il, iu, abstol, &jni_m, jni_w, jni_z, ldz, jni_work, lwork, jni_iwork, jni_ifail);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsygvx_1offsets (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jintw m, jdoubleArray w, jint _w_offset, jdoubleArray z, jint _z_offset, jint ldz, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintArray ifail, jint _ifail_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_w = NULL;
  if (w != NULL) {
    jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
    check_memory(env, jni_w);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jint * jni_ifail = NULL;
  if (ifail != NULL) {
    jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
    check_memory(env, jni_ifail);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsygvx_work(LAPACK_COL_MAJOR, itype, jni_jobz[0], jni_range[0], jni_uplo[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, vl, vu, il, iu, abstol, &jni_m, jni_w + _w_offset, jni_z + _z_offset, ldz, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, jni_ifail + _ifail_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ifail != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
  }
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (w != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, range, jni_range);
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyrfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a, lda, jni_af, ldaf, jni_ipiv, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsyrfs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray af, jint _af_offset, jint ldaf, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsyrfs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a + _a_offset, lda, jni_af + _af_offset, ldaf, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsysv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray work, jint lwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsysv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a, lda, jni_ipiv, jni_b, ldb, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsysv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsysv_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsysvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoublew rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jint lwork, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsysvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, nrhs, jni_a, lda, jni_af, ldaf, jni_ipiv, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsysvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray af, jint _af_offset, jint ldaf, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoublew rcond, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsysvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_uplo[0], n, nrhs, jni_a + _a_offset, lda, jni_af + _af_offset, ldaf, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsytrd (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray d, jdoubleArray e, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsytrd_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda, jni_d, jni_e, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsytrd_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray d, jint _d_offset, jdoubleArray e, jint _e_offset, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsytrd_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda, jni_d + _d_offset, jni_e + _e_offset, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsytrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray work, jint lwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsytrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda, jni_ipiv, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsytrf_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsytrf_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsytri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray work, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsytri_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a, lda, jni_ipiv, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsytri_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsytri_work(LAPACK_COL_MAJOR, jni_uplo[0], n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsytrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsytrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a, lda, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dsytrs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dsytrs_work(LAPACK_COL_MAJOR, jni_uplo[0], n, nrhs, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtbcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jint kd, jdoubleArray ab, jint ldab, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtbcon_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], jni_diag[0], n, kd, jni_ab, ldab, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtbcon_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jint kd, jdoubleArray ab, jint _ab_offset, jint ldab, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtbcon_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], jni_diag[0], n, kd, jni_ab + _ab_offset, ldab, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtbrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtbrfs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, kd, nrhs, jni_ab, ldab, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtbrfs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint kd, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtbrfs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, kd, nrhs, jni_ab + _ab_offset, ldab, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtbtrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtbtrs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, kd, nrhs, jni_ab, ldab, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtbtrs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint kd, jint nrhs, jdoubleArray ab, jint _ab_offset, jint ldab, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtbtrs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, kd, nrhs, jni_ab + _ab_offset, ldab, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgevc (JNIEnv * env, jobject calling_obj, jstring side, jstring howmny, jbooleanArray select, jint n, jdoubleArray s, jint lds, jdoubleArray p, jint ldp, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jint mm, jintw m, jdoubleArray work, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_p = NULL;
  if (p != NULL) {
    jni_p = (*env)->GetPrimitiveArrayCritical(env, p, JNI_FALSE);
    check_memory(env, jni_p);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgevc_work(LAPACK_COL_MAJOR, jni_side[0], jni_howmny[0], jni_select, n, jni_s, lds, jni_p, ldp, jni_vl, ldvl, jni_vr, ldvr, mm, &jni_m, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (p != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, p, jni_p, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgevc_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring howmny, jbooleanArray select, jint _select_offset, jint n, jdoubleArray s, jint _s_offset, jint lds, jdoubleArray p, jint _p_offset, jint ldp, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jint mm, jintw m, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_p = NULL;
  if (p != NULL) {
    jni_p = (*env)->GetPrimitiveArrayCritical(env, p, JNI_FALSE);
    check_memory(env, jni_p);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgevc_work(LAPACK_COL_MAJOR, jni_side[0], jni_howmny[0], jni_select + _select_offset, n, jni_s + _s_offset, lds, jni_p + _p_offset, ldp, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, mm, &jni_m, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (p != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, p, jni_p, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgexc (JNIEnv * env, jobject calling_obj, jboolean wantq, jboolean wantz, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jintw ifst, jintw ilst, jdoubleArray work, jint lwork, jintw info) {
  int jni_wantq = jboolean2int(wantq);
  int jni_wantz = jboolean2int(wantz);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jclass jni_ifstClass = (*env)->GetObjectClass(env, ifst);
  jfieldID jni_ifstId = (*env)->GetFieldID(env, jni_ifstClass, "val", "I");
  jint jni_ifst = (*env)->GetIntField(env, ifst, jni_ifstId);
  jclass jni_ilstClass = (*env)->GetObjectClass(env, ilst);
  jfieldID jni_ilstId = (*env)->GetFieldID(env, jni_ilstClass, "val", "I");
  jint jni_ilst = (*env)->GetIntField(env, ilst, jni_ilstId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgexc_work(LAPACK_COL_MAJOR, jni_wantq, jni_wantz, n, jni_a, lda, jni_b, ldb, jni_q, ldq, jni_z, ldz, &jni_ifst, &jni_ilst, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, ilst, jni_ilstId, jni_ilst);
  (*env)->SetIntField(env, ifst, jni_ifstId, jni_ifst);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgexc_1offsets (JNIEnv * env, jobject calling_obj, jboolean wantq, jboolean wantz, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray z, jint _z_offset, jint ldz, jintw ifst, jintw ilst, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  int jni_wantq = jboolean2int(wantq);
  int jni_wantz = jboolean2int(wantz);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jclass jni_ifstClass = (*env)->GetObjectClass(env, ifst);
  jfieldID jni_ifstId = (*env)->GetFieldID(env, jni_ifstClass, "val", "I");
  jint jni_ifst = (*env)->GetIntField(env, ifst, jni_ifstId);
  jclass jni_ilstClass = (*env)->GetObjectClass(env, ilst);
  jfieldID jni_ilstId = (*env)->GetFieldID(env, jni_ilstClass, "val", "I");
  jint jni_ilst = (*env)->GetIntField(env, ilst, jni_ilstId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgexc_work(LAPACK_COL_MAJOR, jni_wantq, jni_wantz, n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_q + _q_offset, ldq, jni_z + _z_offset, ldz, &jni_ifst, &jni_ilst, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, ilst, jni_ilstId, jni_ilst);
  (*env)->SetIntField(env, ifst, jni_ifstId, jni_ifst);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgsen (JNIEnv * env, jobject calling_obj, jint ijob, jboolean wantq, jboolean wantz, jbooleanArray select, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jintw m, jdoublew pl, jdoublew pr, jdoubleArray dif, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  int jni_wantq = jboolean2int(wantq);
  int jni_wantz = jboolean2int(wantz);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jdouble * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jclass jni_plClass = (*env)->GetObjectClass(env, pl);
  jfieldID jni_plId = (*env)->GetFieldID(env, jni_plClass, "val", "D");
  jdouble jni_pl = (*env)->GetDoubleField(env, pl, jni_plId);
  jclass jni_prClass = (*env)->GetObjectClass(env, pr);
  jfieldID jni_prId = (*env)->GetFieldID(env, jni_prClass, "val", "D");
  jdouble jni_pr = (*env)->GetDoubleField(env, pr, jni_prId);
  jdouble * jni_dif = NULL;
  if (dif != NULL) {
    jni_dif = (*env)->GetPrimitiveArrayCritical(env, dif, JNI_FALSE);
    check_memory(env, jni_dif);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgsen_work(LAPACK_COL_MAJOR, ijob, jni_wantq, jni_wantz, jni_select, n, jni_a, lda, jni_b, ldb, jni_alphar, jni_alphai, jni_beta, jni_q, ldq, jni_z, ldz, &jni_m, &jni_pl, &jni_pr, jni_dif, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (dif != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dif, jni_dif, 0);
  }
  (*env)->SetDoubleField(env, pr, jni_prId, jni_pr);
  (*env)->SetDoubleField(env, pl, jni_plId, jni_pl);
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgsen_1offsets (JNIEnv * env, jobject calling_obj, jint ijob, jboolean wantq, jboolean wantz, jbooleanArray select, jint _select_offset, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray alphar, jint _alphar_offset, jdoubleArray alphai, jint _alphai_offset, jdoubleArray beta, jint _beta_offset, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray z, jint _z_offset, jint ldz, jintw m, jdoublew pl, jdoublew pr, jdoubleArray dif, jint _dif_offset, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  int jni_wantq = jboolean2int(wantq);
  int jni_wantz = jboolean2int(wantz);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jdouble * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jclass jni_plClass = (*env)->GetObjectClass(env, pl);
  jfieldID jni_plId = (*env)->GetFieldID(env, jni_plClass, "val", "D");
  jdouble jni_pl = (*env)->GetDoubleField(env, pl, jni_plId);
  jclass jni_prClass = (*env)->GetObjectClass(env, pr);
  jfieldID jni_prId = (*env)->GetFieldID(env, jni_prClass, "val", "D");
  jdouble jni_pr = (*env)->GetDoubleField(env, pr, jni_prId);
  jdouble * jni_dif = NULL;
  if (dif != NULL) {
    jni_dif = (*env)->GetPrimitiveArrayCritical(env, dif, JNI_FALSE);
    check_memory(env, jni_dif);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgsen_work(LAPACK_COL_MAJOR, ijob, jni_wantq, jni_wantz, jni_select + _select_offset, n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_alphar + _alphar_offset, jni_alphai + _alphai_offset, jni_beta + _beta_offset, jni_q + _q_offset, ldq, jni_z + _z_offset, ldz, &jni_m, &jni_pl, &jni_pr, jni_dif + _dif_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (dif != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dif, jni_dif, 0);
  }
  (*env)->SetDoubleField(env, pr, jni_prId, jni_pr);
  (*env)->SetDoubleField(env, pl, jni_plId, jni_pl);
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgsja (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint p, jint n, jint k, jint l, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble tola, jdouble tolb, jdoubleArray alpha, jdoubleArray beta, jdoubleArray u, jint ldu, jdoubleArray v, jint ldv, jdoubleArray q, jint ldq, jdoubleArray work, jintw ncycle, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
  char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alpha = NULL;
  if (alpha != NULL) {
    jni_alpha = (*env)->GetPrimitiveArrayCritical(env, alpha, JNI_FALSE);
    check_memory(env, jni_alpha);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_ncycleClass = (*env)->GetObjectClass(env, ncycle);
  jfieldID jni_ncycleId = (*env)->GetFieldID(env, jni_ncycleClass, "val", "I");
  jint jni_ncycle = (*env)->GetIntField(env, ncycle, jni_ncycleId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgsja_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobv[0], jni_jobq[0], m, p, n, k, l, jni_a, lda, jni_b, ldb, tola, tolb, jni_alpha, jni_beta, jni_u, ldu, jni_v, ldv, jni_q, ldq, jni_work, &jni_ncycle);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetIntField(env, ncycle, jni_ncycleId, jni_ncycle);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alpha != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alpha, jni_alpha, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
  (*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgsja_1offsets (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint p, jint n, jint k, jint l, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdouble tola, jdouble tolb, jdoubleArray alpha, jint _alpha_offset, jdoubleArray beta, jint _beta_offset, jdoubleArray u, jint _u_offset, jint ldu, jdoubleArray v, jint _v_offset, jint ldv, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray work, jint _work_offset, jintw ncycle, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
  char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_alpha = NULL;
  if (alpha != NULL) {
    jni_alpha = (*env)->GetPrimitiveArrayCritical(env, alpha, JNI_FALSE);
    check_memory(env, jni_alpha);
  }
  jdouble * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jdouble * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_ncycleClass = (*env)->GetObjectClass(env, ncycle);
  jfieldID jni_ncycleId = (*env)->GetFieldID(env, jni_ncycleClass, "val", "I");
  jint jni_ncycle = (*env)->GetIntField(env, ncycle, jni_ncycleId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgsja_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobv[0], jni_jobq[0], m, p, n, k, l, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, tola, tolb, jni_alpha + _alpha_offset, jni_beta + _beta_offset, jni_u + _u_offset, ldu, jni_v + _v_offset, ldv, jni_q + _q_offset, ldq, jni_work + _work_offset, &jni_ncycle);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetIntField(env, ncycle, jni_ncycleId, jni_ncycle);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alpha != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alpha, jni_alpha, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
  (*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgsna (JNIEnv * env, jobject calling_obj, jstring job, jstring howmny, jbooleanArray select, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray s, jdoubleArray dif, jint mm, jintw m, jdoubleArray work, jint lwork, jintArray iwork, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_dif = NULL;
  if (dif != NULL) {
    jni_dif = (*env)->GetPrimitiveArrayCritical(env, dif, JNI_FALSE);
    check_memory(env, jni_dif);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgsna_work(LAPACK_COL_MAJOR, jni_job[0], jni_howmny[0], jni_select, n, jni_a, lda, jni_b, ldb, jni_vl, ldvl, jni_vr, ldvr, jni_s, jni_dif, mm, &jni_m, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (dif != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dif, jni_dif, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgsna_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring howmny, jbooleanArray select, jint _select_offset, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jdoubleArray s, jint _s_offset, jdoubleArray dif, jint _dif_offset, jint mm, jintw m, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_dif = NULL;
  if (dif != NULL) {
    jni_dif = (*env)->GetPrimitiveArrayCritical(env, dif, JNI_FALSE);
    check_memory(env, jni_dif);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgsna_work(LAPACK_COL_MAJOR, jni_job[0], jni_howmny[0], jni_select + _select_offset, n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, jni_s + _s_offset, jni_dif + _dif_offset, mm, &jni_m, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (dif != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dif, jni_dif, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgsyl (JNIEnv * env, jobject calling_obj, jstring trans, jint ijob, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray c, jint Ldc, jdoubleArray d, jint ldd, jdoubleArray e, jint lde, jdoubleArray f, jint ldf, jdoublew scale, jdoublew dif, jdoubleArray work, jint lwork, jintArray iwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_f = NULL;
  if (f != NULL) {
    jni_f = (*env)->GetPrimitiveArrayCritical(env, f, JNI_FALSE);
    check_memory(env, jni_f);
  }
  jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
  jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
  jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
  jclass jni_difClass = (*env)->GetObjectClass(env, dif);
  jfieldID jni_difId = (*env)->GetFieldID(env, jni_difClass, "val", "D");
  jdouble jni_dif = (*env)->GetDoubleField(env, dif, jni_difId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgsyl_work(LAPACK_COL_MAJOR, jni_trans[0], ijob, m, n, jni_a, lda, jni_b, ldb, jni_c, Ldc, jni_d, ldd, jni_e, lde, jni_f, ldf, &jni_scale, &jni_dif, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, dif, jni_difId, jni_dif);
  (*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
  if (f != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, f, jni_f, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtgsyl_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint ijob, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray c, jint _c_offset, jint Ldc, jdoubleArray d, jint _d_offset, jint ldd, jdoubleArray e, jint _e_offset, jint lde, jdoubleArray f, jint _f_offset, jint ldf, jdoublew scale, jdoublew dif, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jdouble * jni_f = NULL;
  if (f != NULL) {
    jni_f = (*env)->GetPrimitiveArrayCritical(env, f, JNI_FALSE);
    check_memory(env, jni_f);
  }
  jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
  jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
  jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
  jclass jni_difClass = (*env)->GetObjectClass(env, dif);
  jfieldID jni_difId = (*env)->GetFieldID(env, jni_difClass, "val", "D");
  jdouble jni_dif = (*env)->GetDoubleField(env, dif, jni_difId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtgsyl_work(LAPACK_COL_MAJOR, jni_trans[0], ijob, m, n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_c + _c_offset, Ldc, jni_d + _d_offset, ldd, jni_e + _e_offset, lde, jni_f + _f_offset, ldf, &jni_scale, &jni_dif, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, dif, jni_difId, jni_dif);
  (*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
  if (f != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, f, jni_f, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtpcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jdoubleArray ap, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtpcon_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], jni_diag[0], n, jni_ap, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtpcon_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jdoubleArray ap, jint _ap_offset, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtpcon_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], jni_diag[0], n, jni_ap + _ap_offset, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray ap, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtprfs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, nrhs, jni_ap, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtprfs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtprfs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, nrhs, jni_ap + _ap_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtptri (JNIEnv * env, jobject calling_obj, jstring uplo, jstring diag, jint n, jdoubleArray ap, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtptri_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_diag[0], n, jni_ap);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtptri_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring diag, jint n, jdoubleArray ap, jint _ap_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtptri_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_diag[0], n, jni_ap + _ap_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray ap, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtptrs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, nrhs, jni_ap, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtptrs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray ap, jint _ap_offset, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtptrs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, nrhs, jni_ap + _ap_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jdoubleArray a, jint lda, jdoublew rcond, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrcon_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], jni_diag[0], n, jni_a, lda, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrcon_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoublew rcond, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
  jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrcon_work(LAPACK_COL_MAJOR, jni_norm[0], jni_uplo[0], jni_diag[0], n, jni_a + _a_offset, lda, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrevc (JNIEnv * env, jobject calling_obj, jstring side, jstring howmny, jbooleanArray select, jint n, jdoubleArray t, jint ldt, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jint mm, jintw m, jdoubleArray work, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrevc_work(LAPACK_COL_MAJOR, jni_side[0], jni_howmny[0], jni_select, n, jni_t, ldt, jni_vl, ldvl, jni_vr, ldvr, mm, &jni_m, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrevc_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring howmny, jbooleanArray select, jint _select_offset, jint n, jdoubleArray t, jint _t_offset, jint ldt, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jint mm, jintw m, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrevc_work(LAPACK_COL_MAJOR, jni_side[0], jni_howmny[0], jni_select + _select_offset, n, jni_t + _t_offset, ldt, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, mm, &jni_m, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrexc (JNIEnv * env, jobject calling_obj, jstring compq, jint n, jdoubleArray t, jint ldt, jdoubleArray q, jint ldq, jintw ifst, jintw ilst, jdoubleArray work, jintw info) {
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jclass jni_ifstClass = (*env)->GetObjectClass(env, ifst);
  jfieldID jni_ifstId = (*env)->GetFieldID(env, jni_ifstClass, "val", "I");
  jint jni_ifst = (*env)->GetIntField(env, ifst, jni_ifstId);
  jclass jni_ilstClass = (*env)->GetObjectClass(env, ilst);
  jfieldID jni_ilstId = (*env)->GetFieldID(env, jni_ilstClass, "val", "I");
  jint jni_ilst = (*env)->GetIntField(env, ilst, jni_ilstId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrexc_work(LAPACK_COL_MAJOR, jni_compq[0], n, jni_t, ldt, jni_q, ldq, &jni_ifst, &jni_ilst, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, ilst, jni_ilstId, jni_ilst);
  (*env)->SetIntField(env, ifst, jni_ifstId, jni_ifst);
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrexc_1offsets (JNIEnv * env, jobject calling_obj, jstring compq, jint n, jdoubleArray t, jint _t_offset, jint ldt, jdoubleArray q, jint _q_offset, jint ldq, jintw ifst, jintw ilst, jdoubleArray work, jint _work_offset, jintw info) {
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jclass jni_ifstClass = (*env)->GetObjectClass(env, ifst);
  jfieldID jni_ifstId = (*env)->GetFieldID(env, jni_ifstClass, "val", "I");
  jint jni_ifst = (*env)->GetIntField(env, ifst, jni_ifstId);
  jclass jni_ilstClass = (*env)->GetObjectClass(env, ilst);
  jfieldID jni_ilstId = (*env)->GetFieldID(env, jni_ilstClass, "val", "I");
  jint jni_ilst = (*env)->GetIntField(env, ilst, jni_ilstId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrexc_work(LAPACK_COL_MAJOR, jni_compq[0], n, jni_t + _t_offset, ldt, jni_q + _q_offset, ldq, &jni_ifst, &jni_ilst, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, ilst, jni_ilstId, jni_ilst);
  (*env)->SetIntField(env, ifst, jni_ifstId, jni_ifst);
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrrfs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, nrhs, jni_a, lda, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrrfs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray x, jint _x_offset, jint ldx, jdoubleArray ferr, jint _ferr_offset, jdoubleArray berr, jint _berr_offset, jdoubleArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jdouble * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrrfs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrsen (JNIEnv * env, jobject calling_obj, jstring job, jstring compq, jbooleanArray select, jint n, jdoubleArray t, jint ldt, jdoubleArray q, jint ldq, jdoubleArray wr, jdoubleArray wi, jintw m, jdoublew s, jdoublew sep, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jclass jni_sClass = (*env)->GetObjectClass(env, s);
  jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
  jdouble jni_s = (*env)->GetDoubleField(env, s, jni_sId);
  jclass jni_sepClass = (*env)->GetObjectClass(env, sep);
  jfieldID jni_sepId = (*env)->GetFieldID(env, jni_sepClass, "val", "D");
  jdouble jni_sep = (*env)->GetDoubleField(env, sep, jni_sepId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrsen_work(LAPACK_COL_MAJOR, jni_job[0], jni_compq[0], jni_select, n, jni_t, ldt, jni_q, ldq, jni_wr, jni_wi, &jni_m, &jni_s, &jni_sep, jni_work, lwork, jni_iwork, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, sep, jni_sepId, jni_sep);
  (*env)->SetDoubleField(env, s, jni_sId, jni_s);
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrsen_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring compq, jbooleanArray select, jint _select_offset, jint n, jdoubleArray t, jint _t_offset, jint ldt, jdoubleArray q, jint _q_offset, jint ldq, jdoubleArray wr, jint _wr_offset, jdoubleArray wi, jint _wi_offset, jintw m, jdoublew s, jdoublew sep, jdoubleArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jint liwork, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jdouble * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jdouble * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jclass jni_sClass = (*env)->GetObjectClass(env, s);
  jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
  jdouble jni_s = (*env)->GetDoubleField(env, s, jni_sId);
  jclass jni_sepClass = (*env)->GetObjectClass(env, sep);
  jfieldID jni_sepId = (*env)->GetFieldID(env, jni_sepClass, "val", "D");
  jdouble jni_sep = (*env)->GetDoubleField(env, sep, jni_sepId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrsen_work(LAPACK_COL_MAJOR, jni_job[0], jni_compq[0], jni_select + _select_offset, n, jni_t + _t_offset, ldt, jni_q + _q_offset, ldq, jni_wr + _wr_offset, jni_wi + _wi_offset, &jni_m, &jni_s, &jni_sep, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset, liwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetDoubleField(env, sep, jni_sepId, jni_sep);
  (*env)->SetDoubleField(env, s, jni_sId, jni_s);
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrsna (JNIEnv * env, jobject calling_obj, jstring job, jstring howmny, jbooleanArray select, jint n, jdoubleArray t, jint ldt, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray s, jdoubleArray sep, jint mm, jintw m, jdoubleArray work, jint ldwork, jintArray iwork, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_sep = NULL;
  if (sep != NULL) {
    jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
    check_memory(env, jni_sep);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrsna_work(LAPACK_COL_MAJOR, jni_job[0], jni_howmny[0], jni_select, n, jni_t, ldt, jni_vl, ldvl, jni_vr, ldvr, jni_s, jni_sep, mm, &jni_m, jni_work, ldwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (sep != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrsna_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring howmny, jbooleanArray select, jint _select_offset, jint n, jdoubleArray t, jint _t_offset, jint ldt, jdoubleArray vl, jint _vl_offset, jint ldvl, jdoubleArray vr, jint _vr_offset, jint ldvr, jdoubleArray s, jint _s_offset, jdoubleArray sep, jint _sep_offset, jint mm, jintw m, jdoubleArray work, jint _work_offset, jint ldwork, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_t = NULL;
  if (t != NULL) {
    jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
    check_memory(env, jni_t);
  }
  jdouble * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jdouble * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jdouble * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jdouble * jni_sep = NULL;
  if (sep != NULL) {
    jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
    check_memory(env, jni_sep);
  }
  jclass jni_mClass = (*env)->GetObjectClass(env, m);
  jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
  jint jni_m = (*env)->GetIntField(env, m, jni_mId);
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrsna_work(LAPACK_COL_MAJOR, jni_job[0], jni_howmny[0], jni_select + _select_offset, n, jni_t + _t_offset, ldt, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, jni_s + _s_offset, jni_sep + _sep_offset, mm, &jni_m, jni_work + _work_offset, ldwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, m, jni_mId, jni_m);
  if (sep != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (t != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrsyl (JNIEnv * env, jobject calling_obj, jstring trana, jstring tranb, jint isgn, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray c, jint Ldc, jdoublew scale, jintw info) {
  char * jni_trana = (char *)(*env)->GetStringUTFChars(env, trana, JNI_FALSE);
  char * jni_tranb = (char *)(*env)->GetStringUTFChars(env, tranb, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
  jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
  jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrsyl_work(LAPACK_COL_MAJOR, jni_trana[0], jni_tranb[0], isgn, m, n, jni_a, lda, jni_b, ldb, jni_c, Ldc, &jni_scale);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, tranb, jni_tranb);
  (*env)->ReleaseStringUTFChars(env, trana, jni_trana);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrsyl_1offsets (JNIEnv * env, jobject calling_obj, jstring trana, jstring tranb, jint isgn, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdoubleArray c, jint _c_offset, jint Ldc, jdoublew scale, jintw info) {
  char * jni_trana = (char *)(*env)->GetStringUTFChars(env, trana, JNI_FALSE);
  char * jni_tranb = (char *)(*env)->GetStringUTFChars(env, tranb, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
  jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
  jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrsyl_work(LAPACK_COL_MAJOR, jni_trana[0], jni_tranb[0], isgn, m, n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_c + _c_offset, Ldc, &jni_scale);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, tranb, jni_tranb);
  (*env)->ReleaseStringUTFChars(env, trana, jni_trana);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrtri (JNIEnv * env, jobject calling_obj, jstring uplo, jstring diag, jint n, jdoubleArray a, jint lda, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrtri_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_diag[0], n, jni_a, lda);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrtri_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring diag, jint n, jdoubleArray a, jint _a_offset, jint lda, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrtri_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_diag[0], n, jni_a + _a_offset, lda);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrtrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrtrs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, nrhs, jni_a, lda, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtrtrs_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtrtrs_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_trans[0], jni_diag[0], n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtzrzf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtzrzf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_dtzrzf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray tau, jint _tau_offset, jdoubleArray work, jint _work_offset, jint lwork, jintw info) {
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jdouble * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_dtzrzf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sbdsdc (JNIEnv * env, jobject calling_obj, jstring uplo, jstring compq, jint n, jfloatArray d, jfloatArray e, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jfloatArray q, jintArray iq, jfloatArray work, jintArray iwork, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jfloat * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jfloat * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jfloat * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jint * jni_iq = NULL;
  if (iq != NULL) {
    jni_iq = (*env)->GetPrimitiveArrayCritical(env, iq, JNI_FALSE);
    check_memory(env, jni_iq);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sbdsdc_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_compq[0], n, jni_d, jni_e, jni_u, ldu, jni_vt, ldvt, jni_q, jni_iq, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (iq != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iq, jni_iq, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sbdsdc_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring compq, jint n, jfloatArray d, jint _d_offset, jfloatArray e, jint _e_offset, jfloatArray u, jint _u_offset, jint ldu, jfloatArray vt, jint _vt_offset, jint ldvt, jfloatArray q, jint _q_offset, jintArray iq, jint _iq_offset, jfloatArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jfloat * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jfloat * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jfloat * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jint * jni_iq = NULL;
  if (iq != NULL) {
    jni_iq = (*env)->GetPrimitiveArrayCritical(env, iq, JNI_FALSE);
    check_memory(env, jni_iq);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sbdsdc_work(LAPACK_COL_MAJOR, jni_uplo[0], jni_compq[0], n, jni_d + _d_offset, jni_e + _e_offset, jni_u + _u_offset, ldu, jni_vt + _vt_offset, ldvt, jni_q + _q_offset, jni_iq + _iq_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (iq != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iq, jni_iq, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, compq, jni_compq);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sbdsqr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint ncvt, jint nru, jint ncc, jfloatArray d, jfloatArray e, jfloatArray vt, jint ldvt, jfloatArray u, jint ldu, jfloatArray c, jint Ldc, jfloatArray work, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jfloat * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jfloat * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sbdsqr_work(LAPACK_COL_MAJOR, jni_uplo[0], n, ncvt, nru, ncc, jni_d, jni_e, jni_vt, ldvt, jni_u, ldu, jni_c, Ldc, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sbdsqr_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint ncvt, jint nru, jint ncc, jfloatArray d, jint _d_offset, jfloatArray e, jint _e_offset, jfloatArray vt, jint _vt_offset, jint ldvt, jfloatArray u, jint _u_offset, jint ldu, jfloatArray c, jint _c_offset, jint Ldc, jfloatArray work, jint _work_offset, jintw info) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jfloat * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jfloat * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sbdsqr_work(LAPACK_COL_MAJOR, jni_uplo[0], n, ncvt, nru, ncc, jni_d + _d_offset, jni_e + _e_offset, jni_vt + _vt_offset, ldvt, jni_u + _u_offset, ldu, jni_c + _c_offset, Ldc, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sdisna (JNIEnv * env, jobject calling_obj, jstring job, jint m, jint n, jfloatArray d, jfloatArray sep, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_sep = NULL;
  if (sep != NULL) {
    jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
    check_memory(env, jni_sep);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sdisna_work(jni_job[0], m, n, jni_d, jni_sep);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (sep != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sdisna_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jint m, jint n, jfloatArray d, jint _d_offset, jfloatArray sep, jint _sep_offset, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_sep = NULL;
  if (sep != NULL) {
    jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
    check_memory(env, jni_sep);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sdisna_work(jni_job[0], m, n, jni_d + _d_offset, jni_sep + _sep_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (sep != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbbrd (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint ncc, jint kl, jint ku, jfloatArray ab, jint ldab, jfloatArray d, jfloatArray e, jfloatArray q, jint ldq, jfloatArray pt, jint ldpt, jfloatArray c, jint Ldc, jfloatArray work, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jfloat * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jfloat * jni_pt = NULL;
  if (pt != NULL) {
    jni_pt = (*env)->GetPrimitiveArrayCritical(env, pt, JNI_FALSE);
    check_memory(env, jni_pt);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbbrd_work(LAPACK_COL_MAJOR, jni_vect[0], m, n, ncc, kl, ku, jni_ab, ldab, jni_d, jni_e, jni_q, ldq, jni_pt, ldpt, jni_c, Ldc, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (pt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, pt, jni_pt, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbbrd_1offsets (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint ncc, jint kl, jint ku, jfloatArray ab, jint _ab_offset, jint ldab, jfloatArray d, jint _d_offset, jfloatArray e, jint _e_offset, jfloatArray q, jint _q_offset, jint ldq, jfloatArray pt, jint _pt_offset, jint ldpt, jfloatArray c, jint _c_offset, jint Ldc, jfloatArray work, jint _work_offset, jintw info) {
  char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jfloat * jni_q = NULL;
  if (q != NULL) {
    jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
    check_memory(env, jni_q);
  }
  jfloat * jni_pt = NULL;
  if (pt != NULL) {
    jni_pt = (*env)->GetPrimitiveArrayCritical(env, pt, JNI_FALSE);
    check_memory(env, jni_pt);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbbrd_work(LAPACK_COL_MAJOR, jni_vect[0], m, n, ncc, kl, ku, jni_ab + _ab_offset, ldab, jni_d + _d_offset, jni_e + _e_offset, jni_q + _q_offset, ldq, jni_pt + _pt_offset, ldpt, jni_c + _c_offset, Ldc, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (pt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, pt, jni_pt, 0);
  }
  if (q != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, vect, jni_vect);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbcon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jint kl, jint ku, jfloatArray ab, jint ldab, jintArray ipiv, jfloat anorm, jfloatw rcond, jfloatArray work, jintArray iwork, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "F");
  jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbcon_work(LAPACK_COL_MAJOR, jni_norm[0], n, kl, ku, jni_ab, ldab, jni_ipiv, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbcon_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jint kl, jint ku, jfloatArray ab, jint _ab_offset, jint ldab, jintArray ipiv, jint _ipiv_offset, jfloat anorm, jfloatw rcond, jfloatArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "F");
  jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbcon_work(LAPACK_COL_MAJOR, jni_norm[0], n, kl, ku, jni_ab + _ab_offset, ldab, jni_ipiv + _ipiv_offset, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbequ (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jfloatArray ab, jint ldab, jfloatArray r, jfloatArray c, jfloatw rowcnd, jfloatw colcnd, jfloatw amax, jintw info) {
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jfloat * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
  jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "F");
  jfloat jni_rowcnd = (*env)->GetFloatField(env, rowcnd, jni_rowcndId);
  jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
  jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "F");
  jfloat jni_colcnd = (*env)->GetFloatField(env, colcnd, jni_colcndId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "F");
  jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbequ_work(LAPACK_COL_MAJOR, m, n, kl, ku, jni_ab, ldab, jni_r, jni_c, &jni_rowcnd, &jni_colcnd, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetFloatField(env, colcnd, jni_colcndId, jni_colcnd);
  (*env)->SetFloatField(env, rowcnd, jni_rowcndId, jni_rowcnd);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbequ_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jfloatArray ab, jint _ab_offset, jint ldab, jfloatArray r, jint _r_offset, jfloatArray c, jint _c_offset, jfloatw rowcnd, jfloatw colcnd, jfloatw amax, jintw info) {
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jfloat * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
  jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "F");
  jfloat jni_rowcnd = (*env)->GetFloatField(env, rowcnd, jni_rowcndId);
  jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
  jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "F");
  jfloat jni_colcnd = (*env)->GetFloatField(env, colcnd, jni_colcndId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "F");
  jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbequ_work(LAPACK_COL_MAJOR, m, n, kl, ku, jni_ab + _ab_offset, ldab, jni_r + _r_offset, jni_c + _c_offset, &jni_rowcnd, &jni_colcnd, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetFloatField(env, colcnd, jni_colcndId, jni_colcnd);
  (*env)->SetFloatField(env, rowcnd, jni_rowcndId, jni_rowcnd);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbrfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint ldab, jfloatArray afb, jint ldafb, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jfloat * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jfloat * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbrfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, kl, ku, nrhs, jni_ab, ldab, jni_afb, ldafb, jni_ipiv, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbrfs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint _ab_offset, jint ldab, jfloatArray afb, jint _afb_offset, jint ldafb, jintArray ipiv, jint _ipiv_offset, jfloatArray b, jint _b_offset, jint ldb, jfloatArray x, jint _x_offset, jint ldx, jfloatArray ferr, jint _ferr_offset, jfloatArray berr, jint _berr_offset, jfloatArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jfloat * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jfloat * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbrfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, kl, ku, nrhs, jni_ab + _ab_offset, ldab, jni_afb + _afb_offset, ldafb, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbsv (JNIEnv * env, jobject calling_obj, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint ldab, jintArray ipiv, jfloatArray b, jint ldb, jintw info) {
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbsv_work(LAPACK_COL_MAJOR, n, kl, ku, nrhs, jni_ab, ldab, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbsv_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint _ab_offset, jint ldab, jintArray ipiv, jint _ipiv_offset, jfloatArray b, jint _b_offset, jint ldb, jintw info) {
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbsv_work(LAPACK_COL_MAJOR, n, kl, ku, nrhs, jni_ab + _ab_offset, ldab, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint ldab, jfloatArray afb, jint ldafb, jintArray ipiv, jstringw equed, jfloatArray r, jfloatArray c, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatw rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jfloat * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jfloat * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "F");
  jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
  jfloat * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jfloat * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, kl, ku, nrhs, jni_ab, ldab, jni_afb, ldafb, jni_ipiv, jni_equed, jni_r, jni_c, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbsvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint _ab_offset, jint ldab, jfloatArray afb, jint _afb_offset, jint ldafb, jintArray ipiv, jint _ipiv_offset, jstringw equed, jfloatArray r, jint _r_offset, jfloatArray c, jint _c_offset, jfloatArray b, jint _b_offset, jint ldb, jfloatArray x, jint _x_offset, jint ldx, jfloatw rcond, jfloatArray ferr, jint _ferr_offset, jfloatArray berr, jint _berr_offset, jfloatArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jfloat * jni_afb = NULL;
  if (afb != NULL) {
    jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
    check_memory(env, jni_afb);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jfloat * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "F");
  jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
  jfloat * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jfloat * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbsvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, kl, ku, nrhs, jni_ab + _ab_offset, ldab, jni_afb + _afb_offset, ldafb, jni_ipiv + _ipiv_offset, jni_equed, jni_r + _r_offset, jni_c + _c_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (afb != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbtrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jfloatArray ab, jint ldab, jintArray ipiv, jintw info) {
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbtrf_work(LAPACK_COL_MAJOR, m, n, kl, ku, jni_ab, ldab, jni_ipiv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbtrf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jfloatArray ab, jint _ab_offset, jint ldab, jintArray ipiv, jint _ipiv_offset, jintw info) {
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbtrf_work(LAPACK_COL_MAJOR, m, n, kl, ku, jni_ab + _ab_offset, ldab, jni_ipiv + _ipiv_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbtrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint ldab, jintArray ipiv, jfloatArray b, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbtrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, kl, ku, nrhs, jni_ab, ldab, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgbtrs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint _ab_offset, jint ldab, jintArray ipiv, jint _ipiv_offset, jfloatArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_ab = NULL;
  if (ab != NULL) {
    jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
    check_memory(env, jni_ab);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgbtrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, kl, ku, nrhs, jni_ab + _ab_offset, ldab, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (ab != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgebak (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jfloatArray scale, jint m, jfloatArray v, jint ldv, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jfloat * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgebak_work(LAPACK_COL_MAJOR, jni_job[0], jni_side[0], n, ilo, ihi, jni_scale, m, jni_v, ldv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgebak_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jfloatArray scale, jint _scale_offset, jint m, jfloatArray v, jint _v_offset, jint ldv, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jfloat * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgebak_work(LAPACK_COL_MAJOR, jni_job[0], jni_side[0], n, ilo, ihi, jni_scale + _scale_offset, m, jni_v + _v_offset, ldv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgebal (JNIEnv * env, jobject calling_obj, jstring job, jint n, jfloatArray a, jint lda, jintw ilo, jintw ihi, jfloatArray scale, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jfloat * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgebal_work(LAPACK_COL_MAJOR, jni_job[0], n, jni_a, lda, &jni_ilo, &jni_ihi, jni_scale);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgebal_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jint n, jfloatArray a, jint _a_offset, jint lda, jintw ilo, jintw ihi, jfloatArray scale, jint _scale_offset, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jfloat * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgebal_work(LAPACK_COL_MAJOR, jni_job[0], n, jni_a + _a_offset, lda, &jni_ilo, &jni_ihi, jni_scale + _scale_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgebrd (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray d, jfloatArray e, jfloatArray tauq, jfloatArray taup, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jfloat * jni_tauq = NULL;
  if (tauq != NULL) {
    jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
    check_memory(env, jni_tauq);
  }
  jfloat * jni_taup = NULL;
  if (taup != NULL) {
    jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
    check_memory(env, jni_taup);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgebrd_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_d, jni_e, jni_tauq, jni_taup, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (taup != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
  }
  if (tauq != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgebrd_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray d, jint _d_offset, jfloatArray e, jint _e_offset, jfloatArray tauq, jint _tauq_offset, jfloatArray taup, jint _taup_offset, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_e = NULL;
  if (e != NULL) {
    jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
    check_memory(env, jni_e);
  }
  jfloat * jni_tauq = NULL;
  if (tauq != NULL) {
    jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
    check_memory(env, jni_tauq);
  }
  jfloat * jni_taup = NULL;
  if (taup != NULL) {
    jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
    check_memory(env, jni_taup);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgebrd_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_d + _d_offset, jni_e + _e_offset, jni_tauq + _tauq_offset, jni_taup + _taup_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (taup != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
  }
  if (tauq != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
  }
  if (e != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgecon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jfloatArray a, jint lda, jfloat anorm, jfloatw rcond, jfloatArray work, jintArray iwork, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "F");
  jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgecon_work(LAPACK_COL_MAJOR, jni_norm[0], n, jni_a, lda, anorm, &jni_rcond, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgecon_1offsets (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jfloatArray a, jint _a_offset, jint lda, jfloat anorm, jfloatw rcond, jfloatArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "F");
  jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgecon_work(LAPACK_COL_MAJOR, jni_norm[0], n, jni_a + _a_offset, lda, anorm, &jni_rcond, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, norm, jni_norm);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeequ (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray r, jfloatArray c, jfloatw rowcnd, jfloatw colcnd, jfloatw amax, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
  jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "F");
  jfloat jni_rowcnd = (*env)->GetFloatField(env, rowcnd, jni_rowcndId);
  jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
  jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "F");
  jfloat jni_colcnd = (*env)->GetFloatField(env, colcnd, jni_colcndId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "F");
  jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeequ_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_r, jni_c, &jni_rowcnd, &jni_colcnd, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetFloatField(env, colcnd, jni_colcndId, jni_colcnd);
  (*env)->SetFloatField(env, rowcnd, jni_rowcndId, jni_rowcnd);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeequ_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray r, jint _r_offset, jfloatArray c, jint _c_offset, jfloatw rowcnd, jfloatw colcnd, jfloatw amax, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
  jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "F");
  jfloat jni_rowcnd = (*env)->GetFloatField(env, rowcnd, jni_rowcndId);
  jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
  jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "F");
  jfloat jni_colcnd = (*env)->GetFloatField(env, colcnd, jni_colcndId);
  jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
  jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "F");
  jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeequ_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_r + _r_offset, jni_c + _c_offset, &jni_rowcnd, &jni_colcnd, &jni_amax);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  (*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
  (*env)->SetFloatField(env, colcnd, jni_colcndId, jni_colcnd);
  (*env)->SetFloatField(env, rowcnd, jni_rowcndId, jni_rowcnd);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeev (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jfloatArray a, jint lda, jfloatArray wr, jfloatArray wi, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jfloatArray work, jint lwork, jintw info) {
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jfloat * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jfloat * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jfloat * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeev_work(LAPACK_COL_MAJOR, jni_jobvl[0], jni_jobvr[0], n, jni_a, lda, jni_wr, jni_wi, jni_vl, ldvl, jni_vr, ldvr, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeev_1offsets (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray wr, jint _wr_offset, jfloatArray wi, jint _wi_offset, jfloatArray vl, jint _vl_offset, jint ldvl, jfloatArray vr, jint _vr_offset, jint ldvr, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jfloat * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jfloat * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jfloat * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeev_work(LAPACK_COL_MAJOR, jni_jobvl[0], jni_jobvr[0], n, jni_a + _a_offset, lda, jni_wr + _wr_offset, jni_wi + _wi_offset, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeevx (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jfloatArray a, jint lda, jfloatArray wr, jfloatArray wi, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jintw ilo, jintw ihi, jfloatArray scale, jfloatw abnrm, jfloatArray rconde, jfloatArray rcondv, jfloatArray work, jint lwork, jintArray iwork, jintw info) {
  char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jfloat * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jfloat * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jfloat * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jfloat * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
  jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "F");
  jfloat jni_abnrm = (*env)->GetFloatField(env, abnrm, jni_abnrmId);
  jfloat * jni_rconde = NULL;
  if (rconde != NULL) {
    jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
    check_memory(env, jni_rconde);
  }
  jfloat * jni_rcondv = NULL;
  if (rcondv != NULL) {
    jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
    check_memory(env, jni_rcondv);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeevx_work(LAPACK_COL_MAJOR, jni_balanc[0], jni_jobvl[0], jni_jobvr[0], jni_sense[0], n, jni_a, lda, jni_wr, jni_wi, jni_vl, ldvl, jni_vr, ldvr, &jni_ilo, &jni_ihi, jni_scale, &jni_abnrm, jni_rconde, jni_rcondv, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rcondv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
  }
  if (rconde != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
  }
  (*env)->SetFloatField(env, abnrm, jni_abnrmId, jni_abnrm);
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, sense, jni_sense);
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
  (*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeevx_1offsets (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray wr, jint _wr_offset, jfloatArray wi, jint _wi_offset, jfloatArray vl, jint _vl_offset, jint ldvl, jfloatArray vr, jint _vr_offset, jint ldvr, jintw ilo, jintw ihi, jfloatArray scale, jint _scale_offset, jfloatw abnrm, jfloatArray rconde, jint _rconde_offset, jfloatArray rcondv, jint _rcondv_offset, jfloatArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_wr = NULL;
  if (wr != NULL) {
    jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
    check_memory(env, jni_wr);
  }
  jfloat * jni_wi = NULL;
  if (wi != NULL) {
    jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
    check_memory(env, jni_wi);
  }
  jfloat * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jfloat * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jfloat * jni_scale = NULL;
  if (scale != NULL) {
    jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
    check_memory(env, jni_scale);
  }
  jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
  jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "F");
  jfloat jni_abnrm = (*env)->GetFloatField(env, abnrm, jni_abnrmId);
  jfloat * jni_rconde = NULL;
  if (rconde != NULL) {
    jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
    check_memory(env, jni_rconde);
  }
  jfloat * jni_rcondv = NULL;
  if (rcondv != NULL) {
    jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
    check_memory(env, jni_rcondv);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeevx_work(LAPACK_COL_MAJOR, jni_balanc[0], jni_jobvl[0], jni_jobvr[0], jni_sense[0], n, jni_a + _a_offset, lda, jni_wr + _wr_offset, jni_wi + _wi_offset, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, &jni_ilo, &jni_ihi, jni_scale + _scale_offset, &jni_abnrm, jni_rconde + _rconde_offset, jni_rcondv + _rcondv_offset, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rcondv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
  }
  if (rconde != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
  }
  (*env)->SetFloatField(env, abnrm, jni_abnrmId, jni_abnrm);
  if (scale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (wi != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
  }
  if (wr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, sense, jni_sense);
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
  (*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgehrd (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgehrd_work(LAPACK_COL_MAJOR, n, ilo, ihi, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgehrd_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jfloatArray a, jint _a_offset, jint lda, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgehrd_work(LAPACK_COL_MAJOR, n, ilo, ihi, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelq2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelq2_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelq2_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelq2_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelqf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelqf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelqf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgels (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray work, jint lwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgels_work(LAPACK_COL_MAJOR, jni_trans[0], m, n, nrhs, jni_a, lda, jni_b, ldb, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgels_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint nrhs, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgels_work(LAPACK_COL_MAJOR, jni_trans[0], m, n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelsd (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray s, jfloat rcond, jintw rank, jfloatArray work, jint lwork, jintArray iwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelsd_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a, lda, jni_b, ldb, jni_s, rcond, &jni_rank, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelsd_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jfloatArray s, jint _s_offset, jfloat rcond, jintw rank, jfloatArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelsd_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_s + _s_offset, rcond, &jni_rank, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelss (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray s, jfloat rcond, jintw rank, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelss_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a, lda, jni_b, ldb, jni_s, rcond, &jni_rank, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelss_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jfloatArray s, jint _s_offset, jfloat rcond, jintw rank, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelss_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_s + _s_offset, rcond, &jni_rank, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelsy (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jintArray jpvt, jfloat rcond, jintw rank, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelsy_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a, lda, jni_b, ldb, jni_jpvt, rcond, &jni_rank, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgelsy_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jintArray jpvt, jint _jpvt_offset, jfloat rcond, jintw rank, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
  jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
  jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgelsy_work(LAPACK_COL_MAJOR, m, n, nrhs, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_jpvt + _jpvt_offset, rcond, &jni_rank, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  (*env)->SetIntField(env, rank, jni_rankId, jni_rank);
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqlf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqlf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqlf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqlf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqp3 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jintArray jpvt, jfloatArray tau, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqp3_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_jpvt, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqp3_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jintArray jpvt, jint _jpvt_offset, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqp3_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_jpvt + _jpvt_offset, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqpf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jintArray jpvt, jfloatArray tau, jfloatArray work, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqpf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_jpvt, jni_tau, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqpf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jintArray jpvt, jint _jpvt_offset, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_jpvt = NULL;
  if (jpvt != NULL) {
    jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
    check_memory(env, jni_jpvt);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqpf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_jpvt + _jpvt_offset, jni_tau + _tau_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (jpvt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqr2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqr2_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqr2_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqr2_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqrf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgeqrf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgeqrf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgerfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray af, jint ldaf, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jfloat * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgerfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_a, lda, jni_af, ldaf, jni_ipiv, jni_b, ldb, jni_x, ldx, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgerfs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloatArray a, jint _a_offset, jint lda, jfloatArray af, jint _af_offset, jint ldaf, jintArray ipiv, jint _ipiv_offset, jfloatArray b, jint _b_offset, jint ldb, jfloatArray x, jint _x_offset, jint ldx, jfloatArray ferr, jint _ferr_offset, jfloatArray berr, jint _berr_offset, jfloatArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jfloat * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgerfs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_a + _a_offset, lda, jni_af + _af_offset, ldaf, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgerqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgerqf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_tau, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgerqf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray tau, jint _tau_offset, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_tau = NULL;
  if (tau != NULL) {
    jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
    check_memory(env, jni_tau);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgerqf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_tau + _tau_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (tau != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgesdd (JNIEnv * env, jobject calling_obj, jstring jobz, jint m, jint n, jfloatArray a, jint lda, jfloatArray s, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jfloatArray work, jint lwork, jintArray iwork, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jfloat * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jfloat * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgesdd_work(LAPACK_COL_MAJOR, jni_jobz[0], m, n, jni_a, lda, jni_s, jni_u, ldu, jni_vt, ldvt, jni_work, lwork, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgesdd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobz, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray s, jint _s_offset, jfloatArray u, jint _u_offset, jint ldu, jfloatArray vt, jint _vt_offset, jint ldvt, jfloatArray work, jint _work_offset, jint lwork, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jfloat * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jfloat * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgesdd_work(LAPACK_COL_MAJOR, jni_jobz[0], m, n, jni_a + _a_offset, lda, jni_s + _s_offset, jni_u + _u_offset, ldu, jni_vt + _vt_offset, ldvt, jni_work + _work_offset, lwork, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgesv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jfloatArray a, jint lda, jintArray ipiv, jfloatArray b, jint ldb, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgesv_work(LAPACK_COL_MAJOR, n, nrhs, jni_a, lda, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgesv_1offsets (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jfloatArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jfloatArray b, jint _b_offset, jint ldb, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgesv_work(LAPACK_COL_MAJOR, n, nrhs, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgesvd (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobvt, jint m, jint n, jfloatArray a, jint lda, jfloatArray s, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jfloatArray work, jint lwork, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobvt = (char *)(*env)->GetStringUTFChars(env, jobvt, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jfloat * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jfloat * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgesvd_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobvt[0], m, n, jni_a, lda, jni_s, jni_u, ldu, jni_vt, ldvt, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvt, jni_jobvt);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgesvd_1offsets (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobvt, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray s, jint _s_offset, jfloatArray u, jint _u_offset, jint ldu, jfloatArray vt, jint _vt_offset, jint ldvt, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
  char * jni_jobvt = (char *)(*env)->GetStringUTFChars(env, jobvt, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_s = NULL;
  if (s != NULL) {
    jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
    check_memory(env, jni_s);
  }
  jfloat * jni_u = NULL;
  if (u != NULL) {
    jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
    check_memory(env, jni_u);
  }
  jfloat * jni_vt = NULL;
  if (vt != NULL) {
    jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
    check_memory(env, jni_vt);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgesvd_work(LAPACK_COL_MAJOR, jni_jobu[0], jni_jobvt[0], m, n, jni_a + _a_offset, lda, jni_s + _s_offset, jni_u + _u_offset, ldu, jni_vt + _vt_offset, ldvt, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vt != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
  }
  if (u != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
  }
  if (s != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvt, jni_jobvt);
  (*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgesvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray af, jint ldaf, jintArray ipiv, jstringw equed, jfloatArray r, jfloatArray c, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatw rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jfloat * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "F");
  jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
  jfloat * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jfloat * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgesvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, nrhs, jni_a, lda, jni_af, ldaf, jni_ipiv, jni_equed, jni_r, jni_c, jni_b, ldb, jni_x, ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgesvx_1offsets (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jfloatArray a, jint _a_offset, jint lda, jfloatArray af, jint _af_offset, jint ldaf, jintArray ipiv, jint _ipiv_offset, jstringw equed, jfloatArray r, jint _r_offset, jfloatArray c, jint _c_offset, jfloatArray b, jint _b_offset, jint ldb, jfloatArray x, jint _x_offset, jint ldx, jfloatw rcond, jfloatArray ferr, jint _ferr_offset, jfloatArray berr, jint _berr_offset, jfloatArray work, jint _work_offset, jintArray iwork, jint _iwork_offset, jintw info) {
  char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_af = NULL;
  if (af != NULL) {
    jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
    check_memory(env, jni_af);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
  jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
  jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
  char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
  jfloat * jni_r = NULL;
  if (r != NULL) {
    jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
    check_memory(env, jni_r);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
  jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "F");
  jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
  jfloat * jni_ferr = NULL;
  if (ferr != NULL) {
    jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
    check_memory(env, jni_ferr);
  }
  jfloat * jni_berr = NULL;
  if (berr != NULL) {
    jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
    check_memory(env, jni_berr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jint * jni_iwork = NULL;
  if (iwork != NULL) {
    jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
    check_memory(env, jni_iwork);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgesvx_work(LAPACK_COL_MAJOR, jni_fact[0], jni_trans[0], n, nrhs, jni_a + _a_offset, lda, jni_af + _af_offset, ldaf, jni_ipiv + _ipiv_offset, jni_equed, jni_r + _r_offset, jni_c + _c_offset, jni_b + _b_offset, ldb, jni_x + _x_offset, ldx, &jni_rcond, jni_ferr + _ferr_offset, jni_berr + _berr_offset, jni_work + _work_offset, jni_iwork + _iwork_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (iwork != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
  }
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (berr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
  }
  if (ferr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
  }
  (*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (r != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
  }
  (*env)->SetObjectField(env, equed, jni_equedId, (*env)->NewStringUTF(env, jni_equed));
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (af != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, fact, jni_fact);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgetf2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jintArray ipiv, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgetf2_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_ipiv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgetf2_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgetf2_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgetrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jintArray ipiv, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgetrf_work(LAPACK_COL_MAJOR, m, n, jni_a, lda, jni_ipiv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgetrf_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgetrf_work(LAPACK_COL_MAJOR, m, n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgetri (JNIEnv * env, jobject calling_obj, jint n, jfloatArray a, jint lda, jintArray ipiv, jfloatArray work, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgetri_work(LAPACK_COL_MAJOR, n, jni_a, lda, jni_ipiv, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgetri_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgetri_work(LAPACK_COL_MAJOR, n, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgetrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloatArray a, jint lda, jintArray ipiv, jfloatArray b, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgetrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_a, lda, jni_ipiv, jni_b, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sgetrs_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloatArray a, jint _a_offset, jint lda, jintArray ipiv, jint _ipiv_offset, jfloatArray b, jint _b_offset, jint ldb, jintw info) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jint * jni_ipiv = NULL;
  if (ipiv != NULL) {
    jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
    check_memory(env, jni_ipiv);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sgetrs_work(LAPACK_COL_MAJOR, jni_trans[0], n, nrhs, jni_a + _a_offset, lda, jni_ipiv + _ipiv_offset, jni_b + _b_offset, ldb);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (ipiv != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sggbak (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jfloatArray lscale, jfloatArray rscale, jint m, jfloatArray v, jint ldv, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jfloat * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jfloat * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sggbak_work(LAPACK_COL_MAJOR, jni_job[0], jni_side[0], n, ilo, ihi, jni_lscale, jni_rscale, m, jni_v, ldv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sggbak_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jfloatArray lscale, jint _lscale_offset, jfloatArray rscale, jint _rscale_offset, jint m, jfloatArray v, jint _v_offset, jint ldv, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  jfloat * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jfloat * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sggbak_work(LAPACK_COL_MAJOR, jni_job[0], jni_side[0], n, ilo, ihi, jni_lscale + _lscale_offset, jni_rscale + _rscale_offset, m, jni_v + _v_offset, ldv);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sggbal (JNIEnv * env, jobject calling_obj, jstring job, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jintw ilo, jintw ihi, jfloatArray lscale, jfloatArray rscale, jfloatArray work, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jfloat * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jfloat * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sggbal_work(LAPACK_COL_MAJOR, jni_job[0], n, jni_a, lda, jni_b, ldb, &jni_ilo, &jni_ihi, jni_lscale, jni_rscale, jni_work);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sggbal_1offsets (JNIEnv * env, jobject calling_obj, jstring job, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jintw ilo, jintw ihi, jfloatArray lscale, jint _lscale_offset, jfloatArray rscale, jint _rscale_offset, jfloatArray work, jint _work_offset, jintw info) {
  char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
  jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
  jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
  jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
  jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
  jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
  jfloat * jni_lscale = NULL;
  if (lscale != NULL) {
    jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
    check_memory(env, jni_lscale);
  }
  jfloat * jni_rscale = NULL;
  if (rscale != NULL) {
    jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
    check_memory(env, jni_rscale);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sggbal_work(LAPACK_COL_MAJOR, jni_job[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, &jni_ilo, &jni_ihi, jni_lscale + _lscale_offset, jni_rscale + _rscale_offset, jni_work + _work_offset);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (rscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
  }
  if (lscale != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
  }
  (*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
  (*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, job, jni_job);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sggev (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray alphar, jfloatArray alphai, jfloatArray beta, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jfloatArray work, jint lwork, jintw info) {
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jfloat * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jfloat * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jfloat * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jfloat * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sggev_work(LAPACK_COL_MAJOR, jni_jobvl[0], jni_jobvr[0], n, jni_a, lda, jni_b, ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, ldvl, jni_vr, ldvr, jni_work, lwork);
  (*env)->SetIntField(env, info, jni_infoId, returnValue);
  if (work != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
  }
  if (vr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
  }
  if (vl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
  }
  if (beta != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
  }
  if (alphai != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
  }
  if (alphar != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
  (*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefLAPACK_sggev_1offsets (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jfloatArray alphar, jint _alphar_offset, jfloatArray alphai, jint _alphai_offset, jfloatArray beta, jint _beta_offset, jfloatArray vl, jint _vl_offset, jint ldvl, jfloatArray vr, jint _vr_offset, jint ldvr, jfloatArray work, jint _work_offset, jint lwork, jintw info) {
  char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
  char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_alphar = NULL;
  if (alphar != NULL) {
    jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
    check_memory(env, jni_alphar);
  }
  jfloat * jni_alphai = NULL;
  if (alphai != NULL) {
    jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
    check_memory(env, jni_alphai);
  }
  jfloat * jni_beta = NULL;
  if (beta != NULL) {
    jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
    check_memory(env, jni_beta);
  }
  jfloat * jni_vl = NULL;
  if (vl != NULL) {
    jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
    check_memory(env, jni_vl);
  }
  jfloat * jni_vr = NULL;
  if (vr != NULL) {
    jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
    check_memory(env, jni_vr);
  }
  jfloat * jni_work = NULL;
  if (work != NULL) {
    jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
    check_memory(env, jni_work);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  int returnValue = LAPACKE_sggev_work(LAPACK_COL_MAJOR, jni_jobvl[0], jni_jobvr[0], n, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, jni_alphar + _alphar_offset, jni_alphai + _alphai_offset, jni_beta + _beta_offset, jni_vl + _vl_offset, ldvl, jni_vr + _vr_offset, ldvr, jni_work + _work_offset, lwork);
  (*env)->SetIntField(env,