/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.shell.Input;

public class ExtendedInput
implements Input {
    public static final String PIPE = "|";
    public static final String ARROW = ">";
    public static final List<String> KEY_CHARS = Arrays.asList("|", ">");
    private final Input base;

    public ExtendedInput(Input base) {
        this.base = base;
    }

    private static boolean isKeyCharInLine(String str) {
        for (String key : KEY_CHARS) {
            if (!str.contains(key)) continue;
            return true;
        }
        return false;
    }

    public String rawText() {
        String raw = this.base.rawText();
        return raw != null && ExtendedInput.isKeyCharInLine(raw) ? raw.substring(0, this.firstIndexOfKeyChar(raw)) : raw;
    }

    public List<String> words() {
        ArrayList<String> newList = new ArrayList<String>();
        for (String word : this.base.words()) {
            if (KEY_CHARS.contains(word)) {
                return newList;
            }
            newList.add(word);
        }
        return newList;
    }

    private int firstIndexOfKeyChar(String str) {
        int firstIndex = Integer.MAX_VALUE;
        for (String key : KEY_CHARS) {
            int keyIndex = str.indexOf(key);
            if (keyIndex <= -1 || keyIndex >= firstIndex) continue;
            firstIndex = keyIndex;
        }
        return firstIndex;
    }
}

