/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import org.jline.reader.LineReader;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.Primary;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.Shell;
import org.springframework.shell.context.InteractionMode;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.jline.InteractiveShellRunner;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.stereotype.Component;

@Component
@Primary
public class ExtendedInteractiveShellRunner
extends InteractiveShellRunner {
    private final LineReader lineReader;
    private final PromptProvider promptProvider;
    private final Shell shell;
    private final ShellContext shellContext;

    public ExtendedInteractiveShellRunner(LineReader lineReader, PromptProvider promptProvider, Shell shell, ShellContext shellContext) {
        super(lineReader, promptProvider, shell, shellContext);
        this.lineReader = lineReader;
        this.promptProvider = promptProvider;
        this.shell = shell;
        this.shellContext = shellContext;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.shellContext.setInteractionMode(InteractionMode.INTERACTIVE);
        SshShellInputProvider inputProvider = new SshShellInputProvider(this.lineReader, this.promptProvider);
        this.shell.run((InputProvider)inputProvider);
    }

    public boolean canRun(ApplicationArguments args) {
        return false;
    }

    public static class SshShellInputProvider
    extends InteractiveShellRunner.JLineInputProvider {
        public SshShellInputProvider(LineReader lineReader, PromptProvider promptProvider) {
            super(lineReader, promptProvider);
        }

        public Input readInput() {
            SshContext ctx = SshShellCommandFactory.SSH_THREAD_CONTEXT.get();
            if (ctx != null) {
                ctx.getPostProcessorsList().clear();
            }
            return super.readInput();
        }
    }
}

