/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.SshShellRunnable;
import com.github.fonimus.ssh.shell.auth.SshAuthentication;
import com.github.fonimus.ssh.shell.postprocess.PostProcessorObject;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.session.ServerSession;
import org.jline.reader.LineReader;
import org.jline.terminal.Terminal;

public class SshContext {
    private SshShellRunnable sshShellRunnable;
    private Terminal terminal;
    private LineReader lineReader;
    private SshAuthentication authentication;
    private final List<PostProcessorObject> postProcessorsList = new ArrayList<PostProcessorObject>();
    private boolean background;
    private long backgroundCount = 0L;

    public SshContext() {
    }

    public SshContext(SshShellRunnable sshShellRunnable, Terminal terminal, LineReader lineReader, SshAuthentication authentication) {
        this.sshShellRunnable = sshShellRunnable;
        this.terminal = terminal;
        this.lineReader = lineReader;
        this.authentication = authentication;
    }

    public boolean isLocalPrompt() {
        return this.sshShellRunnable == null;
    }

    public ServerSession getSshSession() {
        return this.isLocalPrompt() ? null : this.sshShellRunnable.getSshSession();
    }

    public Environment getSshEnv() {
        return this.isLocalPrompt() ? null : this.sshShellRunnable.getSshEnv();
    }

    public void incrementBackgroundCount() {
        ++this.backgroundCount;
    }

    @Generated
    public SshShellRunnable getSshShellRunnable() {
        return this.sshShellRunnable;
    }

    @Generated
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Generated
    public LineReader getLineReader() {
        return this.lineReader;
    }

    @Generated
    public SshAuthentication getAuthentication() {
        return this.authentication;
    }

    @Generated
    public List<PostProcessorObject> getPostProcessorsList() {
        return this.postProcessorsList;
    }

    @Generated
    public boolean isBackground() {
        return this.background;
    }

    @Generated
    public long getBackgroundCount() {
        return this.backgroundCount;
    }

    @Generated
    public void setBackground(boolean background) {
        this.background = background;
    }
}

