/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fonimus.ssh.shell.SshShellConfiguration;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.auth.SshShellAuthenticationProvider;
import com.github.fonimus.ssh.shell.auth.SshShellPasswordAuthenticationProvider;
import com.github.fonimus.ssh.shell.auth.SshShellSecurityAuthenticationProvider;
import com.github.fonimus.ssh.shell.listeners.SshShellListener;
import com.github.fonimus.ssh.shell.listeners.SshShellListenerService;
import com.github.fonimus.ssh.shell.postprocess.provided.GrepPostProcessor;
import com.github.fonimus.ssh.shell.postprocess.provided.HighlightPostProcessor;
import com.github.fonimus.ssh.shell.postprocess.provided.JsonPointerPostProcessor;
import com.github.fonimus.ssh.shell.postprocess.provided.PrettyJsonPostProcessor;
import com.github.fonimus.ssh.shell.postprocess.provided.SavePostProcessor;
import java.util.List;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.sshd.server.SshServer;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.shell.boot.LineReaderAutoConfiguration;
import org.springframework.shell.boot.SpringShellAutoConfiguration;
import org.springframework.shell.boot.SpringShellProperties;
import org.springframework.shell.context.InteractionMode;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.shell.standard.ValueProvider;

@Configuration
@ConditionalOnClass(value={SshServer.class})
@ConditionalOnProperty(name={"ssh.shell.enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SshShellProperties.class})
@AutoConfigureAfter(value={SpringShellAutoConfiguration.class, LineReaderAutoConfiguration.class}, name={"org.springframework.boot.actuate.autoconfigure.audit.AuditEventsEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.beans.BeansEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.condition.ConditionsReportEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.context.properties.ConfigurationPropertiesReportEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.context.ShutdownEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.env.EnvironmentEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.flyway.FlywayEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.jolokia.JolokiaEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.liquibase.LiquibaseEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.logging.LogFileWebEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.logging.LoggersEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.management.HeapDumpWebEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.management.ThreadDumpEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.metrics.MetricsEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.scheduling.ScheduledTasksEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.session.SessionsEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.trace.http.HttpTraceEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.web.mappings.MappingsEndpointAutoConfiguration"})
@ComponentScan(basePackages={"com.github.fonimus.ssh.shell"})
public class SshShellAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellAutoConfiguration.class);
    private final ApplicationContext context;
    private final SshShellProperties properties;
    private final SpringShellProperties springShellProperties;
    private final ShellContext shellContext;

    @PostConstruct
    public void init() {
        this.springShellProperties.getHistory().setName(this.properties.getHistoryFile().getAbsolutePath());
        this.shellContext.setInteractionMode(InteractionMode.INTERACTIVE);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.main.lazy-initialization"}, havingValue="true")
    public ApplicationListener<ContextRefreshedEvent> lazyInitApplicationListener() {
        return event -> {
            LOGGER.info("Lazy initialization enabled, calling configuration beans explicitly to start ssh server and initialize shell correctly");
            this.context.getBean(SshShellConfiguration.SshServerLifecycle.class);
            this.context.getBeansOfType(Terminal.class);
            this.context.getBeansOfType(ValueProvider.class);
        };
    }

    @Bean
    @ConditionalOnClass(name={"com.fasterxml.jackson.databind.ObjectMapper"})
    public JsonPointerPostProcessor jsonPointerPostProcessor(ObjectMapper mapper) {
        return new JsonPointerPostProcessor(mapper);
    }

    @Bean
    @ConditionalOnClass(name={"com.fasterxml.jackson.databind.ObjectMapper"})
    public PrettyJsonPostProcessor prettyJsonPostProcessor(ObjectMapper mapper) {
        return new PrettyJsonPostProcessor(mapper);
    }

    @Bean
    public SavePostProcessor savePostProcessor() {
        return new SavePostProcessor();
    }

    @Bean
    public GrepPostProcessor grepPostProcessor() {
        return new GrepPostProcessor();
    }

    @Bean
    public HighlightPostProcessor highlightPostProcessor() {
        return new HighlightPostProcessor();
    }

    @Bean
    public SshShellHelper sshShellHelper() {
        return new SshShellHelper(this.properties.getConfirmationWords());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.security.authentication.AuthenticationManager"})
    @ConditionalOnProperty(value={"ssh.shell.authentication"}, havingValue="security")
    public SshShellAuthenticationProvider sshShellSecurityAuthenticationProvider() {
        return new SshShellSecurityAuthenticationProvider(this.context, this.properties.getAuthProviderBeanName());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"ssh.shell.authentication"}, havingValue="simple", matchIfMissing=true)
    public SshShellAuthenticationProvider sshShellSimpleAuthenticationProvider() {
        return new SshShellPasswordAuthenticationProvider(this.properties.getUser(), this.properties.getPassword());
    }

    @Bean
    @ConditionalOnMissingBean
    public PromptProvider sshPromptProvider() {
        return () -> new AttributedString((CharSequence)this.properties.getPrompt().getText(), AttributedStyle.DEFAULT.foreground(this.properties.getPrompt().getColor().toJlineAttributedStyle()));
    }

    @Bean
    public SshShellListenerService sshShellListenerService(@Autowired(required=false) List<SshShellListener> listeners) {
        return new SshShellListenerService(listeners);
    }

    @Generated
    public SshShellAutoConfiguration(ApplicationContext context, SshShellProperties properties, SpringShellProperties springShellProperties, ShellContext shellContext) {
        this.context = context;
        this.properties = properties;
        this.springShellProperties = springShellProperties;
        this.shellContext = shellContext;
    }
}

