/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshIO;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.SshShellRunnable;
import com.github.fonimus.ssh.shell.listeners.SshShellListenerService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.shell.Shell;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.stereotype.Component;

@Component
public class SshShellCommandFactory
implements Command {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellCommandFactory.class);
    public static final ThreadLocal<SshContext> SSH_THREAD_CONTEXT = ThreadLocal.withInitial(() -> null);
    @NonNull
    private final SshShellProperties properties;
    @NonNull
    private final SshShellListenerService shellListenerService;
    @NonNull
    private final Optional<Banner> shellBanner;
    @NonNull
    private final org.springframework.core.env.Environment environment;
    @NonNull
    private final Shell shell;
    @NonNull
    private final LineReader lineReader;
    @NonNull
    private final PromptProvider promptProvider;
    @NonNull
    private Completer completer;
    public static final ThreadLocal<SshIO> SSH_IO_CONTEXT = ThreadLocal.withInitial(SshIO::new);
    private final Map<ChannelSession, Thread> threads = new ConcurrentHashMap<ChannelSession, Thread>();

    public void start(ChannelSession channelSession, Environment sshEnv) {
        SshIO sshIO = SSH_IO_CONTEXT.get();
        Thread sshThread = new Thread(new ThreadGroup("ssh-shell"), new SshShellRunnable(this.properties, this.shellListenerService, this.shellBanner.orElse(null), this.shell, this.lineReader, this.promptProvider, this.completer, this.environment, channelSession, sshEnv, this, sshIO.getIs(), sshIO.getOs(), sshIO.getEc()), "ssh-session-" + System.nanoTime());
        sshThread.start();
        this.threads.put(channelSession, sshThread);
        LOGGER.debug("{}: started [{} session(s) currently active]", (Object)channelSession, (Object)this.threads.size());
    }

    public void destroy(ChannelSession channelSession) {
        Thread sshThread = this.threads.remove(channelSession);
        if (sshThread != null) {
            sshThread.interrupt();
        }
        LOGGER.debug("{}: destroyed [{} session(s) currently active]", (Object)channelSession, (Object)this.threads.size());
    }

    public void setErrorStream(OutputStream errOS) {
    }

    public void setExitCallback(ExitCallback ec) {
        SSH_IO_CONTEXT.get().setEc(ec);
    }

    public void setInputStream(InputStream is) {
        SSH_IO_CONTEXT.get().setIs(is);
    }

    public void setOutputStream(OutputStream os) {
        SSH_IO_CONTEXT.get().setOs(os);
    }

    public Map<Long, ChannelSession> listSessions() {
        return this.threads.keySet().stream().collect(Collectors.toMap(s -> s.getServerSession().getIoSession().getId(), Function.identity()));
    }

    @Generated
    public SshShellCommandFactory(@NonNull SshShellProperties properties, @NonNull SshShellListenerService shellListenerService, @NonNull Optional<Banner> shellBanner, @NonNull org.springframework.core.env.Environment environment, @NonNull Shell shell, @NonNull LineReader lineReader, @NonNull PromptProvider promptProvider, @NonNull Completer completer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (shellListenerService == null) {
            throw new NullPointerException("shellListenerService is marked non-null but is null");
        }
        if (shellBanner == null) {
            throw new NullPointerException("shellBanner is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (shell == null) {
            throw new NullPointerException("shell is marked non-null but is null");
        }
        if (lineReader == null) {
            throw new NullPointerException("lineReader is marked non-null but is null");
        }
        if (promptProvider == null) {
            throw new NullPointerException("promptProvider is marked non-null but is null");
        }
        if (completer == null) {
            throw new NullPointerException("completer is marked non-null but is null");
        }
        this.properties = properties;
        this.shellListenerService = shellListenerService;
        this.shellBanner = shellBanner;
        this.environment = environment;
        this.shell = shell;
        this.lineReader = lineReader;
        this.promptProvider = promptProvider;
        this.completer = completer;
    }
}

