/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.PromptColor;
import com.github.fonimus.ssh.shell.SimpleTable;
import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import com.github.fonimus.ssh.shell.auth.SshAuthentication;
import com.github.fonimus.ssh.shell.interactive.Interactive;
import com.github.fonimus.ssh.shell.interactive.InteractiveInput;
import com.github.fonimus.ssh.shell.interactive.InteractiveInputIO;
import com.github.fonimus.ssh.shell.interactive.KeyBinding;
import com.github.fonimus.ssh.shell.interactive.KeyBindingInput;
import com.github.fonimus.ssh.shell.interactive.StoppableInteractiveInput;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.session.ServerSession;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.shell.table.Aligner;
import org.springframework.shell.table.ArrayTableModel;
import org.springframework.shell.table.CellMatcher;
import org.springframework.shell.table.SimpleHorizontalAligner;
import org.springframework.shell.table.SimpleVerticalAligner;
import org.springframework.shell.table.Table;
import org.springframework.shell.table.TableBuilder;
import org.springframework.shell.table.TableModel;

public class SshShellHelper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellHelper.class);
    public static final String INTERACTIVE_LONG_MESSAGE = "Please press key 'q' to quit, '+' and '-' to increase or decrease refresh delay";
    public static final String INTERACTIVE_SHORT_MESSAGE = "'q': quit, '+'|'-': increase|decrease refresh";
    public static final String EXIT = "_EXIT";
    public static final List<String> DEFAULT_CONFIRM_WORDS = Arrays.asList("y", "yes");
    private static final List<Aligner> DEFAULT_ALIGNERS = Arrays.asList(SimpleHorizontalAligner.center, SimpleVerticalAligner.middle);
    private final List<String> confirmWords;
    @Autowired
    @Lazy
    private Terminal defaultTerminal;
    @Autowired
    @Lazy
    private LineReader defaultLineReader;

    public SshShellHelper(List<String> confirmWords) {
        this.confirmWords = confirmWords != null ? confirmWords : DEFAULT_CONFIRM_WORDS;
    }

    public String getColored(String message, PromptColor color) {
        return SshShellHelper.getColoredMessage(message, color);
    }

    public static String getColoredMessage(String message, PromptColor color) {
        return new AttributedStringBuilder().append((CharSequence)message, AttributedStyle.DEFAULT.foreground(color.toJlineAttributedStyle())).toAnsi();
    }

    public String getBackgroundColored(String message, PromptColor backgroundColor) {
        return SshShellHelper.getBackgroundColoredMessage(message, backgroundColor);
    }

    public static String getBackgroundColoredMessage(String message, PromptColor backgroundColor) {
        return new AttributedStringBuilder().append((CharSequence)message, AttributedStyle.DEFAULT.background(backgroundColor.toJlineAttributedStyle())).toAnsi();
    }

    public boolean confirm(String message, String ... confirmWords) {
        return this.confirm(message, false, confirmWords);
    }

    public boolean confirm(String message, boolean caseSensitive, String ... confirmWords) {
        String response = this.read(message);
        List<String> confirm = this.confirmWords;
        if (confirmWords != null && confirmWords.length > 0) {
            confirm = Arrays.asList(confirmWords);
        }
        for (String c : confirm) {
            if (caseSensitive && c.equals(response)) {
                return true;
            }
            if (caseSensitive || !c.equalsIgnoreCase(response)) continue;
            return true;
        }
        return false;
    }

    public String read() {
        return this.read(null);
    }

    public String read(String message) {
        LineReader lr = this.reader();
        if (message != null) {
            lr.getTerminal().writer().println(message);
        }
        lr.readLine();
        if (lr.getTerminal() instanceof AbstractPosixTerminal) {
            lr.getTerminal().writer().println();
        }
        return lr.getParsedLine().line();
    }

    public String getSuccess(String message) {
        return this.getColored(message, PromptColor.GREEN);
    }

    public String getInfo(String message) {
        return this.getColored(message, PromptColor.CYAN);
    }

    public String getWarning(String message) {
        return this.getColored(message, PromptColor.YELLOW);
    }

    public String getError(String message) {
        return this.getColored(message, PromptColor.RED);
    }

    public void printSuccess(String message) {
        this.print(message, PromptColor.GREEN);
    }

    public void printInfo(String message) {
        this.print(message, PromptColor.CYAN);
    }

    public void printWarning(String message) {
        this.print(message, PromptColor.YELLOW);
    }

    public void printError(String message) {
        this.print(message, PromptColor.RED);
    }

    public void print(String message) {
        this.print(message, null);
    }

    public void print(String message, PromptColor color) {
        String toPrint = message;
        if (color != null) {
            toPrint = this.getColored(message, color);
        }
        this.terminal().writer().println(toPrint);
    }

    public String renderTable(SimpleTable simpleTable) {
        return this.renderTable(this.buildTable(simpleTable));
    }

    public String renderTable(Table table) {
        return table.render(this.terminalSize().getColumns());
    }

    public Table buildTable(SimpleTable simpleTable) {
        int nbColumns = simpleTable.getColumns().size();
        if (nbColumns == 0) {
            throw new IllegalArgumentException("Table should have at least one column");
        }
        int nbLines = simpleTable.getLines().size();
        if (simpleTable.isDisplayHeaders()) {
            ++nbLines;
        }
        Object[][] data = new String[nbLines][simpleTable.getColumns().size()];
        ArrayTableModel model = new ArrayTableModel(data);
        TableBuilder tableBuilder = new TableBuilder((TableModel)model);
        int i = 0;
        if (simpleTable.isDisplayHeaders()) {
            i = 1;
            int c = 0;
            if (simpleTable.getHeaderAligners() == null || simpleTable.getHeaderAligners().isEmpty()) {
                simpleTable.setHeaderAligners(DEFAULT_ALIGNERS);
            }
            for (String header : simpleTable.getColumns()) {
                data[0][c] = header;
                for (Aligner headerAligner : simpleTable.getHeaderAligners()) {
                    tableBuilder.on(SshShellHelper.at(0, c)).addAligner(headerAligner);
                }
                ++c;
            }
        }
        if (simpleTable.getLineAligners() == null || simpleTable.getLineAligners().isEmpty()) {
            simpleTable.setLineAligners(DEFAULT_ALIGNERS);
        }
        for (List<Object> line : simpleTable.getLines()) {
            int c = 0;
            for (Object objValue : line) {
                if (c >= nbColumns) break;
                String value = "";
                if (objValue != null) {
                    value = objValue instanceof String ? (String)objValue : objValue.toString();
                }
                data[i][c] = value;
                for (Aligner lineAligner : simpleTable.getLineAligners()) {
                    tableBuilder.on(SshShellHelper.at(i, c)).addAligner(lineAligner);
                }
                ++c;
            }
            ++i;
        }
        if (simpleTable.getTableBuilderListener() != null) {
            simpleTable.getTableBuilderListener().onBuilt(tableBuilder);
        }
        if (simpleTable.isUseFullBorder()) {
            tableBuilder.addFullBorder(simpleTable.getBorderStyle());
        }
        return tableBuilder.build();
    }

    public static CellMatcher at(int row, int col) {
        return (r, column, model) -> r == row && column == col;
    }

    public SshAuthentication getAuthentication() {
        return SshShellCommandFactory.SSH_THREAD_CONTEXT.get().getAuthentication();
    }

    public ServerSession getSshSession() {
        return SshShellCommandFactory.SSH_THREAD_CONTEXT.get().getSshSession();
    }

    public Environment getSshEnvironment() {
        return SshShellCommandFactory.SSH_THREAD_CONTEXT.get().getSshEnv();
    }

    public boolean isLocalPrompt() {
        SshContext sshContext = SshShellCommandFactory.SSH_THREAD_CONTEXT.get();
        if (sshContext == null) {
            return true;
        }
        return sshContext.isLocalPrompt();
    }

    public boolean checkAuthorities(List<String> authorizedRoles) {
        if (this.isLocalPrompt()) {
            LOGGER.debug("Not an ssh session -> local prompt -> giving all rights");
            return true;
        }
        SshAuthentication auth = SshShellCommandFactory.SSH_THREAD_CONTEXT.get().getAuthentication();
        return this.checkAuthorities(authorizedRoles, auth != null ? auth.getAuthorities() : null, false);
    }

    public boolean checkAuthorities(List<String> authorizedRoles, List<String> authorities, boolean authorizedIfNoAuthorities) {
        if (authorities == null) {
            return authorizedIfNoAuthorities;
        }
        for (String authority : authorities) {
            String check = authority;
            if (check.startsWith("ROLE_")) {
                check = check.substring(5);
            }
            if (!authorizedRoles.contains(check)) continue;
            return true;
        }
        return false;
    }

    public Size terminalSize() {
        return this.terminal().getSize();
    }

    public String progress(int percentage) {
        int current = percentage;
        if (current > 100) {
            current = 100;
            LOGGER.warn("Setting percentage to 100 (was: {})", (Object)percentage);
        }
        return this.progress(current, 100);
    }

    public String progress(int current, int total) {
        StringBuilder builder = new StringBuilder("[");
        int col = this.terminalSize().getColumns();
        int max = col - 3;
        if (max < 0) {
            LOGGER.warn("Terminal is too small to print progress [columns={}]", (Object)col);
            return "";
        }
        int percentage = current * max / total;
        if (percentage > 0) {
            builder.append(String.format("%" + percentage + "s", " ").replaceAll(" ", "="));
        }
        builder.append(">");
        int left = max - percentage;
        if (left > 0) {
            builder.append(String.format("%" + left + "s", ""));
        }
        return builder.append("]").toString();
    }

    private static String generateId() {
        return UUID.randomUUID().toString();
    }

    public PrintWriter terminalWriter() {
        return this.terminal().writer();
    }

    public History getHistory() {
        return new DefaultHistory(this.reader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interactive(Interactive interactive) {
        long[] refreshDelay = new long[]{interactive.getRefreshDelay()};
        int rows = 0;
        int[] maxLines = new int[]{rows};
        Terminal terminal = this.terminal();
        Display display = new Display(terminal, interactive.isFullScreen());
        Size size = interactive.getSize() != null ? interactive.getSize() : new Size();
        BindingReader bindingReader = new BindingReader(terminal.reader());
        size.copy(new Size(terminal.getSize().getColumns(), terminal.getSize().getRows()));
        Terminal.SignalHandler prevHandler = terminal.handle(Terminal.Signal.WINCH, signal -> {
            int previous = size.getColumns();
            size.copy(new Size(terminal.getSize().getColumns(), rows));
            if (size.getColumns() < previous) {
                display.clear();
            }
            maxLines[0] = this.display(interactive.getInput(), display, size, refreshDelay[0]).getLines();
        });
        Attributes attr = terminal.enterRawMode();
        try {
            String op;
            Object id;
            terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            if (interactive.isFullScreen()) {
                terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
                terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
                terminal.writer().flush();
            }
            long t0 = System.currentTimeMillis();
            KeyMap keys = new KeyMap();
            HashMap<Object, KeyBindingInput> inputs = new HashMap<Object, KeyBindingInput>();
            HashSet<String> usedKeys = new HashSet<String>();
            if (interactive.isExit()) {
                keys.bind((Object)EXIT, (CharSequence)"q");
                inputs.put(EXIT, () -> {});
                usedKeys.add("q");
            }
            if (interactive.isIncrease()) {
                id = SshShellHelper.generateId();
                keys.bind(id, (CharSequence)"+");
                inputs.put(id, () -> {
                    refreshDelay[0] = refreshDelay[0] + 1000L;
                    LOGGER.debug("New refresh delay is now: " + refreshDelay[0]);
                });
                usedKeys.add("+");
            }
            if (interactive.isDecrease()) {
                id = SshShellHelper.generateId();
                keys.bind(id, (CharSequence)"-");
                inputs.put(id, () -> {
                    if (refreshDelay[0] > 1000L) {
                        refreshDelay[0] = refreshDelay[0] - 1000L;
                        LOGGER.debug("New refresh delay is now: " + refreshDelay[0]);
                    } else {
                        LOGGER.warn("Cannot decrease delay under 1000 ms");
                    }
                });
                usedKeys.add("-");
            }
            for (KeyBinding binding : interactive.getBindings()) {
                ArrayList<String> newKeys = new ArrayList<String>();
                for (String key : binding.getKeys()) {
                    if (usedKeys.contains(key)) {
                        LOGGER.warn("Binding key not allowed as already used: {}.", (Object)key);
                        continue;
                    }
                    newKeys.add(key);
                }
                if (newKeys.isEmpty()) {
                    LOGGER.error("None of the keys are allowed {}, action [{}] will not be bound", (Object)binding.getDescription(), binding.getKeys());
                    continue;
                }
                String id2 = SshShellHelper.generateId();
                keys.bind((Object)id2, (CharSequence[])newKeys.toArray(new String[0]));
                inputs.put(id2, binding.getInput());
                usedKeys.addAll(newKeys);
                LOGGER.debug("Binding [{}] added with keys: {}", (Object)binding.getDescription(), newKeys);
            }
            do {
                KeyBindingInput input;
                DisplayResult result = this.display(interactive.getInput(), display, size, refreshDelay[0]);
                maxLines[0] = result.getLines();
                this.checkInterrupted();
                long delta = ((System.currentTimeMillis() - t0) / refreshDelay[0] + 1L) * refreshDelay[0] + t0 - System.currentTimeMillis();
                int ch = bindingReader.peekCharacter(delta);
                op = null;
                if (ch == -1 || ch == 27) {
                    op = EXIT;
                } else if (ch != -2) {
                    op = (String)bindingReader.readBinding(keys, null, false);
                } else if (result.isStop()) {
                    op = EXIT;
                }
                if (op == null || (input = (KeyBindingInput)inputs.get(op)) == null) continue;
                input.action();
            } while (op == null || !op.equals(EXIT));
        }
        catch (InterruptedException i) {
            terminal.setAttributes(attr);
            if (prevHandler != null) {
                terminal.handle(Terminal.Signal.WINCH, prevHandler);
            }
            terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
            if (interactive.isFullScreen()) {
                terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
                terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
                terminal.writer().flush();
            } else {
                for (int i2 = 0; i2 < maxLines[0]; ++i2) {
                    terminal.writer().println();
                }
            }
        }
        finally {
            terminal.setAttributes(attr);
            if (prevHandler != null) {
                terminal.handle(Terminal.Signal.WINCH, prevHandler);
            }
            terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
            if (interactive.isFullScreen()) {
                terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
                terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
                terminal.writer().flush();
            } else {
                for (int i = 0; i < maxLines[0]; ++i) {
                    terminal.writer().println();
                }
            }
        }
    }

    private DisplayResult display(InteractiveInput input, Display display, Size size, long currentDelay) {
        List<AttributedString> lines;
        display.resize(size.getRows(), size.getColumns());
        DisplayResult result = new DisplayResult();
        if (input instanceof StoppableInteractiveInput) {
            InteractiveInputIO io = ((StoppableInteractiveInput)input).getIO(size, currentDelay);
            result.setStop(io.isStop());
            lines = io.getLines();
        } else {
            lines = input.getLines(size, currentDelay);
        }
        display.update(lines, 0);
        result.setLines(lines.size());
        return result;
    }

    private void checkInterrupted() throws InterruptedException {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private Terminal terminal() {
        if (this.isLocalPrompt()) {
            return this.defaultTerminal;
        }
        return SshShellCommandFactory.SSH_THREAD_CONTEXT.get().getTerminal();
    }

    private LineReader reader() {
        if (this.isLocalPrompt()) {
            return this.defaultLineReader;
        }
        return SshShellCommandFactory.SSH_THREAD_CONTEXT.get().getLineReader();
    }

    public void setDefaultTerminal(Terminal defaultTerminal) {
        this.defaultTerminal = defaultTerminal;
    }

    public void setDefaultLineReader(LineReader defaultLineReader) {
        this.defaultLineReader = defaultLineReader;
    }

    public static class DisplayResult {
        private int lines;
        private boolean stop;

        @Generated
        public DisplayResult() {
        }

        @Generated
        public int getLines() {
            return this.lines;
        }

        @Generated
        public boolean isStop() {
            return this.stop;
        }

        @Generated
        public void setLines(int lines) {
            this.lines = lines;
        }

        @Generated
        public void setStop(boolean stop) {
            this.stop = stop;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisplayResult)) {
                return false;
            }
            DisplayResult other = (DisplayResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLines() != other.getLines()) {
                return false;
            }
            return this.isStop() == other.isStop();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DisplayResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLines();
            result = result * 59 + (this.isStop() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "SshShellHelper.DisplayResult(lines=" + this.getLines() + ", stop=" + this.isStop() + ")";
        }
    }
}

