/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.PromptColor;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.commands.CommandProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="ssh.shell")
@Validated
public class SshShellProperties {
    public static final String SSH_SHELL_PREFIX = "ssh.shell";
    public static final String SSH_SHELL_ENABLE = "ssh.shell.enable";
    public static final String DISABLE_SSH_SHELL = "ssh.shell.enable=false";
    public static final String SPRING_SHELL_AUTO_CONFIG_CLASSES = "org.springframework.shell.boot.ExitCodeAutoConfiguration,org.springframework.shell.boot.ShellContextAutoConfiguration,org.springframework.shell.boot.SpringShellAutoConfiguration,org.springframework.shell.boot.ShellRunnerAutoConfiguration,org.springframework.shell.boot.ApplicationRunnerAutoConfiguration,org.springframework.shell.boot.CommandCatalogAutoConfiguration,org.springframework.shell.boot.LineReaderAutoConfiguration,org.springframework.shell.boot.CompleterAutoConfiguration,org.springframework.shell.boot.UserConfigAutoConfiguration,org.springframework.shell.boot.JLineAutoConfiguration,org.springframework.shell.boot.JLineShellAutoConfiguration,org.springframework.shell.boot.ParameterResolverAutoConfiguration,org.springframework.shell.boot.StandardAPIAutoConfiguration,org.springframework.shell.boot.ThemingAutoConfiguration,org.springframework.shell.boot.StandardCommandsAutoConfiguration,org.springframework.shell.boot.ComponentFlowAutoConfiguration";
    public static final String DISABLE_SPRING_SHELL_AUTO_CONFIG = "spring.autoconfigure.exclude=org.springframework.shell.boot.ExitCodeAutoConfiguration,org.springframework.shell.boot.ShellContextAutoConfiguration,org.springframework.shell.boot.SpringShellAutoConfiguration,org.springframework.shell.boot.ShellRunnerAutoConfiguration,org.springframework.shell.boot.ApplicationRunnerAutoConfiguration,org.springframework.shell.boot.CommandCatalogAutoConfiguration,org.springframework.shell.boot.LineReaderAutoConfiguration,org.springframework.shell.boot.CompleterAutoConfiguration,org.springframework.shell.boot.UserConfigAutoConfiguration,org.springframework.shell.boot.JLineAutoConfiguration,org.springframework.shell.boot.JLineShellAutoConfiguration,org.springframework.shell.boot.ParameterResolverAutoConfiguration,org.springframework.shell.boot.StandardAPIAutoConfiguration,org.springframework.shell.boot.ThemingAutoConfiguration,org.springframework.shell.boot.StandardCommandsAutoConfiguration,org.springframework.shell.boot.ComponentFlowAutoConfiguration";
    public static final String ACTUATOR_ROLE = "ACTUATOR";
    public static final String ADMIN_ROLE = "ADMIN";
    private boolean enable = true;
    private String host = "127.0.0.1";
    private int port = 2222;
    private String user = "user";
    private String password;
    private boolean displayBanner = true;
    private AuthenticationType authentication = AuthenticationType.simple;
    private String authProviderBeanName;
    private File hostKeyFile = new File(System.getProperty("java.io.tmpdir"), "hostKey.ser");
    private Resource authorizedPublicKeys;
    private File historyFile = new File(System.getProperty("java.io.tmpdir"), "sshShellHistory.log");
    private boolean sharedHistory = true;
    private File historyDirectory = new File(System.getProperty("java.io.tmpdir"));
    private List<String> confirmationWords = new ArrayList<String>(SshShellHelper.DEFAULT_CONFIRM_WORDS);
    private Prompt prompt = new Prompt();
    private Commands commands = new Commands();

    public void setAuthorizedPublicKeysFile(File file) {
        this.authorizedPublicKeys = new FileSystemResource(file);
    }

    @Generated
    public SshShellProperties() {
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public boolean isDisplayBanner() {
        return this.displayBanner;
    }

    @Generated
    public AuthenticationType getAuthentication() {
        return this.authentication;
    }

    @Generated
    public String getAuthProviderBeanName() {
        return this.authProviderBeanName;
    }

    @Generated
    public File getHostKeyFile() {
        return this.hostKeyFile;
    }

    @Generated
    public Resource getAuthorizedPublicKeys() {
        return this.authorizedPublicKeys;
    }

    @Generated
    public File getHistoryFile() {
        return this.historyFile;
    }

    @Generated
    public boolean isSharedHistory() {
        return this.sharedHistory;
    }

    @Generated
    public File getHistoryDirectory() {
        return this.historyDirectory;
    }

    @Generated
    public List<String> getConfirmationWords() {
        return this.confirmationWords;
    }

    @Generated
    public Prompt getPrompt() {
        return this.prompt;
    }

    @Generated
    public Commands getCommands() {
        return this.commands;
    }

    @Generated
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setDisplayBanner(boolean displayBanner) {
        this.displayBanner = displayBanner;
    }

    @Generated
    public void setAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
    }

    @Generated
    public void setAuthProviderBeanName(String authProviderBeanName) {
        this.authProviderBeanName = authProviderBeanName;
    }

    @Generated
    public void setHostKeyFile(File hostKeyFile) {
        this.hostKeyFile = hostKeyFile;
    }

    @Generated
    public void setAuthorizedPublicKeys(Resource authorizedPublicKeys) {
        this.authorizedPublicKeys = authorizedPublicKeys;
    }

    @Generated
    public void setHistoryFile(File historyFile) {
        this.historyFile = historyFile;
    }

    @Generated
    public void setSharedHistory(boolean sharedHistory) {
        this.sharedHistory = sharedHistory;
    }

    @Generated
    public void setHistoryDirectory(File historyDirectory) {
        this.historyDirectory = historyDirectory;
    }

    @Generated
    public void setConfirmationWords(List<String> confirmationWords) {
        this.confirmationWords = confirmationWords;
    }

    @Generated
    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    @Generated
    public void setCommands(Commands commands) {
        this.commands = commands;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SshShellProperties)) {
            return false;
        }
        SshShellProperties other = (SshShellProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isDisplayBanner() != other.isDisplayBanner()) {
            return false;
        }
        if (this.isSharedHistory() != other.isSharedHistory()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        AuthenticationType this$authentication = this.getAuthentication();
        AuthenticationType other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)((Object)this$authentication)).equals((Object)other$authentication)) {
            return false;
        }
        String this$authProviderBeanName = this.getAuthProviderBeanName();
        String other$authProviderBeanName = other.getAuthProviderBeanName();
        if (this$authProviderBeanName == null ? other$authProviderBeanName != null : !this$authProviderBeanName.equals(other$authProviderBeanName)) {
            return false;
        }
        File this$hostKeyFile = this.getHostKeyFile();
        File other$hostKeyFile = other.getHostKeyFile();
        if (this$hostKeyFile == null ? other$hostKeyFile != null : !((Object)this$hostKeyFile).equals(other$hostKeyFile)) {
            return false;
        }
        Resource this$authorizedPublicKeys = this.getAuthorizedPublicKeys();
        Resource other$authorizedPublicKeys = other.getAuthorizedPublicKeys();
        if (this$authorizedPublicKeys == null ? other$authorizedPublicKeys != null : !this$authorizedPublicKeys.equals(other$authorizedPublicKeys)) {
            return false;
        }
        File this$historyFile = this.getHistoryFile();
        File other$historyFile = other.getHistoryFile();
        if (this$historyFile == null ? other$historyFile != null : !((Object)this$historyFile).equals(other$historyFile)) {
            return false;
        }
        File this$historyDirectory = this.getHistoryDirectory();
        File other$historyDirectory = other.getHistoryDirectory();
        if (this$historyDirectory == null ? other$historyDirectory != null : !((Object)this$historyDirectory).equals(other$historyDirectory)) {
            return false;
        }
        List<String> this$confirmationWords = this.getConfirmationWords();
        List<String> other$confirmationWords = other.getConfirmationWords();
        if (this$confirmationWords == null ? other$confirmationWords != null : !((Object)this$confirmationWords).equals(other$confirmationWords)) {
            return false;
        }
        Prompt this$prompt = this.getPrompt();
        Prompt other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt)) {
            return false;
        }
        Commands this$commands = this.getCommands();
        Commands other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SshShellProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isDisplayBanner() ? 79 : 97);
        result = result * 59 + (this.isSharedHistory() ? 79 : 97);
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        AuthenticationType $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)((Object)$authentication)).hashCode());
        String $authProviderBeanName = this.getAuthProviderBeanName();
        result = result * 59 + ($authProviderBeanName == null ? 43 : $authProviderBeanName.hashCode());
        File $hostKeyFile = this.getHostKeyFile();
        result = result * 59 + ($hostKeyFile == null ? 43 : ((Object)$hostKeyFile).hashCode());
        Resource $authorizedPublicKeys = this.getAuthorizedPublicKeys();
        result = result * 59 + ($authorizedPublicKeys == null ? 43 : $authorizedPublicKeys.hashCode());
        File $historyFile = this.getHistoryFile();
        result = result * 59 + ($historyFile == null ? 43 : ((Object)$historyFile).hashCode());
        File $historyDirectory = this.getHistoryDirectory();
        result = result * 59 + ($historyDirectory == null ? 43 : ((Object)$historyDirectory).hashCode());
        List<String> $confirmationWords = this.getConfirmationWords();
        result = result * 59 + ($confirmationWords == null ? 43 : ((Object)$confirmationWords).hashCode());
        Prompt $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
        Commands $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SshShellProperties(enable=" + this.isEnable() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", displayBanner=" + this.isDisplayBanner() + ", authentication=" + (Object)((Object)this.getAuthentication()) + ", authProviderBeanName=" + this.getAuthProviderBeanName() + ", hostKeyFile=" + this.getHostKeyFile() + ", authorizedPublicKeys=" + this.getAuthorizedPublicKeys() + ", historyFile=" + this.getHistoryFile() + ", sharedHistory=" + this.isSharedHistory() + ", historyDirectory=" + this.getHistoryDirectory() + ", confirmationWords=" + this.getConfirmationWords() + ", prompt=" + this.getPrompt() + ", commands=" + this.getCommands() + ")";
    }

    public static class Commands {
        @NestedConfigurationProperty
        private CommandProperties actuator = CommandProperties.withAuthorizedRoles(new ArrayList<String>(Collections.singletonList("ACTUATOR")));
        @NestedConfigurationProperty
        private CommandProperties jmx = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties system = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties tasks = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties script = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties history = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties stacktrace = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties datasource = CommandProperties.withExcludedByDefault(new ArrayList<String>(Collections.singletonList("datasource-update")));
        @NestedConfigurationProperty
        private CommandProperties postprocessors = CommandProperties.notRestrictedByDefault();
        @NestedConfigurationProperty
        private CommandProperties manageSessions = CommandProperties.disabledByDefault();

        @Generated
        public Commands() {
        }

        @Generated
        public CommandProperties getActuator() {
            return this.actuator;
        }

        @Generated
        public CommandProperties getJmx() {
            return this.jmx;
        }

        @Generated
        public CommandProperties getSystem() {
            return this.system;
        }

        @Generated
        public CommandProperties getTasks() {
            return this.tasks;
        }

        @Generated
        public CommandProperties getScript() {
            return this.script;
        }

        @Generated
        public CommandProperties getHistory() {
            return this.history;
        }

        @Generated
        public CommandProperties getStacktrace() {
            return this.stacktrace;
        }

        @Generated
        public CommandProperties getDatasource() {
            return this.datasource;
        }

        @Generated
        public CommandProperties getPostprocessors() {
            return this.postprocessors;
        }

        @Generated
        public CommandProperties getManageSessions() {
            return this.manageSessions;
        }

        @Generated
        public void setActuator(CommandProperties actuator) {
            this.actuator = actuator;
        }

        @Generated
        public void setJmx(CommandProperties jmx) {
            this.jmx = jmx;
        }

        @Generated
        public void setSystem(CommandProperties system) {
            this.system = system;
        }

        @Generated
        public void setTasks(CommandProperties tasks) {
            this.tasks = tasks;
        }

        @Generated
        public void setScript(CommandProperties script) {
            this.script = script;
        }

        @Generated
        public void setHistory(CommandProperties history) {
            this.history = history;
        }

        @Generated
        public void setStacktrace(CommandProperties stacktrace) {
            this.stacktrace = stacktrace;
        }

        @Generated
        public void setDatasource(CommandProperties datasource) {
            this.datasource = datasource;
        }

        @Generated
        public void setPostprocessors(CommandProperties postprocessors) {
            this.postprocessors = postprocessors;
        }

        @Generated
        public void setManageSessions(CommandProperties manageSessions) {
            this.manageSessions = manageSessions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Commands)) {
                return false;
            }
            Commands other = (Commands)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CommandProperties this$actuator = this.getActuator();
            CommandProperties other$actuator = other.getActuator();
            if (this$actuator == null ? other$actuator != null : !((Object)this$actuator).equals(other$actuator)) {
                return false;
            }
            CommandProperties this$jmx = this.getJmx();
            CommandProperties other$jmx = other.getJmx();
            if (this$jmx == null ? other$jmx != null : !((Object)this$jmx).equals(other$jmx)) {
                return false;
            }
            CommandProperties this$system = this.getSystem();
            CommandProperties other$system = other.getSystem();
            if (this$system == null ? other$system != null : !((Object)this$system).equals(other$system)) {
                return false;
            }
            CommandProperties this$tasks = this.getTasks();
            CommandProperties other$tasks = other.getTasks();
            if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
                return false;
            }
            CommandProperties this$script = this.getScript();
            CommandProperties other$script = other.getScript();
            if (this$script == null ? other$script != null : !((Object)this$script).equals(other$script)) {
                return false;
            }
            CommandProperties this$history = this.getHistory();
            CommandProperties other$history = other.getHistory();
            if (this$history == null ? other$history != null : !((Object)this$history).equals(other$history)) {
                return false;
            }
            CommandProperties this$stacktrace = this.getStacktrace();
            CommandProperties other$stacktrace = other.getStacktrace();
            if (this$stacktrace == null ? other$stacktrace != null : !((Object)this$stacktrace).equals(other$stacktrace)) {
                return false;
            }
            CommandProperties this$datasource = this.getDatasource();
            CommandProperties other$datasource = other.getDatasource();
            if (this$datasource == null ? other$datasource != null : !((Object)this$datasource).equals(other$datasource)) {
                return false;
            }
            CommandProperties this$postprocessors = this.getPostprocessors();
            CommandProperties other$postprocessors = other.getPostprocessors();
            if (this$postprocessors == null ? other$postprocessors != null : !((Object)this$postprocessors).equals(other$postprocessors)) {
                return false;
            }
            CommandProperties this$manageSessions = this.getManageSessions();
            CommandProperties other$manageSessions = other.getManageSessions();
            return !(this$manageSessions == null ? other$manageSessions != null : !((Object)this$manageSessions).equals(other$manageSessions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Commands;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CommandProperties $actuator = this.getActuator();
            result = result * 59 + ($actuator == null ? 43 : ((Object)$actuator).hashCode());
            CommandProperties $jmx = this.getJmx();
            result = result * 59 + ($jmx == null ? 43 : ((Object)$jmx).hashCode());
            CommandProperties $system = this.getSystem();
            result = result * 59 + ($system == null ? 43 : ((Object)$system).hashCode());
            CommandProperties $tasks = this.getTasks();
            result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
            CommandProperties $script = this.getScript();
            result = result * 59 + ($script == null ? 43 : ((Object)$script).hashCode());
            CommandProperties $history = this.getHistory();
            result = result * 59 + ($history == null ? 43 : ((Object)$history).hashCode());
            CommandProperties $stacktrace = this.getStacktrace();
            result = result * 59 + ($stacktrace == null ? 43 : ((Object)$stacktrace).hashCode());
            CommandProperties $datasource = this.getDatasource();
            result = result * 59 + ($datasource == null ? 43 : ((Object)$datasource).hashCode());
            CommandProperties $postprocessors = this.getPostprocessors();
            result = result * 59 + ($postprocessors == null ? 43 : ((Object)$postprocessors).hashCode());
            CommandProperties $manageSessions = this.getManageSessions();
            result = result * 59 + ($manageSessions == null ? 43 : ((Object)$manageSessions).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SshShellProperties.Commands(actuator=" + this.getActuator() + ", jmx=" + this.getJmx() + ", system=" + this.getSystem() + ", tasks=" + this.getTasks() + ", script=" + this.getScript() + ", history=" + this.getHistory() + ", stacktrace=" + this.getStacktrace() + ", datasource=" + this.getDatasource() + ", postprocessors=" + this.getPostprocessors() + ", manageSessions=" + this.getManageSessions() + ")";
        }
    }

    public static class Prompt {
        private String text = "shell>";
        private PromptColor color = PromptColor.WHITE;

        @Generated
        public Prompt() {
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public PromptColor getColor() {
            return this.color;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public void setColor(PromptColor color) {
            this.color = color;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prompt)) {
                return false;
            }
            Prompt other = (Prompt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            PromptColor this$color = this.getColor();
            PromptColor other$color = other.getColor();
            return !(this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Prompt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            PromptColor $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SshShellProperties.Prompt(text=" + this.getText() + ", color=" + (Object)((Object)this.getColor()) + ")";
        }
    }

    public static enum AuthenticationType {
        simple,
        security;

    }
}

