/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.SshShellUtils;
import com.github.fonimus.ssh.shell.auth.SshAuthentication;
import com.github.fonimus.ssh.shell.listeners.SshShellListenerService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.channel.ChannelSessionAware;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.shell.Shell;
import org.springframework.shell.context.DefaultShellContext;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.jline.InteractiveShellRunner;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.shell.result.DefaultResultHandler;

public class SshShellRunnable
implements Factory<Command>,
ChannelSessionAware,
Runnable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellRunnable.class);
    private static final String SSH_ENV_COLUMNS = "COLUMNS";
    private static final String SSH_ENV_LINES = "LINES";
    private static final String SSH_ENV_TERM = "TERM";
    private final SshShellProperties properties;
    private final SshShellListenerService shellListenerService;
    private final Banner shellBanner;
    private final Shell shell;
    private final LineReader lineReader;
    private final PromptProvider promptProvider;
    private final Completer completer;
    private final org.springframework.core.env.Environment environment;
    private ChannelSession session;
    private final Environment sshEnv;
    private final SshShellCommandFactory sshShellCommandFactory;
    private final InputStream is;
    private final OutputStream os;
    private final ExitCallback ec;

    @Override
    public void run() {
        LOGGER.debug("{}: running...", (Object)this.session.toString());
        TerminalBuilder terminalBuilder = TerminalBuilder.builder().system(false).streams(this.is, this.os);
        boolean sizeAvailable = false;
        if (this.sshEnv.getEnv().containsKey(SSH_ENV_COLUMNS) && this.sshEnv.getEnv().containsKey(SSH_ENV_LINES)) {
            try {
                terminalBuilder.size(new Size(Integer.parseInt((String)this.sshEnv.getEnv().get(SSH_ENV_COLUMNS)), Integer.parseInt((String)this.sshEnv.getEnv().get(SSH_ENV_LINES))));
                sizeAvailable = true;
            }
            catch (NumberFormatException e) {
                if (!LOGGER.isTraceEnabled()) {
                    LOGGER.debug("Unable to get terminal size : {}:{}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                }
                LOGGER.trace("Unable to get terminal size", (Throwable)e);
            }
        }
        if (this.sshEnv.getEnv().containsKey(SSH_ENV_LINES)) {
            terminalBuilder.type((String)this.sshEnv.getEnv().get(SSH_ENV_TERM));
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name());
             Terminal terminal = terminalBuilder.build();){
            try {
                Attributes attr = terminal.getAttributes();
                SshShellUtils.fill(attr, this.sshEnv.getPtyModes());
                terminal.setAttributes(attr);
                if (sizeAvailable) {
                    this.sshEnv.addSignalListener((channel, signal) -> {
                        terminal.setSize(new Size(Integer.parseInt((String)this.sshEnv.getEnv().get(SSH_ENV_COLUMNS)), Integer.parseInt((String)this.sshEnv.getEnv().get(SSH_ENV_LINES))));
                        terminal.raise(Terminal.Signal.WINCH);
                    }, new Signal[]{Signal.WINCH});
                }
                if (this.properties.isDisplayBanner() && this.shellBanner != null) {
                    this.shellBanner.printBanner(this.environment, this.getClass(), ps);
                }
                DefaultResultHandler resultHandler = new DefaultResultHandler(terminal);
                resultHandler.handleResult((Object)new String(baos.toByteArray(), StandardCharsets.UTF_8));
                resultHandler.handleResult((Object)"Please type `help` to see available commands");
                LineReader reader = LineReaderBuilder.builder().terminal(terminal).appName("Spring Ssh Shell").completer(this.completer).highlighter(this.lineReader.getHighlighter()).parser(this.lineReader.getParser()).build();
                Object authenticationObject = this.session.getSession().getIoSession().getAttribute((Object)"authentication");
                SshAuthentication authentication = null;
                if (authenticationObject != null) {
                    if (!(authenticationObject instanceof SshAuthentication)) {
                        throw new IllegalStateException("Unknown authentication object class: " + authenticationObject.getClass().getName());
                    }
                    authentication = (SshAuthentication)authenticationObject;
                }
                File historyFile = this.properties.getHistoryFile();
                if (!this.properties.isSharedHistory()) {
                    String user = authentication != null ? authentication.getName() : "unknown";
                    historyFile = new File(this.properties.getHistoryDirectory(), "sshShellHistory-" + user + ".log");
                }
                reader.setVariable("history-file", (Object)historyFile.toPath());
                SshShellCommandFactory.SSH_THREAD_CONTEXT.set(new SshContext(this, terminal, reader, authentication));
                this.shellListenerService.onSessionStarted(this.session);
                new InteractiveShellRunner(reader, this.promptProvider, this.shell, (ShellContext)new DefaultShellContext()).run(null);
                this.shellListenerService.onSessionStopped(this.session);
                LOGGER.debug("{}: closing", (Object)this.session);
                this.quit(0);
            }
            catch (Throwable e) {
                this.shellListenerService.onSessionError(this.session);
                LOGGER.error("{}: unexpected exception", (Object)this.session, (Object)e);
                this.quit(1);
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to open terminal", (Throwable)e);
            this.quit(1);
        }
    }

    private void quit(int exitCode) {
        if (this.ec != null) {
            this.ec.onExit(exitCode);
        }
    }

    public void setChannelSession(ChannelSession session) {
        this.session = session;
    }

    public ServerSession getSshSession() {
        return this.session.getSession();
    }

    public Environment getSshEnv() {
        return this.sshEnv;
    }

    public Command create() {
        return this.sshShellCommandFactory;
    }

    @Generated
    public SshShellRunnable(SshShellProperties properties, SshShellListenerService shellListenerService, Banner shellBanner, Shell shell, LineReader lineReader, PromptProvider promptProvider, Completer completer, org.springframework.core.env.Environment environment, ChannelSession session, Environment sshEnv, SshShellCommandFactory sshShellCommandFactory, InputStream is, OutputStream os, ExitCallback ec) {
        this.properties = properties;
        this.shellListenerService = shellListenerService;
        this.shellBanner = shellBanner;
        this.shell = shell;
        this.lineReader = lineReader;
        this.promptProvider = promptProvider;
        this.completer = completer;
        this.environment = environment;
        this.session = session;
        this.sshEnv = sshEnv;
        this.sshShellCommandFactory = sshShellCommandFactory;
        this.is = is;
        this.os = os;
        this.ec = ec;
    }
}

