/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.ColorPalette;
import org.jline.utils.InfoCmp;
import org.jline.utils.NonBlockingReader;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component(value="terminalDelegate")
@Primary
public class SshShellTerminalDelegate
implements Terminal {
    private final Terminal delegate;

    public SshShellTerminalDelegate(Terminal delegate) {
        this.delegate = delegate;
    }

    private Terminal delegate() {
        SshContext current = SshShellCommandFactory.SSH_THREAD_CONTEXT.get();
        if (current != null && current.getTerminal() != null) {
            return current.getTerminal();
        }
        if (this.delegate == null) {
            throw new IllegalStateException("Cannot find terminal");
        }
        return this.delegate;
    }

    public String getName() {
        return this.delegate().getName();
    }

    public Terminal.SignalHandler handle(Terminal.Signal signal, Terminal.SignalHandler signalHandler) {
        return this.delegate().handle(signal, signalHandler);
    }

    public void raise(Terminal.Signal signal) {
        this.delegate().raise(signal);
    }

    public NonBlockingReader reader() {
        return this.delegate().reader();
    }

    public PrintWriter writer() {
        return this.delegate().writer();
    }

    public Charset encoding() {
        return this.delegate().encoding();
    }

    public InputStream input() {
        return this.delegate().input();
    }

    public OutputStream output() {
        return this.delegate().output();
    }

    public boolean canPauseResume() {
        return this.delegate().canPauseResume();
    }

    public void pause() {
        this.delegate().pause();
    }

    public void pause(boolean wait) throws InterruptedException {
        this.delegate().pause(wait);
    }

    public void resume() {
        this.delegate().resume();
    }

    public boolean paused() {
        return this.delegate().paused();
    }

    public Attributes enterRawMode() {
        return this.delegate().enterRawMode();
    }

    public boolean echo() {
        return this.delegate().echo();
    }

    public boolean echo(boolean b) {
        return this.delegate().echo(b);
    }

    public Attributes getAttributes() {
        return this.delegate().getAttributes();
    }

    public void setAttributes(Attributes attributes) {
        this.delegate().setAttributes(attributes);
    }

    public Size getSize() {
        return this.delegate().getSize();
    }

    public void setSize(Size size) {
        this.delegate().setSize(size);
    }

    public void flush() {
        this.delegate().flush();
    }

    public String getType() {
        return this.delegate().getType();
    }

    public boolean puts(InfoCmp.Capability capability, Object ... objects) {
        return this.delegate().puts(capability, objects);
    }

    public boolean getBooleanCapability(InfoCmp.Capability capability) {
        return this.delegate().getBooleanCapability(capability);
    }

    public Integer getNumericCapability(InfoCmp.Capability capability) {
        return this.delegate().getNumericCapability(capability);
    }

    public String getStringCapability(InfoCmp.Capability capability) {
        return this.delegate().getStringCapability(capability);
    }

    public Cursor getCursorPosition(IntConsumer intConsumer) {
        return this.delegate().getCursorPosition(intConsumer);
    }

    public boolean hasMouseSupport() {
        return this.delegate().hasMouseSupport();
    }

    public boolean trackMouse(Terminal.MouseTracking mouseTracking) {
        return this.delegate().trackMouse(mouseTracking);
    }

    public MouseEvent readMouseEvent() {
        return this.delegate().readMouseEvent();
    }

    public MouseEvent readMouseEvent(IntSupplier intSupplier) {
        return this.delegate().readMouseEvent(intSupplier);
    }

    public boolean hasFocusSupport() {
        return this.delegate().hasFocusSupport();
    }

    public boolean trackFocus(boolean tracking) {
        return this.delegate().trackFocus(tracking);
    }

    public ColorPalette getPalette() {
        return this.delegate().getPalette();
    }

    public void close() throws IOException {
        this.delegate().close();
    }
}

