/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.auth;

import com.github.fonimus.ssh.shell.auth.SshAuthentication;
import com.github.fonimus.ssh.shell.auth.SshShellAuthenticationProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;

public class SshShellSecurityAuthenticationProvider
implements SshShellAuthenticationProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellSecurityAuthenticationProvider.class);
    private final ApplicationContext context;
    private final String authProviderBeanName;
    private AuthenticationManager authenticationManager;

    public SshShellSecurityAuthenticationProvider(ApplicationContext context, String authProviderBeanName) {
        this.context = context;
        this.authProviderBeanName = authProviderBeanName;
    }

    @PostConstruct
    public void init() {
        Map map = this.context.getBeansOfType(AuthenticationManager.class);
        if (map.isEmpty()) {
            throw new BeanCreationException("Could not find any beans of class: " + AuthenticationManager.class.getName());
        }
        String beanName = this.authProviderBeanName;
        Set available = map.keySet();
        if (beanName != null && !beanName.isEmpty()) {
            this.authenticationManager = (AuthenticationManager)map.get(beanName);
            if (this.authenticationManager == null) {
                throw new BeanCreationException("Could not find bean with name: " + beanName + " and class: " + AuthenticationManager.class.getName() + ". Available are: " + available);
            }
        } else {
            if (map.size() != 1) {
                throw new BeanCreationException("Found too many beans of class: " + AuthenticationManager.class.getName() + ". Please specify name with property '" + "ssh.shell" + ".authProviderBeanName'");
            }
            Map.Entry e = map.entrySet().iterator().next();
            beanName = (String)e.getKey();
            this.authenticationManager = (AuthenticationManager)e.getValue();
        }
        LOGGER.info("Using authentication manager named: {} [class={}]", (Object)beanName, (Object)this.authenticationManager.getClass().getName());
    }

    public boolean authenticate(String username, String pass, ServerSession serverSession) throws PasswordChangeRequiredException {
        try {
            Authentication auth = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)pass));
            LOGGER.debug("User {} authenticated with authorities: {}", (Object)username, (Object)auth.getAuthorities());
            List<String> authorities = auth.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
            serverSession.getIoSession().setAttribute((Object)"authentication", (Object)new SshAuthentication(username, auth.getPrincipal(), auth.getDetails(), auth.getCredentials(), authorities));
            return auth.isAuthenticated();
        }
        catch (AuthenticationException e) {
            LOGGER.error("Unable to authenticate user [{}] : {}", (Object)username, (Object)e.getMessage());
            LOGGER.debug("Unable to authenticate user [{}]", (Object)username, (Object)e);
            return false;
        }
    }
}

