/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.auth.SshAuthentication;
import com.github.fonimus.ssh.shell.commands.AvailabilityException;
import com.github.fonimus.ssh.shell.commands.CommandProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.AbstractShellComponent;

public class AbstractCommand
extends AbstractShellComponent {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCommand.class);
    protected final SshShellHelper helper;
    protected final SshShellProperties properties;
    protected final CommandProperties commandProperties;

    public AbstractCommand(SshShellHelper helper, SshShellProperties properties, CommandProperties commandProperties) {
        this.helper = helper;
        this.properties = properties;
        this.commandProperties = commandProperties;
    }

    protected Availability availability(String commandGroup, String commandName) {
        try {
            List<String> authorities;
            this.preAvailability();
            if (!this.commandProperties.isEnable()) {
                return Availability.unavailable((String)("command deactivated (please check property 'ssh.shell.commands." + commandGroup + ".enable')"));
            }
            if (this.commandProperties.getExcludes() != null && this.commandProperties.getExcludes().contains(commandName)) {
                return Availability.unavailable((String)("command is excluded (please check property 'ssh.shell.commands." + commandGroup + ".excludes')"));
            }
            if (this.commandProperties.getIncludes() != null && !this.commandProperties.getIncludes().contains(commandName)) {
                return Availability.unavailable((String)("command not included (please check property 'ssh.shell.commands." + commandGroup + ".includes')"));
            }
            if (this.helper.isLocalPrompt()) {
                LOGGER.debug("Not an ssh session -> local prompt -> giving all rights");
                return Availability.available();
            }
            SshAuthentication auth = SshShellCommandFactory.SSH_THREAD_CONTEXT.get().getAuthentication();
            List<String> list = authorities = auth != null ? auth.getAuthorities() : null;
            if (this.commandProperties.isRestricted() && !this.helper.checkAuthorities(this.commandProperties.getAuthorizedRoles(), authorities, this.properties.getAuthentication() == SshShellProperties.AuthenticationType.simple)) {
                return Availability.unavailable((String)"command is forbidden for current user");
            }
            this.postAvailability();
            return Availability.available();
        }
        catch (AvailabilityException e) {
            return Availability.unavailable((String)e.getMessage());
        }
    }

    protected void preAvailability() throws AvailabilityException {
    }

    protected void postAvailability() throws AvailabilityException {
    }
}

