/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import com.github.fonimus.ssh.shell.providers.ExtendedFileValueProvider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;
import org.springframework.shell.standard.commands.History;
import org.springframework.util.CollectionUtils;

@SshShellComponent
@ShellCommandGroup(value="Built-In Commands")
@ConditionalOnProperty(name={"ssh.shell.commands.history.create"}, havingValue="true", matchIfMissing=true)
public class HistoryCommand
extends AbstractCommand
implements History.Command {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryCommand.class);
    public static final String GROUP = "history";
    public static final String COMMAND_HISTORY = "history";

    public HistoryCommand(SshShellProperties properties, SshShellHelper helper) {
        super(helper, properties, properties.getCommands().getHistory());
    }

    @ShellMethod(key={"history"}, value="Display or save the history of previously run commands")
    @ShellMethodAvailability(value={"historyAvailability"})
    public Object history(@ShellOption(help="A file to save history to.", defaultValue="__NULL__", valueProvider=ExtendedFileValueProvider.class) File file, @ShellOption(help="To display standard spring shell way (array.tostring). Default value: false", defaultValue="false") boolean displayArray) throws IOException {
        List result = new History(this.helper.getHistory()).history(file);
        if (file != null && result.size() == 1) {
            return result.get(0);
        }
        if (displayArray) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            result.forEach(h -> sb.append((String)h).append(System.lineSeparator()));
        }
        return sb.toString();
    }

    private Availability historyAvailability() {
        return this.availability("history", "history");
    }
}

