/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SimpleTable;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.SessionsValuesProvider;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import com.github.fonimus.ssh.shell.manage.SshShellSessionManager;
import java.util.Arrays;
import java.util.Map;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.session.ServerSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

@SshShellComponent
@ShellCommandGroup(value="Manage Sessions Commands")
@ConditionalOnProperty(name={"ssh.shell.commands.manage-sessions.create"}, havingValue="true", matchIfMissing=true)
public class ManageSessionsCommand
extends AbstractCommand {
    public static final String GROUP = "manage-sessions";
    private static final String COMMAND_MANAGE_SESSIONS_LIST = "manage-sessions-list";
    private static final String COMMAND_MANAGE_SESSIONS_INFO = "manage-sessions-info";
    private static final String COMMAND_MANAGE_SESSIONS_STOP = "manage-sessions-stop";
    private final SshShellSessionManager sessionManager;

    public ManageSessionsCommand(SshShellHelper helper, SshShellProperties properties, @Lazy SshShellSessionManager sessionManager) {
        super(helper, properties, properties.getCommands().getManageSessions());
        this.sessionManager = sessionManager;
    }

    @ShellMethod(key={"manage-sessions-list"}, value="Displays active sessions")
    @ShellMethodAvailability(value={"manageSessionsListAvailability"})
    public String manageSessionsList() {
        Map<Long, ChannelSession> sessions = this.sessionManager.listSessions();
        SimpleTable.SimpleTableBuilder builder = SimpleTable.builder().column("Session Id").column("Local address").column("Remote address").column("Authenticated User");
        for (ChannelSession value : sessions.values()) {
            builder.line(Arrays.asList(value.getServerSession().getIoSession().getId(), value.getServerSession().getIoSession().getLocalAddress(), value.getServerSession().getIoSession().getRemoteAddress(), SshShellSessionManager.sessionUserName(value)));
        }
        return this.helper.renderTable(builder.build());
    }

    @ShellMethod(key={"manage-sessions-info"}, value="Displays session")
    @ShellMethodAvailability(value={"manageSessionsInfoAvailability"})
    public String manageSessionsInfo(@ShellOption(help="Session identifier", valueProvider=SessionsValuesProvider.class) long sessionId) {
        ChannelSession session = this.sessionManager.getSession(sessionId);
        if (session == null) {
            return this.helper.getError("Session [" + sessionId + "] not found");
        }
        return this.helper.getSuccess(this.sessionTable(session.getServerSession()));
    }

    @ShellMethod(key={"manage-sessions-stop"}, value="Stop session")
    @ShellMethodAvailability(value={"manageSessionsStopAvailability"})
    public String manageSessionsStop(@ShellOption(help="Session identifier", valueProvider=SessionsValuesProvider.class) long sessionId) {
        return this.sessionManager.stopSession(sessionId) ? this.helper.getSuccess("Session [" + sessionId + "] stopped") : this.helper.getWarning("Unable to stop session [" + sessionId + "], maybe it does not exist");
    }

    private String sessionTable(ServerSession session) {
        return this.helper.renderTable(SimpleTable.builder().column("Property").column("Value").line(Arrays.asList("Session id", session.getIoSession().getId())).line(Arrays.asList("Local address", session.getIoSession().getLocalAddress())).line(Arrays.asList("Remote address", session.getIoSession().getRemoteAddress())).line(Arrays.asList("Server version", session.getServerVersion())).line(Arrays.asList("Client version", session.getClientVersion())).build());
    }

    private Availability manageSessionsListAvailability() {
        return this.availability(GROUP, COMMAND_MANAGE_SESSIONS_LIST);
    }

    private Availability manageSessionsInfoAvailability() {
        return this.availability(GROUP, COMMAND_MANAGE_SESSIONS_INFO);
    }

    private Availability manageSessionsStopAvailability() {
        return this.availability(GROUP, COMMAND_MANAGE_SESSIONS_STOP);
    }
}

