/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import com.github.fonimus.ssh.shell.postprocess.ExtendedResultHandlerService;
import org.jline.terminal.Terminal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.commands.Stacktrace;

@SshShellComponent
@ShellCommandGroup(value="Built-In Commands")
@ConditionalOnProperty(name={"ssh.shell.commands.stacktrace.create"}, havingValue="true", matchIfMissing=true)
public class StacktraceCommand
extends AbstractCommand
implements Stacktrace.Command {
    public static final String GROUP = "stacktrace";
    public static final String COMMAND_STACKTRACE = "stacktrace";
    private Terminal terminal;

    public StacktraceCommand(SshShellHelper helper, SshShellProperties properties) {
        super(helper, properties, properties.getCommands().getStacktrace());
    }

    @ShellMethod(key={"stacktrace"}, value="Display the full stacktrace of the last error.")
    @ShellMethodAvailability(value={"stacktraceAvailability"})
    public void stacktrace() {
        Throwable lastError = ExtendedResultHandlerService.THREAD_CONTEXT.get();
        if (lastError != null) {
            lastError.printStackTrace(this.terminal.writer());
        }
    }

    @Autowired
    @Lazy
    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    private Availability stacktraceAvailability() {
        return this.availability("stacktrace", "stacktrace");
    }
}

