/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SimpleTable;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import com.github.fonimus.ssh.shell.commands.TaskNameValuesProvider;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.FixedDelayTask;
import org.springframework.scheduling.config.FixedRateTask;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.scheduling.config.ScheduledTaskHolder;
import org.springframework.scheduling.config.Task;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.scheduling.support.SimpleTriggerContext;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.EnumValueProvider;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

@SshShellComponent
@ShellCommandGroup(value="Tasks Commands")
@ConditionalOnBean(value={ScheduledTaskHolder.class})
@ConditionalOnProperty(name={"ssh.shell.commands.tasks.create"}, havingValue="true", matchIfMissing=true)
public class TasksCommand
extends AbstractCommand
implements DisposableBean {
    public static final String GROUP = "tasks";
    private static final String COMMAND_TASKS_LIST = "tasks-list";
    private static final String COMMAND_TASKS_STOP = "tasks-stop";
    private static final String COMMAND_TASKS_RESTART = "tasks-restart";
    private static final String COMMAND_TASKS_SINGLE = "tasks-single";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private final Collection<ScheduledTaskHolder> scheduledTaskHolders;
    private final Map<String, TaskState> statesByName = new HashMap<String, TaskState>();
    private final ApplicationContext applicationContext;
    private TaskScheduler taskScheduler;

    public TasksCommand(SshShellHelper helper, SshShellProperties properties, Collection<ScheduledTaskHolder> scheduledTaskHolders, ApplicationContext applicationContext) {
        super(helper, properties, properties.getCommands().getTasks());
        this.scheduledTaskHolders = scheduledTaskHolders;
        this.applicationContext = applicationContext;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    private TaskScheduler taskScheduler() {
        if (this.taskScheduler != null) {
            return this.taskScheduler;
        }
        Map taskSchedulers = this.applicationContext.getBeansOfType(TaskScheduler.class);
        if (taskSchedulers.size() == 1) {
            this.taskScheduler = (TaskScheduler)taskSchedulers.values().iterator().next();
        } else if (taskSchedulers.size() > 1) {
            this.taskScheduler = (TaskScheduler)taskSchedulers.get("taskScheduler");
        }
        if (this.taskScheduler == null) {
            this.taskScheduler = new ConcurrentTaskScheduler(Executors.newSingleThreadScheduledExecutor());
        }
        return this.taskScheduler;
    }

    public Set<String> getTaskNames() {
        return this.statesByName.keySet();
    }

    public void destroy() {
        this.refresh(true);
        this.statesByName.values().stream().filter(s -> s.getFuture() != null).forEach(s -> s.getFuture().cancel(true));
    }

    @ShellMethod(key={"tasks-list"}, value="Display the available scheduled tasks")
    @ShellMethodAvailability(value={"tasksListAvailability"})
    public String tasksList(@ShellOption(help="Filter on status (running, stopped)", defaultValue="__NULL__", valueProvider=EnumValueProvider.class) TaskStatus status, @ShellOption(help="Refresh task from context", defaultValue="false") boolean refresh) {
        this.refresh(refresh);
        if (this.statesByName.isEmpty()) {
            return "No task found in context";
        }
        SimpleTable.SimpleTableBuilder builder = SimpleTable.builder().column("Task").column("Running").column("Type").column("Trigger").column("Next execution");
        for (TaskState state : this.statesByName.values()) {
            if (status != null && state.getStatus() != status) continue;
            ArrayList<Object> line = new ArrayList<Object>();
            line.add(state.getName());
            if (state.getScheduledTask() != null) {
                line.add((Object)state.getStatus());
                Task task = state.getScheduledTask().getTask();
                if (task instanceof CronTask) {
                    line.add("cron");
                    CronTask cronTask = (CronTask)task;
                    line.add("expression : " + cronTask.getExpression());
                    Date next = cronTask.getTrigger().nextExecutionTime((TriggerContext)new SimpleTriggerContext());
                    line.add(next == null ? "-" : FORMATTER.format(next.toInstant().atOffset(ZoneOffset.UTC).toLocalDateTime()));
                } else if (task instanceof FixedDelayTask) {
                    line.add("fixed-delay");
                    line.add(TasksCommand.getTrigger((IntervalTask)((FixedDelayTask)task)));
                    line.add("-");
                } else if (task instanceof FixedRateTask) {
                    line.add("fixed-rate");
                    line.add(TasksCommand.getTrigger((IntervalTask)((FixedRateTask)task)));
                    line.add("-");
                } else {
                    line.add("custom");
                    line.add("-");
                    line.add("-");
                }
            } else {
                line.add((Object)(state.getFuture() == null || state.getFuture().isDone() ? TaskStatus.stopped : TaskStatus.running));
                line.add("single");
                line.add("-");
                line.add("never");
            }
            builder.line(line);
        }
        return this.helper.renderTable(builder.build());
    }

    private void refresh(boolean refresh) {
        if (this.statesByName.isEmpty() || refresh) {
            if (refresh) {
                this.statesByName.entrySet().removeIf(e -> ((TaskState)e.getValue()).getScheduledTask() == null && (((TaskState)e.getValue()).getFuture() == null || ((TaskState)e.getValue()).getFuture().isDone()));
            }
            for (ScheduledTaskHolder scheduledTaskHolder : this.scheduledTaskHolders) {
                for (ScheduledTask scheduledTask : scheduledTaskHolder.getScheduledTasks()) {
                    String taskName = TasksCommand.getTaskName(scheduledTask.getTask().getRunnable());
                    this.statesByName.putIfAbsent(taskName, new TaskState(taskName, scheduledTask, TaskStatus.running, null));
                }
            }
        }
    }

    @ShellMethod(key={"tasks-stop"}, value="Stop all or specified task(s)")
    @ShellMethodAvailability(value={"tasksStopAvailability"})
    public String tasksStop(@ShellOption(help="Stop all tasks", defaultValue="false") boolean all, @ShellOption(help="Task name to stop", valueProvider=TaskNameValuesProvider.class, defaultValue="__NULL__") String task) {
        List<String> toStop = this.listTasks(all, task, true);
        if (toStop.isEmpty()) {
            return "No task to stop";
        }
        if (!this.helper.confirm("Do you really want to stop tasks " + toStop + " ?", new String[0])) {
            return "Stop aborted";
        }
        ArrayList<String> stopped = new ArrayList<String>();
        for (String taskName : toStop) {
            TaskState state = this.statesByName.get(taskName);
            if (state == null) continue;
            if (state.getStatus() == TaskStatus.running) {
                if (state.getScheduledTask() != null) {
                    state.getScheduledTask().cancel();
                }
                if (state.getFuture() != null) {
                    state.getFuture().cancel(true);
                    state.setFuture(null);
                }
                state.setStatus(TaskStatus.stopped);
                stopped.add(taskName);
                continue;
            }
            this.helper.printWarning("Task [" + taskName + "] already stopped.");
        }
        if (stopped.isEmpty()) {
            return "No task stopped";
        }
        return this.helper.getSuccess("Tasks " + stopped + " stopped");
    }

    @ShellMethod(key={"tasks-restart"}, value="Restart all or specified task(s)")
    @ShellMethodAvailability(value={"tasksRestartAvailability"})
    public String tasksRestart(@ShellOption(help="Stop all tasks", defaultValue="false") boolean all, @ShellOption(help="Task name to stop", valueProvider=TaskNameValuesProvider.class, defaultValue="__NULL__") String task) {
        List<String> toRestart = this.listTasks(all, task, false);
        if (toRestart.isEmpty()) {
            return "No task to restart";
        }
        if (!this.helper.confirm("Do you really want to restart tasks " + toRestart + " ?", new String[0])) {
            return "Restart aborted";
        }
        ArrayList<String> started = new ArrayList<String>();
        for (String taskName : toRestart) {
            TaskState state = this.statesByName.get(taskName);
            if (state != null && state.getScheduledTask() != null) {
                if (state.getStatus() == TaskStatus.stopped) {
                    Task taskObj = state.getScheduledTask().getTask();
                    ScheduledFuture future = null;
                    if (taskObj instanceof CronTask) {
                        future = this.taskScheduler().schedule(state.getScheduledTask().getTask().getRunnable(), ((CronTask)taskObj).getTrigger());
                    } else if (taskObj instanceof FixedDelayTask) {
                        future = this.taskScheduler().scheduleWithFixedDelay(state.getScheduledTask().getTask().getRunnable(), ((FixedDelayTask)taskObj).getInterval());
                    } else if (taskObj instanceof FixedRateTask) {
                        future = this.taskScheduler().scheduleAtFixedRate(state.getScheduledTask().getTask().getRunnable(), ((FixedRateTask)taskObj).getInterval());
                    } else {
                        this.helper.printWarning("Task [" + taskName + "] of class [" + taskObj.getClass().getName() + "] cannot be restarted.");
                    }
                    if (future == null) continue;
                    state.setFuture(future);
                    state.setStatus(TaskStatus.running);
                    started.add(taskName);
                    continue;
                }
                this.helper.printWarning("Task [" + taskName + "] already running.");
                continue;
            }
            this.helper.printWarning("Cannot relaunch this task execution [" + task + "]. Use the original task instead.");
        }
        if (started.isEmpty()) {
            return "No task restarted";
        }
        return this.helper.getSuccess("Tasks " + started + " restarted");
    }

    @ShellMethod(key={"tasks-single"}, value="Launch one execution of all or specified task(s)")
    @ShellMethodAvailability(value={"tasksSingleAvailability"})
    public String tasksSingle(@ShellOption(help="Launch one execution of all tasks", defaultValue="false") boolean all, @ShellOption(help="Task name to launch once", valueProvider=TaskNameValuesProvider.class, defaultValue="__NULL__") String task) {
        List<String> toLaunch = this.listTasks(all, task, true);
        if (!this.helper.confirm("Do you really want to launch tasks " + toLaunch + " ?", new String[0])) {
            return "Launch aborted";
        }
        ArrayList<String> started = new ArrayList<String>();
        for (String taskName : toLaunch) {
            TaskState state = this.statesByName.get(taskName);
            if (state.getScheduledTask() != null) {
                try {
                    String executionId = taskName + "-" + TasksCommand.generateExecutionId();
                    ScheduledFuture future = this.taskScheduler().schedule(state.getScheduledTask().getTask().getRunnable(), new Date());
                    this.statesByName.put(executionId, new TaskState(executionId, null, TaskStatus.running, future));
                    started.add(executionId);
                }
                catch (TaskRejectedException e) {
                    this.helper.printError("The task '" + taskName + "' was not accepted for internal reasons");
                }
                continue;
            }
            if (task == null) continue;
            this.helper.printWarning("Cannot relaunch this task execution [" + task + "]. Use the original task instead.");
        }
        return started.isEmpty() ? "No task started" : this.helper.getSuccess("Tasks " + started + " started");
    }

    private static String generateExecutionId() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 8);
    }

    private List<String> listTasks(boolean all, String task, boolean running) {
        this.refresh(false);
        ArrayList<String> result = new ArrayList<String>();
        if (all) {
            TaskStatus filter = running ? TaskStatus.running : TaskStatus.stopped;
            result.addAll(this.statesByName.entrySet().stream().filter(e -> ((TaskState)e.getValue()).getStatus() == filter).map(Map.Entry::getKey).collect(Collectors.toList()));
        } else {
            if (task == null || task.isEmpty()) {
                throw new IllegalArgumentException("You need to set either all option or task one");
            }
            if (!this.statesByName.containsKey(task)) {
                throw new IllegalArgumentException("Unknown task : " + task);
            }
            result.add(task);
        }
        return result;
    }

    private static String getTrigger(IntervalTask task) {
        String initialDelay = Duration.ofMillis(task.getInitialDelay()).toString();
        String interval = Duration.ofMillis(task.getInterval()).toString();
        return "interval : " + interval + " (" + task.getInterval() + "), init-delay : " + initialDelay + " (" + task.getInitialDelay() + ")";
    }

    private static String getTaskName(Runnable runnable) {
        if (runnable instanceof ScheduledMethodRunnable) {
            Method method = ((ScheduledMethodRunnable)runnable).getMethod();
            return method.getDeclaringClass().getName() + "." + method.getName();
        }
        return runnable.getClass().getName();
    }

    private Availability tasksListAvailability() {
        return this.availability(GROUP, COMMAND_TASKS_LIST);
    }

    private Availability tasksStopAvailability() {
        return this.availability(GROUP, COMMAND_TASKS_STOP);
    }

    private Availability tasksRestartAvailability() {
        return this.availability(GROUP, COMMAND_TASKS_RESTART);
    }

    private Availability tasksSingleAvailability() {
        return this.availability(GROUP, COMMAND_TASKS_SINGLE);
    }

    public static enum TaskStatus {
        running,
        stopped;

    }

    public static class TaskState {
        private String name;
        private ScheduledTask scheduledTask;
        private TaskStatus status;
        private volatile ScheduledFuture<?> future;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public ScheduledTask getScheduledTask() {
            return this.scheduledTask;
        }

        @Generated
        public TaskStatus getStatus() {
            return this.status;
        }

        @Generated
        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setScheduledTask(ScheduledTask scheduledTask) {
            this.scheduledTask = scheduledTask;
        }

        @Generated
        public void setStatus(TaskStatus status) {
            this.status = status;
        }

        @Generated
        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskState)) {
                return false;
            }
            TaskState other = (TaskState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ScheduledTask this$scheduledTask = this.getScheduledTask();
            ScheduledTask other$scheduledTask = other.getScheduledTask();
            if (this$scheduledTask == null ? other$scheduledTask != null : !this$scheduledTask.equals(other$scheduledTask)) {
                return false;
            }
            TaskStatus this$status = this.getStatus();
            TaskStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            ScheduledFuture<?> this$future = this.getFuture();
            ScheduledFuture<?> other$future = other.getFuture();
            return !(this$future == null ? other$future != null : !this$future.equals(other$future));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaskState;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ScheduledTask $scheduledTask = this.getScheduledTask();
            result = result * 59 + ($scheduledTask == null ? 43 : $scheduledTask.hashCode());
            TaskStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            ScheduledFuture<?> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TasksCommand.TaskState(name=" + this.getName() + ", scheduledTask=" + this.getScheduledTask() + ", status=" + (Object)((Object)this.getStatus()) + ", future=" + this.getFuture() + ")";
        }

        @Generated
        public TaskState() {
        }

        @Generated
        public TaskState(String name, ScheduledTask scheduledTask, TaskStatus status, ScheduledFuture<?> future) {
            this.name = name;
            this.scheduledTask = scheduledTask;
            this.status = status;
            this.future = future;
        }
    }
}

