/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands.system;

import com.github.fonimus.ssh.shell.PromptColor;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.ColorAligner;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import com.github.fonimus.ssh.shell.interactive.Interactive;
import com.github.fonimus.ssh.shell.interactive.KeyBinding;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.EnumValueProvider;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;
import org.springframework.shell.table.Aligner;
import org.springframework.shell.table.ArrayTableModel;
import org.springframework.shell.table.BorderStyle;
import org.springframework.shell.table.SimpleHorizontalAligner;
import org.springframework.shell.table.SimpleVerticalAligner;
import org.springframework.shell.table.SizeConstraints;
import org.springframework.shell.table.Table;
import org.springframework.shell.table.TableBuilder;
import org.springframework.shell.table.TableModel;

@SshShellComponent
@ShellCommandGroup(value="System Commands")
@ConditionalOnProperty(name={"ssh.shell.commands.system.create"}, havingValue="true", matchIfMissing=true)
public class SystemCommand
extends AbstractCommand {
    public static final String GROUP = "system";
    private static final String COMMAND_SYSTEM_ENV = "system-env";
    private static final String COMMAND_SYSTEM_PROPERTIES = "system-properties";
    private static final String COMMAND_SYSTEM_THREADS = "system-threads";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd:MM:yyyy HH:mm:ss");
    public static final String SPLIT_REGEX = "[:;]";

    public SystemCommand(SshShellHelper helper, SshShellProperties properties) {
        super(helper, properties, properties.getCommands().getSystem());
    }

    @ShellMethod(key={"system-env"}, value="List system environment.")
    @ShellMethodAvailability(value={"jvmEnvAvailability"})
    public Object jvmEnv(@ShellOption(help="Simple view", defaultValue="false") boolean simpleView) {
        if (simpleView) {
            return this.buildSimple(System.getenv());
        }
        return this.buildTable(System.getenv()).render(this.helper.terminalSize().getRows());
    }

    @ShellMethod(key={"system-properties"}, value="List system properties.")
    @ShellMethodAvailability(value={"jvmPropertiesAvailability"})
    public Object jvmProperties(@ShellOption(help="Simple view", defaultValue="false") boolean simpleView) {
        Map<String, String> map = System.getProperties().entrySet().stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue() != null ? e.getValue().toString() : ""));
        if (simpleView) {
            return this.buildSimple(map);
        }
        return this.buildTable(map).render(this.helper.terminalSize().getRows());
    }

    private String buildSimple(Map<String, String> mapParam) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(mapParam);
        int maxColumn = this.helper.terminalSize().getRows() - 1;
        StringBuilder sb = new StringBuilder();
        int max = -1;
        for (String string : map.keySet()) {
            if (string.length() <= max || string.length() >= maxColumn) continue;
            max = string.length();
        }
        for (Map.Entry entry : map.entrySet()) {
            sb.append(String.format("%-" + max + "s", entry.getKey())).append(" | ").append((String)entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private Table buildTable(Map<String, String> mapParam) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(mapParam);
        Object[][] data = new String[map.size() + 1][2];
        ArrayTableModel model = new ArrayTableModel(data);
        TableBuilder tableBuilder = new TableBuilder((TableModel)model);
        data[0][0] = "Key";
        data[0][1] = "Value";
        tableBuilder.on(SshShellHelper.at(0, 0)).addAligner((Aligner)SimpleHorizontalAligner.center);
        tableBuilder.on(SshShellHelper.at(0, 1)).addAligner((Aligner)SimpleHorizontalAligner.center);
        int i = 1;
        for (Map.Entry e : map.entrySet()) {
            data[i][0] = (String)e.getKey();
            data[i][1] = (String)e.getValue();
            tableBuilder.on(SshShellHelper.at(i, 0)).addAligner((Aligner)SimpleHorizontalAligner.center);
            tableBuilder.on(SshShellHelper.at(i, 0)).addAligner((Aligner)SimpleVerticalAligner.middle);
            if (((String)e.getKey()).toLowerCase().contains("path") || ((String)e.getKey()).toLowerCase().contains("dirs")) {
                tableBuilder.on(SshShellHelper.at(i, 1)).addSizer((raw, tableWidth, nbColumns) -> SystemCommand.extent(raw));
                tableBuilder.on(SshShellHelper.at(i, 1)).addFormatter(value -> {
                    String[] stringArray;
                    if (value == null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "";
                    } else {
                        stringArray = value.toString().split(SPLIT_REGEX);
                    }
                    return stringArray;
                });
            }
            ++i;
        }
        return tableBuilder.addFullBorder(BorderStyle.fancy_double).build();
    }

    private static SizeConstraints.Extent extent(String[] raw) {
        int max = 0;
        int min = 0;
        for (String line : raw) {
            String[] words;
            for (String word : words = line.split(SPLIT_REGEX)) {
                min = Math.max(min, word.length());
            }
            max = Math.max(max, line.length());
        }
        return new SizeConstraints.Extent(min, max);
    }

    @ShellMethod(key={"system-threads"}, value="List jvm threads.")
    @ShellMethodAvailability(value={"threadsAvailability"})
    public String threads(@ShellOption(help="'list' or 'dump' threads. Default is: list", defaultValue="list", valueProvider=EnumValueProvider.class) ThreadAction action, @ShellOption(help="Order by column. Default is: id", defaultValue="id", valueProvider=EnumValueProvider.class) ThreadColumn orderBy, @ShellOption(help="Reverse order by column. Default is: false", defaultValue="false") boolean reverseOrder, @ShellOption(help="Not interactive. Default is: false", defaultValue="false") boolean staticDisplay, @ShellOption(help="Only for DUMP action", defaultValue="__NULL__") Long threadId) {
        if (action == ThreadAction.dump) {
            Thread th = this.get(threadId);
            this.helper.print("Name  : " + th.getName());
            this.helper.print("State : " + this.helper.getColored(th.getState().name(), this.color(th.getState())) + "\n");
            Exception e = new Exception("Thread [" + th.getId() + "] stack trace");
            e.setStackTrace(th.getStackTrace());
            e.printStackTrace(this.helper.terminalWriter());
            return "";
        }
        if (staticDisplay) {
            return this.table(orderBy, reverseOrder, false);
        }
        boolean[] finalReverseOrder = new boolean[]{reverseOrder};
        ThreadColumn[] finalOrderBy = new ThreadColumn[]{orderBy};
        Interactive.InteractiveBuilder builder = Interactive.builder();
        for (ThreadColumn value : ThreadColumn.values()) {
            String key = value == ThreadColumn.interrupted ? "t" : value.name().toLowerCase().substring(0, 1);
            builder.binding(KeyBinding.builder().description("ORDER_" + value.name()).key(key).input(() -> {
                if (value == finalOrderBy[0]) {
                    finalReverseOrder[0] = !finalReverseOrder[0];
                } else {
                    finalOrderBy[0] = value;
                }
            }).build());
        }
        builder.binding(KeyBinding.builder().key("r").description("REVERSE").input(() -> {
            finalReverseOrder[0] = !finalReverseOrder[0];
        }).build());
        this.helper.interactive(builder.input((size, currentDelay) -> {
            ArrayList<AttributedString> lines = new ArrayList<AttributedString>(size.getRows());
            lines.add(new AttributedStringBuilder().append((CharSequence)"Time: ").append((CharSequence)FORMATTER.format(LocalDateTime.now()), AttributedStyle.BOLD).append((CharSequence)", refresh delay: ").append((CharSequence)String.valueOf(currentDelay), AttributedStyle.BOLD).append((CharSequence)" ms\n").toAttributedString());
            for (String s : this.table(finalOrderBy[0], finalReverseOrder[0], true).split("\n")) {
                lines.add(AttributedString.fromAnsi((String)s));
            }
            lines.add(AttributedString.fromAnsi((String)"Press 'r' to reverse order, first column letter to change order by"));
            String msg = "Please press key 'q' to quit, '+' and '-' to increase or decrease refresh delay".length() <= this.helper.terminalSize().getColumns() ? "Please press key 'q' to quit, '+' and '-' to increase or decrease refresh delay" : "'q': quit, '+'|'-': increase|decrease refresh";
            lines.add(AttributedString.fromAnsi((String)msg));
            return lines;
        }).build());
        return "";
    }

    private Thread get(Long threadId) {
        if (threadId == null) {
            throw new IllegalArgumentException("Thread id is mandatory");
        }
        Thread t = SystemCommand.getThreads().get(threadId);
        if (t == null) {
            throw new IllegalArgumentException("Could not find thread for id: " + threadId);
        }
        return t;
    }

    private Comparator<? super Thread> comparator(ThreadColumn orderBy, boolean reverseOrder) {
        Comparator<Thread> c;
        switch (orderBy) {
            case priority: {
                c = Comparator.comparingDouble(Thread::getPriority);
                break;
            }
            case state: {
                c = Comparator.comparing(e -> e.getState().name());
                break;
            }
            case interrupted: {
                c = Comparator.comparing(Thread::isAlive);
                break;
            }
            case daemon: {
                c = Comparator.comparing(Thread::isDaemon);
                break;
            }
            case name: {
                c = Comparator.comparing(Thread::getName);
                break;
            }
            default: {
                c = Comparator.comparingDouble(Thread::getId);
            }
        }
        if (reverseOrder) {
            c = c.reversed();
        }
        return c;
    }

    private PromptColor color(Thread.State state) {
        switch (state) {
            case RUNNABLE: {
                return PromptColor.GREEN;
            }
            case BLOCKED: 
            case TERMINATED: {
                return PromptColor.RED;
            }
            case WAITING: 
            case TIMED_WAITING: {
                return PromptColor.CYAN;
            }
        }
        return PromptColor.WHITE;
    }

    private String table(ThreadColumn orderBy, boolean reverseOrder, boolean fullscreen) {
        List<Thread> ordered = new ArrayList<Thread>(SystemCommand.getThreads().values());
        ordered.sort(this.comparator(orderBy, reverseOrder));
        int maxWithHeadersAndBorders = this.helper.terminalSize().getRows() - 8;
        int tableSize = ordered.size() + 1;
        boolean addDotLine = false;
        if (fullscreen && ordered.size() > maxWithHeadersAndBorders) {
            ordered = ordered.subList(0, maxWithHeadersAndBorders);
            tableSize = maxWithHeadersAndBorders + 2;
            addDotLine = true;
        }
        Object[][] data = new String[tableSize][ThreadColumn.values().length];
        TableBuilder tableBuilder = new TableBuilder((TableModel)new ArrayTableModel(data));
        int i = 0;
        for (ThreadColumn column : ThreadColumn.values()) {
            data[0][i] = column.name();
            tableBuilder.on(SshShellHelper.at(0, i)).addAligner((Aligner)SimpleHorizontalAligner.center);
            ++i;
        }
        int r = 1;
        for (Thread t : ordered) {
            data[r][0] = String.valueOf(t.getId());
            data[r][1] = String.valueOf(t.getPriority());
            data[r][2] = t.getState().name();
            tableBuilder.on(SshShellHelper.at(r, 2)).addAligner((Aligner)new ColorAligner(this.color(t.getState())));
            data[r][3] = String.valueOf(t.isInterrupted());
            data[r][4] = String.valueOf(t.isDaemon());
            data[r][5] = t.getName();
            ++r;
        }
        if (addDotLine) {
            String dots = "...";
            data[r][0] = dots;
            data[r][1] = dots;
            data[r][2] = dots;
            data[r][3] = dots;
            data[r][4] = dots;
            data[r][5] = "... not enough rows to display all threads";
        }
        return tableBuilder.addHeaderAndVerticalsBorders(BorderStyle.fancy_double).build().render(this.helper.terminalSize().getRows());
    }

    private static Map<Long, Thread> getThreads() {
        ThreadGroup root = SystemCommand.getRoot();
        Thread[] threads = new Thread[root.activeCount()];
        while (root.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        HashMap<Long, Thread> map = new HashMap<Long, Thread>();
        for (Thread thread : threads) {
            if (thread == null) continue;
            map.put(thread.getId(), thread);
        }
        return map;
    }

    private static ThreadGroup getRoot() {
        ThreadGroup parent;
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while ((parent = group.getParent()) != null) {
            group = parent;
        }
        return group;
    }

    private Availability threadsAvailability() {
        return this.availability(GROUP, COMMAND_SYSTEM_THREADS);
    }

    private Availability jvmEnvAvailability() {
        return this.availability(GROUP, COMMAND_SYSTEM_ENV);
    }

    private Availability jvmPropertiesAvailability() {
        return this.availability(GROUP, COMMAND_SYSTEM_PROPERTIES);
    }

    static enum ThreadAction {
        list,
        dump;

    }

    static enum ThreadColumn {
        id,
        priority,
        state,
        interrupted,
        daemon,
        name;

    }
}

