/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.interactive;

import com.github.fonimus.ssh.shell.interactive.InteractiveInput;
import com.github.fonimus.ssh.shell.interactive.KeyBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.jline.terminal.Size;

public class Interactive {
    @NonNull
    private InteractiveInput input;
    private long refreshDelay;
    private boolean fullScreen;
    private boolean exit;
    private boolean increase;
    private boolean decrease;
    private List<KeyBinding> bindings;
    private Size size;

    @Generated
    private static long $default$refreshDelay() {
        return 3000L;
    }

    @Generated
    private static boolean $default$fullScreen() {
        return true;
    }

    @Generated
    private static boolean $default$exit() {
        return true;
    }

    @Generated
    private static boolean $default$increase() {
        return true;
    }

    @Generated
    private static boolean $default$decrease() {
        return true;
    }

    @Generated
    Interactive(@NonNull InteractiveInput input, long refreshDelay, boolean fullScreen, boolean exit, boolean increase, boolean decrease, List<KeyBinding> bindings, Size size) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.input = input;
        this.refreshDelay = refreshDelay;
        this.fullScreen = fullScreen;
        this.exit = exit;
        this.increase = increase;
        this.decrease = decrease;
        this.bindings = bindings;
        this.size = size;
    }

    @Generated
    public static InteractiveBuilder builder() {
        return new InteractiveBuilder();
    }

    @NonNull
    @Generated
    public InteractiveInput getInput() {
        return this.input;
    }

    @Generated
    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    @Generated
    public boolean isFullScreen() {
        return this.fullScreen;
    }

    @Generated
    public boolean isExit() {
        return this.exit;
    }

    @Generated
    public boolean isIncrease() {
        return this.increase;
    }

    @Generated
    public boolean isDecrease() {
        return this.decrease;
    }

    @Generated
    public List<KeyBinding> getBindings() {
        return this.bindings;
    }

    @Generated
    public Size getSize() {
        return this.size;
    }

    @Generated
    public static class InteractiveBuilder {
        @Generated
        private InteractiveInput input;
        @Generated
        private boolean refreshDelay$set;
        @Generated
        private long refreshDelay$value;
        @Generated
        private boolean fullScreen$set;
        @Generated
        private boolean fullScreen$value;
        @Generated
        private boolean exit$set;
        @Generated
        private boolean exit$value;
        @Generated
        private boolean increase$set;
        @Generated
        private boolean increase$value;
        @Generated
        private boolean decrease$set;
        @Generated
        private boolean decrease$value;
        @Generated
        private ArrayList<KeyBinding> bindings;
        @Generated
        private Size size;

        @Generated
        InteractiveBuilder() {
        }

        @Generated
        public InteractiveBuilder input(@NonNull InteractiveInput input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        @Generated
        public InteractiveBuilder refreshDelay(long refreshDelay) {
            this.refreshDelay$value = refreshDelay;
            this.refreshDelay$set = true;
            return this;
        }

        @Generated
        public InteractiveBuilder fullScreen(boolean fullScreen) {
            this.fullScreen$value = fullScreen;
            this.fullScreen$set = true;
            return this;
        }

        @Generated
        public InteractiveBuilder exit(boolean exit) {
            this.exit$value = exit;
            this.exit$set = true;
            return this;
        }

        @Generated
        public InteractiveBuilder increase(boolean increase) {
            this.increase$value = increase;
            this.increase$set = true;
            return this;
        }

        @Generated
        public InteractiveBuilder decrease(boolean decrease) {
            this.decrease$value = decrease;
            this.decrease$set = true;
            return this;
        }

        @Generated
        public InteractiveBuilder binding(KeyBinding binding) {
            if (this.bindings == null) {
                this.bindings = new ArrayList();
            }
            this.bindings.add(binding);
            return this;
        }

        @Generated
        public InteractiveBuilder bindings(Collection<? extends KeyBinding> bindings) {
            if (bindings == null) {
                throw new NullPointerException("bindings cannot be null");
            }
            if (this.bindings == null) {
                this.bindings = new ArrayList();
            }
            this.bindings.addAll(bindings);
            return this;
        }

        @Generated
        public InteractiveBuilder clearBindings() {
            if (this.bindings != null) {
                this.bindings.clear();
            }
            return this;
        }

        @Generated
        public InteractiveBuilder size(Size size) {
            this.size = size;
            return this;
        }

        @Generated
        public Interactive build() {
            List<KeyBinding> bindings;
            switch (this.bindings == null ? 0 : this.bindings.size()) {
                case 0: {
                    bindings = Collections.emptyList();
                    break;
                }
                case 1: {
                    bindings = Collections.singletonList(this.bindings.get(0));
                    break;
                }
                default: {
                    bindings = Collections.unmodifiableList(new ArrayList<KeyBinding>(this.bindings));
                }
            }
            long refreshDelay$value = this.refreshDelay$value;
            if (!this.refreshDelay$set) {
                refreshDelay$value = Interactive.$default$refreshDelay();
            }
            boolean fullScreen$value = this.fullScreen$value;
            if (!this.fullScreen$set) {
                fullScreen$value = Interactive.$default$fullScreen();
            }
            boolean exit$value = this.exit$value;
            if (!this.exit$set) {
                exit$value = Interactive.$default$exit();
            }
            boolean increase$value = this.increase$value;
            if (!this.increase$set) {
                increase$value = Interactive.$default$increase();
            }
            boolean decrease$value = this.decrease$value;
            if (!this.decrease$set) {
                decrease$value = Interactive.$default$decrease();
            }
            return new Interactive(this.input, refreshDelay$value, fullScreen$value, exit$value, increase$value, decrease$value, bindings, this.size);
        }

        @Generated
        public String toString() {
            return "Interactive.InteractiveBuilder(input=" + this.input + ", refreshDelay$value=" + this.refreshDelay$value + ", fullScreen$value=" + this.fullScreen$value + ", exit$value=" + this.exit$value + ", increase$value=" + this.increase$value + ", decrease$value=" + this.decrease$value + ", bindings=" + this.bindings + ", size=" + this.size + ")";
        }
    }
}

