/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.manage;

import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import com.github.fonimus.ssh.shell.auth.SshAuthentication;
import java.util.Map;
import org.apache.sshd.server.channel.ChannelSession;
import org.springframework.stereotype.Component;

@Component
public class SshShellSessionManager {
    private SshShellCommandFactory commandFactory;

    public SshShellSessionManager(SshShellCommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public Map<Long, ChannelSession> listSessions() {
        return this.commandFactory.listSessions();
    }

    public ChannelSession getSession(long id) {
        return this.listSessions().get(id);
    }

    public boolean stopSession(long id) {
        ChannelSession session = this.getSession(id);
        if (session != null) {
            this.commandFactory.destroy(session);
            return true;
        }
        return false;
    }

    public static String sessionUserName(ChannelSession session) {
        SshAuthentication authentication = (SshAuthentication)session.getServerSession().getIoSession().getAttribute((Object)"authentication");
        if (authentication == null) {
            return null;
        }
        return authentication.getName();
    }
}

