/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.postprocess;

import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import com.github.fonimus.ssh.shell.postprocess.PostProcessor;
import com.github.fonimus.ssh.shell.postprocess.PostProcessorObject;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.shell.ResultHandlerService;
import org.springframework.stereotype.Component;

@Component
@Primary
public class ExtendedResultHandlerService
implements ResultHandlerService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedResultHandlerService.class);
    public static final ThreadLocal<Throwable> THREAD_CONTEXT = ThreadLocal.withInitial(() -> null);
    private final ResultHandlerService delegate;
    private final Map<String, PostProcessor<?, ?>> postProcessorMap = new HashMap();

    public ExtendedResultHandlerService(ResultHandlerService resultHandlerService, List<PostProcessor<?, ?>> postProcessorList) {
        this.delegate = resultHandlerService;
        if (postProcessorList != null) {
            for (PostProcessor<?, ?> postProcessor : postProcessorList) {
                if (this.postProcessorMap.containsKey(postProcessor.getName())) {
                    LOGGER.warn("Unable to register post processor for name [{}], it has already been registered", (Object)postProcessor.getName());
                    continue;
                }
                this.postProcessorMap.put(postProcessor.getName(), postProcessor);
                LOGGER.debug("Post processor with name [{}] registered", (Object)postProcessor.getName());
            }
        }
    }

    public void handle(Object result) {
        this.handle(result, TypeDescriptor.forObject((Object)result));
    }

    public void handle(Object result, TypeDescriptor resultType) {
        if (result == null) {
            return;
        }
        if (result instanceof Throwable) {
            THREAD_CONTEXT.set((Throwable)result);
        }
        Object obj = result;
        SshContext ctx = SshShellCommandFactory.SSH_THREAD_CONTEXT.get();
        if (ctx != null && ctx.getPostProcessorsList() != null) {
            for (PostProcessorObject postProcessorObject : ctx.getPostProcessorsList()) {
                String name = postProcessorObject.getName();
                PostProcessor<?, ?> postProcessor = this.postProcessorMap.get(name);
                if (postProcessor == null) {
                    this.printLogWarn("Unknown post processor [" + name + "]");
                    continue;
                }
                Class cls = (Class)((ParameterizedType)postProcessor.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
                if (!cls.isAssignableFrom(obj.getClass())) {
                    this.printLogWarn("Post processor [" + name + "] can only apply to class [" + cls.getName() + "] (current object class is " + obj.getClass().getName() + ")");
                    continue;
                }
                LOGGER.debug("Applying post processor [{}] with parameters {}", (Object)name, postProcessorObject.getParameters());
                try {
                    obj = postProcessor.process(obj, postProcessorObject.getParameters());
                }
                catch (Exception e) {
                    this.printError(e.getMessage());
                    return;
                }
            }
        }
        if (ctx == null || !ctx.isBackground()) {
            this.delegate.handle(obj);
        }
        if (ctx != null && ctx.isBackground()) {
            ctx.incrementBackgroundCount();
        }
    }

    private void printLogWarn(String warn) {
        this.delegate.handle((Object)new AttributedString((CharSequence)warn, AttributedStyle.DEFAULT.foreground(3)).toAnsi());
        LOGGER.warn(warn);
    }

    private void printError(String error) {
        this.delegate.handle((Object)new AttributedString((CharSequence)error, AttributedStyle.DEFAULT.foreground(1)).toAnsi());
    }
}

