/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.postprocess.provided;

import com.github.fonimus.ssh.shell.postprocess.PostProcessor;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrepPostProcessor
implements PostProcessor<String, String> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GrepPostProcessor.class);

    @Override
    public String getName() {
        return "grep";
    }

    @Override
    public String getDescription() {
        return "Find pattern in result lines";
    }

    @Override
    public String process(String result, List<String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            LOGGER.debug("Cannot use [{}] post processor without any parameters", (Object)this.getName());
            return result;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : result.split("\n")) {
            if (!this.contains(line, parameters)) continue;
            sb.append(line).append("\n");
        }
        return sb.toString().isEmpty() ? sb.toString() : sb.substring(0, sb.toString().length() - 1);
    }

    private boolean contains(String line, List<String> parameters) {
        for (String parameter : parameters) {
            if (parameter != null && !parameter.isEmpty() && !line.contains(parameter)) continue;
            return true;
        }
        return false;
    }
}

