/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.postprocess.provided;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fonimus.ssh.shell.postprocess.PostProcessor;
import com.github.fonimus.ssh.shell.postprocess.PostProcessorException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrettyJsonPostProcessor
implements PostProcessor<Object, String> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrettyJsonPostProcessor.class);
    private final ObjectMapper mapper;

    @Override
    public String getName() {
        return "pretty";
    }

    @Override
    public String getDescription() {
        return "Pretty print thanks to json format";
    }

    @Override
    public String process(Object result, List<String> parameters) throws PostProcessorException {
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Unable to prettify object: {}", result);
            throw new PostProcessorException("Unable to prettify object. " + e.getMessage(), e);
        }
    }

    @Generated
    public PrettyJsonPostProcessor(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

