/*
 * Decompiled with CFR 0.152.
 */
package foodev.jsondiff;

import foodev.jsondiff.ArrNode;
import foodev.jsondiff.Leaf;
import foodev.jsondiff.Node;
import foodev.jsondiff.ObjNode;
import foodev.jsondiff.Oper;
import foodev.jsondiff.Root;
import foodev.jsondiff.Visitor;
import foodev.jsondiff.incava.IncavaDiff;
import foodev.jsondiff.incava.IncavaEntry;
import foodev.jsondiff.jsonwrap.JzonArray;
import foodev.jsondiff.jsonwrap.JzonElement;
import foodev.jsondiff.jsonwrap.JzonObject;
import foodev.jsondiff.jsonwrap.Wrapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;

public class JsonDiff {
    static final String MOD = "~";
    static final Logger LOG = Logger.getLogger(JsonDiff.class.getName());
    protected final Wrapper factory;
    static final Comparator<Map.Entry<String, JzonElement>> INSTRUCTIONS_COMPARATOR = new Comparator<Map.Entry<String, JzonElement>>(){

        @Override
        public int compare(Map.Entry<String, JzonElement> o1, Map.Entry<String, JzonElement> o2) {
            if (o1.getKey().startsWith(JsonDiff.MOD) && !o2.getKey().startsWith(JsonDiff.MOD)) {
                return 1;
            }
            if (!o1.getKey().startsWith(JsonDiff.MOD) && o2.getKey().startsWith(JsonDiff.MOD)) {
                return -1;
            }
            return o1.getKey().compareTo(o2.getKey());
        }
    };
    static final Comparator<Map.Entry<String, JzonElement>> OBJECT_KEY_COMPARATOR = new Comparator<Map.Entry<String, JzonElement>>(){

        @Override
        public int compare(Map.Entry<String, JzonElement> o1, Map.Entry<String, JzonElement> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };
    private Visitor visitor;

    JsonDiff(Wrapper factory) {
        this.factory = factory;
    }

    boolean accept(Leaf leaf, JzonArray instructions, JzonObject childPatch) {
        JzonObject object = (JzonObject)this.factory.parse(leaf.val.toString());
        JzonObject patch = this.factory.createJsonObject();
        patch.add(MOD, instructions);
        if (!childPatch.entrySet().isEmpty()) {
            patch.entrySet().addAll(childPatch.entrySet());
        }
        this.apply(object, patch);
        return this.visitor.shouldCreatePatch(leaf.val.unwrap(), object.unwrap());
    }

    void apply(JzonElement origEl, JzonElement patchEl) throws IllegalArgumentException {
        JzonObject patch = (JzonObject)patchEl;
        TreeSet<Map.Entry<String, JzonElement>> memb = new TreeSet<Map.Entry<String, JzonElement>>(INSTRUCTIONS_COMPARATOR);
        memb.addAll(patch.entrySet());
        for (Map.Entry entry : memb) {
            JzonElement childEl;
            String key = (String)entry.getKey();
            JzonElement value = (JzonElement)entry.getValue();
            if (key.startsWith(MOD)) {
                JzonElement applyTo;
                JzonElement partialInstructions = (JzonElement)entry.getValue();
                if (!partialInstructions.isJsonArray()) {
                    throw new IllegalArgumentException();
                }
                JzonArray array = (JzonArray)partialInstructions;
                if (key.equals(MOD)) {
                    applyTo = origEl;
                } else if (origEl.isJsonArray()) {
                    int index = Integer.parseInt(key.substring(1));
                    applyTo = ((JzonArray)origEl).get(index);
                } else {
                    applyTo = ((JzonObject)origEl).get(key.substring(1));
                }
                for (int i = 0; i < array.size(); ++i) {
                    JzonElement partial = array.get(i);
                    if (!partial.isJsonObject()) {
                        throw new IllegalArgumentException();
                    }
                    Map.Entry<String, JzonElement> childentry = ((JzonObject)partial).entrySet().iterator().next();
                    String childKey = childentry.getKey();
                    Instruction instruction = this.create(childKey);
                    boolean newAppliance = false;
                    if (instruction.isIndexed() && !applyTo.isJsonArray()) {
                        applyTo = this.factory.createJsonArray();
                        newAppliance = true;
                    } else if (!instruction.isIndexed() && !applyTo.isJsonObject()) {
                        applyTo = this.factory.createJsonObject();
                        newAppliance = true;
                    }
                    if (newAppliance) {
                        if (origEl.isJsonArray()) {
                            int index = Integer.parseInt(key);
                            ((JzonArray)origEl).insert(index, applyTo);
                        } else {
                            ((JzonObject)origEl).add(key.substring(1), applyTo);
                        }
                    }
                    this.applyPartial(applyTo, instruction, childentry.getValue());
                }
                continue;
            }
            Instruction instruction = this.create(key);
            if (instruction.oper == Oper.INSERT || instruction.oper == Oper.DELETE) {
                this.applyPartial(origEl, instruction, value);
                continue;
            }
            if (instruction.isIndexed()) {
                if (!origEl.isJsonArray()) {
                    throw new IllegalArgumentException();
                }
                if (value.isJsonPrimitive()) {
                    ((JzonArray)origEl).set(instruction.index, value);
                    continue;
                }
                if (((JzonArray)origEl).size() <= instruction.index) {
                    throw new IllegalArgumentException("Wrong index " + instruction.index + " for " + origEl);
                }
                childEl = ((JzonArray)origEl).get(instruction.index);
                this.apply(childEl, value);
                continue;
            }
            if (origEl.isJsonObject()) {
                if (value.isJsonPrimitive() || value.isJsonNull()) {
                    ((JzonObject)origEl).add(key, value);
                    continue;
                }
                childEl = ((JzonObject)origEl).get(key);
                this.apply(childEl, value);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    public void apply(Object orig, Object patch) {
        JzonElement origEl = this.factory.wrap(orig);
        JzonElement patchEl = this.factory.wrap(patch);
        this.apply(origEl, patchEl);
    }

    public String apply(String orig, String patch) throws IllegalArgumentException {
        JzonElement origEl = this.factory.parse(orig);
        JzonElement patchEl = this.factory.parse(patch);
        this.apply(origEl, patchEl);
        return origEl.toString();
    }

    void applyPartial(JzonElement applyTo, Instruction instruction, JzonElement value) {
        if (instruction.oper == Oper.DELETE) {
            if (instruction.isIndexed()) {
                if (((JzonArray)applyTo).size() <= instruction.index) {
                    throw new IllegalArgumentException("Wrong index " + instruction.index + " for " + applyTo);
                }
                ((JzonArray)applyTo).remove(instruction.index);
            } else {
                ((JzonObject)applyTo).remove(instruction.key);
            }
        } else if (instruction.oper == Oper.INSERT) {
            if (instruction.isIndexed()) {
                if (((JzonArray)applyTo).size() < instruction.index) {
                    throw new IllegalArgumentException("Wrong index " + instruction.index + " for " + applyTo);
                }
                ((JzonArray)applyTo).insert(instruction.index, value);
            } else {
                ((JzonObject)applyTo).add(instruction.key, value);
            }
        } else if (applyTo.isJsonArray()) {
            if (((JzonArray)applyTo).size() <= instruction.index) {
                throw new IllegalArgumentException("Wrong index " + instruction.index + " for " + applyTo);
            }
            ((JzonArray)applyTo).set(instruction.index, value);
        } else {
            ((JzonObject)applyTo).add(instruction.key, value);
        }
    }

    void checkIndex(JzonElement applyTo, int index) {
        if (((JzonArray)applyTo).size() < index) {
            throw new IllegalArgumentException();
        }
    }

    Instruction create(String childKey) {
        Instruction instruction = new Instruction();
        if (childKey.startsWith("-")) {
            instruction.key = childKey.substring(1);
            instruction.index = this.isIndexed(instruction.key);
            instruction.oper = Oper.DELETE;
        } else if (childKey.startsWith("+")) {
            instruction.key = childKey.substring(1);
            instruction.index = this.isIndexed(instruction.key);
            instruction.oper = Oper.INSERT;
        } else {
            instruction.key = childKey;
            instruction.index = this.isIndexed(instruction.key);
            instruction.oper = Oper.SET;
        }
        return instruction;
    }

    JzonObject diff(JzonElement fromEl, JzonElement toEl) {
        if (!fromEl.isJsonObject()) {
            throw new IllegalArgumentException("From is not a json object");
        }
        if (!toEl.isJsonObject()) {
            throw new IllegalArgumentException("To is not a json object");
        }
        JzonObject from = (JzonObject)fromEl;
        JzonObject to = (JzonObject)toEl;
        Root fromRoot = new Root();
        Root toRoot = new Root();
        ArrayList<Leaf> fromLeaves = new ArrayList<Leaf>();
        ArrayList<Leaf> toLeaves = new ArrayList<Leaf>();
        HashMap<Integer, ArrNode> fromArrs = new HashMap<Integer, ArrNode>();
        HashMap<Integer, ArrNode> toArrs = new HashMap<Integer, ArrNode>();
        this.findLeaves(fromRoot, from, fromLeaves, fromArrs);
        this.findLeaves(toRoot, to, toLeaves, toArrs);
        IncavaDiff<Leaf> idiff = new IncavaDiff<Leaf>(fromLeaves, toLeaves);
        List<IncavaEntry> diff = idiff.diff();
        int delta = 0;
        for (IncavaEntry incavaEntry : diff) {
            Leaf toLeaf;
            int i;
            int deletes = Math.max(0, incavaEntry.getDeletedEnd() - incavaEntry.getDeletedStart() + 1);
            int insertionIndex = incavaEntry.getDeletedStart() > 0 ? incavaEntry.getDeletedStart() + delta - 1 : 0;
            Leaf fromLeaf = fromLeaves.size() > insertionIndex ? fromLeaves.get(insertionIndex) : fromLeaves.get(fromLeaves.size() - 1);
            for (i = incavaEntry.getDeletedStart(); i < incavaEntry.getDeletedEnd() + 1; ++i) {
                fromLeaf.recover(fromLeaves);
                toLeaf = fromLeaves.get(i + delta);
                fromLeaf.delete(toLeaf, null);
                fromLeaf = toLeaf;
            }
            if (incavaEntry.getAddedEnd() < 0) continue;
            Leaf leaf = fromLeaf = fromLeaves.size() > insertionIndex ? fromLeaves.get(insertionIndex) : fromLeaves.get(fromLeaves.size() - 1);
            while (fromLeaf.oper == Oper.DELETE && insertionIndex > 0) {
                fromLeaf = fromLeaves.get(--insertionIndex);
            }
            for (i = incavaEntry.getAddedStart(); i < incavaEntry.getAddedEnd() + 1; ++i) {
                fromLeaf.recover(fromLeaves);
                toLeaf = toLeaves.get(i);
                if (deletes > 0) {
                    --deletes;
                    Leaf deleted = fromLeaves.get(incavaEntry.getDeletedStart() + delta + (i - incavaEntry.getAddedStart()));
                    deleted.recover(fromLeaves);
                    if (!fromLeaf.cancelDelete(deleted, toLeaf)) {
                        fromLeaf.insert(toLeaf, null);
                        fromLeaves.add(insertionIndex + 1, toLeaf);
                        fromLeaf = toLeaf;
                        ++delta;
                    } else {
                        fromLeaf = deleted;
                    }
                } else {
                    fromLeaf.insert(toLeaf, null);
                    fromLeaves.add(insertionIndex + 1, toLeaf);
                    fromLeaf = toLeaf;
                    ++delta;
                }
                ++insertionIndex;
            }
        }
        int i = 0;
        for (Leaf fromLeaf : fromLeaves) {
            if (fromLeaf.isOrphan()) {
                fromLeaf.recover(i, fromLeaves);
            }
            ++i;
        }
        JzonObject jzonObject = fromLeaves.iterator().next().patch();
        return jzonObject;
    }

    public Object diff(Object from, Object to) throws IllegalArgumentException {
        JzonElement fromEl = this.factory.wrap(from);
        JzonElement toEl = this.factory.wrap(to);
        JzonObject diff = this.diff(fromEl, toEl);
        return diff.unwrap();
    }

    public String diff(String from, String to) throws IllegalArgumentException {
        JzonElement fromEl = this.factory.parse(from);
        JzonElement toEl = this.factory.parse(to);
        return this.diff(fromEl, toEl).toString();
    }

    Leaf findLeaves(Node parent, JzonElement el, List<Leaf> leaves, HashMap<Integer, ArrNode> arrs) {
        Leaf leaf = new Leaf(parent, el);
        leaf.factory = this.factory;
        if (this.visitor != null) {
            leaf.visitor = this;
        }
        leaves.add(leaf);
        if (el.isJsonObject()) {
            TreeSet<Map.Entry<String, JzonElement>> memb = new TreeSet<Map.Entry<String, JzonElement>>(OBJECT_KEY_COMPARATOR);
            memb.addAll(((JzonObject)el).entrySet());
            for (Map.Entry entry : memb) {
                ObjNode newParent = new ObjNode(parent, (String)entry.getKey());
                Leaf child = this.findLeaves(newParent, (JzonElement)entry.getValue(), leaves, arrs);
                leaf.children.add(child);
            }
        } else if (el.isJsonArray()) {
            JzonArray arr = (JzonArray)el;
            int n = arr.size();
            for (int i = 0; i < n; ++i) {
                ArrNode newParent = new ArrNode(parent, i);
                arrs.put(newParent.doHash(true), newParent);
                Leaf child = this.findLeaves(newParent, arr.get(i), leaves, arrs);
                leaf.children.add(child);
            }
        }
        leaf.init();
        return leaf;
    }

    public Visitor<?> getVisitor() {
        return this.visitor;
    }

    int isIndexed(String childKey) {
        try {
            return Integer.parseInt(childKey);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setVisitor(Visitor<?> visitor) {
        this.visitor = visitor;
    }

    static class Instruction {
        Oper oper;
        int index;
        String key;

        Instruction() {
        }

        boolean isIndexed() {
            return this.index > -1;
        }
    }
}

