/*
 * Decompiled with CFR 0.152.
 */
package foodev.jsondiff;

import foodev.jsondiff.ArrNode;
import foodev.jsondiff.JsonDiff;
import foodev.jsondiff.Node;
import foodev.jsondiff.ObjNode;
import foodev.jsondiff.Oper;
import foodev.jsondiff.jsonwrap.JzonArray;
import foodev.jsondiff.jsonwrap.JzonElement;
import foodev.jsondiff.jsonwrap.JzonObject;
import foodev.jsondiff.jsonwrap.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

class Leaf
implements Comparable<Leaf> {
    Wrapper factory;
    final Node parent;
    JzonElement val;
    Oper oper;
    List<Leaf> children = new LinkedList<Leaf>();
    List<Leaf> newStructure = new LinkedList<Leaf>();
    JsonDiff visitor;

    Leaf(Node parent, JzonElement val) {
        this.parent = parent;
        this.val = val;
        this.parent.leaf = this;
    }

    boolean attach(Leaf leaf, Leaf at) {
        int atIndex;
        Leaf attach = this;
        int myIndex = this.parent.parent == null ? 0 : Leaf.exactIndex(this.parent.parent.leaf.newStructure, this);
        int n = atIndex = at == this ? 0 : Leaf.exactIndex(this.newStructure, at) + 1;
        while (leaf.oper != Oper.DELETE && attach.oper == Oper.DELETE && myIndex > 0) {
            attach = this.parent.parent.leaf.newStructure.get(--myIndex);
            atIndex = attach.newStructure.size();
        }
        if (leaf.parent.parentHashCode == attach.parent.hashCode) {
            if (leaf.oper != Oper.DELETE && attach.oper == Oper.DELETE) {
                return attach.parent.parent.leaf.attach(leaf, this);
            }
            if (leaf.oper == null && (leaf.val.isJsonPrimitive() || leaf.val.isJsonNull())) {
                leaf.oper = Oper.SET;
            }
            attach.newStructure.add(atIndex, leaf);
            leaf.rehash(attach);
            if (JsonDiff.LOG.isLoggable(Level.FINE)) {
                JsonDiff.LOG.info("ATT " + leaf + " @" + this);
            }
            return true;
        }
        if (this.parent.parent == null) {
            return false;
        }
        return this.parent.parent.leaf.attach(leaf, this);
    }

    boolean cancelDelete(Leaf deleted, Leaf with) {
        if (deleted.parent.hashCode == with.parent.hashCode) {
            if (JsonDiff.LOG.isLoggable(Level.FINE)) {
                JsonDiff.LOG.info("SET " + deleted + " @" + with);
            }
            with.newStructure.clear();
            deleted.oper = Oper.SET;
            deleted.val = with.val;
            Leaf newParent = deleted.parent.parent.leaf;
            for (Leaf orphan : deleted.children) {
                orphan.parent.parent = deleted.parent;
                deleted.newStructure.add(orphan);
            }
            deleted.rehash(newParent);
            return true;
        }
        return false;
    }

    void rehash(Leaf newParent) {
        this.parent.rehash(newParent.parent);
        for (Leaf child : this.newStructure) {
            child.rehash(this);
        }
    }

    Leaf checkCancelation(Leaf possibleCancellation) {
        for (Leaf check : this.newStructure) {
            if (check == possibleCancellation) continue;
            if (!check.parent.getClass().equals(possibleCancellation.parent.getClass())) {
                return check;
            }
            if (!(possibleCancellation.parent instanceof ObjNode) || check.parent.hashCode != possibleCancellation.parent.hashCode) continue;
            return check;
        }
        return null;
    }

    void checkCancellations() {
        Iterator<Leaf> it = this.newStructure.iterator();
        while (it.hasNext()) {
            Leaf cancelled;
            Leaf child = it.next();
            if (child.oper != Oper.DELETE || (cancelled = this.checkCancelation(child)) == null) continue;
            if (cancelled.newStructure.isEmpty()) {
                cancelled.oper = Oper.SET;
            }
            it.remove();
        }
    }

    @Override
    public int compareTo(Leaf o) {
        return this.hashCode() - o.hashCode();
    }

    JzonArray createPatch(JzonObject patch) {
        JzonArray instructions = this.factory.createJsonArray();
        if (this.oper != Oper.DELETE) {
            this.checkCancellations();
            int i = 0;
            int deletes = 0;
            for (Leaf child : this.newStructure) {
                String key;
                String reIndexedKey = key = child.parent.toString();
                if (child.parent instanceof ArrNode) {
                    ((ArrNode)child.parent).index = i - deletes;
                    reIndexedKey = child.parent.toString();
                }
                JzonObject insert = this.factory.createJsonObject();
                boolean deeper = true;
                if (child.oper == Oper.INSERT) {
                    insert.add("+" + reIndexedKey, child.val);
                    instructions.insert(instructions.size(), insert);
                    deeper = false;
                } else if (child.oper == Oper.SET) {
                    insert.add(reIndexedKey, child.val);
                    instructions.insert(instructions.size(), insert);
                    deeper = false;
                } else if (child.oper == Oper.DELETE) {
                    insert.addProperty("-" + reIndexedKey, 0);
                    instructions.insert(instructions.size(), insert);
                    deeper = false;
                }
                if (deeper) {
                    JzonObject childPatch = this.factory.createJsonObject();
                    JzonArray childInstructions = child.createPatch(childPatch);
                    if (childInstructions.size() > 0) {
                        if (this.visitor != null && !child.val.isJsonPrimitive() && !this.visitor.accept(child, childInstructions, childPatch)) continue;
                        patch.add("~" + key, childInstructions);
                    }
                    if (!childPatch.entrySet().isEmpty()) {
                        patch.add(key, childPatch);
                    }
                }
                if (child.oper == Oper.DELETE) {
                    ++deletes;
                }
                ++i;
            }
        } else {
            this.newStructure.clear();
        }
        return instructions;
    }

    void delete(Leaf leaf, Leaf at) {
        if (JsonDiff.LOG.isLoggable(Level.FINE)) {
            JsonDiff.LOG.info("DELETE " + leaf + " @" + this);
        }
        leaf.oper = Oper.DELETE;
        for (Leaf orphan : leaf.newStructure) {
            orphan.parent.orphan();
        }
        leaf.newStructure.clear();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == ((Leaf)obj).hashCode();
    }

    public int hashCode() {
        int i = this.parent.hashCode;
        i = this.val.isJsonArray() ? i * 31 + ArrNode.class.hashCode() : (this.val.isJsonObject() ? i * 31 + ObjNode.class.hashCode() : i * 31 + (this.val.isJsonPrimitive() || this.val.isJsonNull() ? this.val.hashCode() : 0));
        return i;
    }

    void init() {
        this.parent.hashCode = this.parent.doHash(false);
        this.parent.parentHashCode = this.parent.parent == null ? 0 : this.parent.parent.doHash(false);
        this.newStructure.addAll(this.children);
    }

    void insert(Leaf leaf, Leaf where) {
        int hashCode = this.parent.hashCode;
        int insCode = leaf.parent.parent.hashCode;
        if (hashCode == 0 || insCode == hashCode) {
            leaf.oper = Oper.INSERT;
            leaf.parent.parent = this.parent;
            leaf.newStructure.clear();
            if (where != null) {
                int insertAt = Leaf.exactIndex(this.newStructure, where) + 1;
                this.newStructure.add(insertAt, leaf);
            } else {
                this.newStructure.add(0, leaf);
            }
            if (JsonDiff.LOG.isLoggable(Level.FINE)) {
                JsonDiff.LOG.info("INSERTed " + leaf + " @" + this);
            }
        } else {
            this.orphans(where);
            this.parent.parent.leaf.insert(leaf, this);
        }
    }

    boolean isOrphan() {
        return this.parent.hashCode != 0 && this.parent.isOrphan();
    }

    void orphans(Leaf where) {
        List<Leaf> orphans = null;
        int insertDeletionsIndex = 0;
        if (where == null && !this.newStructure.isEmpty() || this.newStructure.size() == 1) {
            orphans = this.newStructure;
        } else if (this.newStructure.size() > 1) {
            insertDeletionsIndex = Leaf.exactIndex(this.newStructure, where) + 1;
            orphans = this.newStructure.subList(insertDeletionsIndex, this.newStructure.size());
        }
        if (orphans != null) {
            ArrayList<Leaf> newOrphans = new ArrayList<Leaf>();
            for (Leaf orphan : orphans) {
                if (orphan.oper != Oper.DELETE) {
                    orphan.parent.parent = null;
                    Node clone = orphan.parent.clone();
                    Leaf leafClone = new Leaf(clone, orphan.val);
                    leafClone.visitor = this.visitor;
                    clone.leaf = leafClone;
                    leafClone.oper = Oper.DELETE;
                    newOrphans.add(leafClone);
                    continue;
                }
                newOrphans.add(orphan);
            }
            orphans.clear();
            this.newStructure.addAll(insertDeletionsIndex, newOrphans);
        }
    }

    JzonObject patch() {
        this.checkCancellations();
        JzonObject patch = this.factory.createJsonObject();
        if (this.oper == Oper.INSERT) {
            patch.add("+" + this.parent.toString(), this.val);
        } else if (this.oper == Oper.SET) {
            patch.add(this.parent.toString(), this.val);
        } else if (this.oper == Oper.DELETE) {
            patch.add("-" + this.parent.toString(), this.val);
        } else {
            JzonArray childInstructions = this.createPatch(patch);
            if (childInstructions.size() > 0) {
                patch.add("~", childInstructions);
            }
        }
        return patch;
    }

    void print() {
        this.print(0);
    }

    void print(int tab) {
        for (Leaf lEntry : this.newStructure) {
            for (int i = 0; i < tab; ++i) {
                System.out.print("\t");
            }
            System.out.println(lEntry);
            lEntry.print(tab + 1);
        }
    }

    protected static int exactIndex(Collection<Leaf> c, Leaf check) {
        int i = -1;
        for (Leaf l : c) {
            ++i;
            if (l != check) continue;
            return i;
        }
        return i;
    }

    void recover(List<Leaf> fromLeaves) {
        if (this.isOrphan()) {
            int thisIndex = Leaf.exactIndex(fromLeaves, this);
            this.recover(thisIndex, fromLeaves);
        }
        if (this.parent.parent != null) {
            this.parent.parent.leaf.recover(fromLeaves);
        }
    }

    void recover(int thisIndex, List<Leaf> fromLeaves) {
        if (this.isOrphan()) {
            Leaf newParent = null;
            while (newParent == null || this.oper != Oper.DELETE && newParent.oper == Oper.DELETE) {
                if (!(newParent = fromLeaves.get(--thisIndex)).isOrphan()) continue;
                newParent.recover(thisIndex, fromLeaves);
            }
            while (newParent.parent.parent != null && newParent.parent.hashCode != this.parent.parentHashCode) {
                newParent = newParent.parent.parent.leaf;
                if (!newParent.isOrphan()) continue;
                newParent.recover(fromLeaves);
            }
            if (newParent.oper == Oper.DELETE) {
                return;
            }
            if (newParent.attach(this, null)) {
                if (JsonDiff.LOG.isLoggable(Level.FINE)) {
                    JsonDiff.LOG.info("RECOVERed " + this + " @" + newParent);
                }
            } else {
                this.recover(thisIndex, fromLeaves);
            }
        }
    }

    public String toString() {
        StringBuilder bld = new StringBuilder(this.newStructure.size() + "->");
        bld.append("LEAF");
        if (this.parent != null && this.parent instanceof ArrNode) {
            bld.append(this.parent.toString());
        }
        bld.append("<");
        if (this.oper != null) {
            bld.append((Object)this.oper);
            bld.append("_");
        }
        if (this.val.isJsonPrimitive() || this.val.isJsonNull()) {
            bld.append("{");
            bld.append(this.val);
            bld.append("}");
        } else {
            bld.append(this.parent.toString());
            bld.append(":");
            bld.append(this.val);
        }
        bld.append("_");
        bld.append(this.hashCode());
        if (this.parent.isOrphan()) {
            bld.append("_ORPHAN");
        }
        bld.append(">");
        bld.append("\n");
        return bld.toString();
    }
}

