/*
 * Decompiled with CFR 0.152.
 */
package foodev.jsondiff.incava;

import foodev.jsondiff.incava.IncavaEntry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;

public class IncavaDiff<Type> {
    protected List<Type> a;
    protected List<Type> b;
    protected List<IncavaEntry> diffs = new ArrayList<IncavaEntry>();
    private IncavaEntry pending;
    private Comparator<Type> comparator;
    private TreeMap<Integer, Integer> thresh;

    public IncavaDiff(Type[] a, Type[] b, Comparator<Type> comp) {
        this(Arrays.asList(a), Arrays.asList(b), comp);
    }

    public IncavaDiff(Type[] a, Type[] b) {
        this(a, b, null);
    }

    public IncavaDiff(List<Type> a, List<Type> b, Comparator<Type> comp) {
        this.a = a;
        this.b = b;
        this.comparator = comp;
        this.thresh = null;
    }

    public IncavaDiff(List<Type> a, List<Type> b) {
        this(a, b, null);
    }

    public List<IncavaEntry> diff() {
        this.traverseSequences();
        if (this.pending != null) {
            this.diffs.add(this.pending);
        }
        return this.diffs;
    }

    protected void traverseSequences() {
        int ai;
        Integer[] matches = this.getLongestCommonSubsequences();
        int lastA = this.a.size() - 1;
        int lastB = this.b.size() - 1;
        int bi = 0;
        int lastMatch = matches.length - 1;
        for (ai = 0; ai <= lastMatch; ++ai) {
            Integer bLine = matches[ai];
            if (bLine == null) {
                this.onANotB(ai, bi);
                continue;
            }
            while (bi < bLine) {
                this.onBNotA(ai, bi++);
            }
            this.onMatch(ai, bi++);
        }
        boolean calledFinishA = false;
        boolean calledFinishB = false;
        while (ai <= lastA || bi <= lastB) {
            if (ai == lastA + 1 && bi <= lastB) {
                if (!calledFinishA && this.callFinishedA()) {
                    this.finishedA(lastA);
                    calledFinishA = true;
                } else {
                    while (bi <= lastB) {
                        this.onBNotA(ai, bi++);
                    }
                }
            }
            if (bi == lastB + 1 && ai <= lastA) {
                if (!calledFinishB && this.callFinishedB()) {
                    this.finishedB(lastB);
                    calledFinishB = true;
                } else {
                    while (ai <= lastA) {
                        this.onANotB(ai++, bi);
                    }
                }
            }
            if (ai <= lastA) {
                this.onANotB(ai++, bi);
            }
            if (bi > lastB) continue;
            this.onBNotA(ai, bi++);
        }
    }

    protected boolean callFinishedA() {
        return false;
    }

    protected boolean callFinishedB() {
        return false;
    }

    protected void finishedA(int lastA) {
    }

    protected void finishedB(int lastB) {
    }

    protected void onANotB(int ai, int bi) {
        if (this.pending == null) {
            this.pending = new IncavaEntry(ai, ai, bi, -1);
        } else {
            this.pending.setDeleted(ai);
        }
    }

    protected void onBNotA(int ai, int bi) {
        if (this.pending == null) {
            this.pending = new IncavaEntry(ai, -1, bi, bi);
        } else {
            this.pending.setAdded(bi);
        }
    }

    protected void onMatch(int ai, int bi) {
        if (this.pending != null) {
            this.diffs.add(this.pending);
            this.pending = null;
        }
    }

    protected boolean equals(Type x, Type y) {
        return this.comparator == null ? x.equals(y) : this.comparator.compare(x, y) == 0;
    }

    public Integer[] getLongestCommonSubsequences() {
        List positions;
        int aStart = 0;
        int aEnd = this.a.size() - 1;
        int bStart = 0;
        int bEnd = this.b.size() - 1;
        TreeMap<Integer, Integer> matches = new TreeMap<Integer, Integer>();
        while (aStart <= aEnd && bStart <= bEnd && this.equals(this.a.get(aStart), this.b.get(bStart))) {
            matches.put(aStart++, bStart++);
        }
        while (aStart <= aEnd && bStart <= bEnd && this.equals(this.a.get(aEnd), this.b.get(bEnd))) {
            matches.put(aEnd--, bEnd--);
        }
        AbstractMap bMatches = null;
        bMatches = this.comparator == null ? (this.a.size() > 0 && this.a.get(0) instanceof Comparable ? new TreeMap() : new HashMap()) : new TreeMap(this.comparator);
        for (int bi = bStart; bi <= bEnd; ++bi) {
            Type element = this.b.get(bi);
            Type key = element;
            positions = (ArrayList<Integer>)bMatches.get(key);
            if (positions == null) {
                positions = new ArrayList<Integer>();
                bMatches.put(key, positions);
            }
            positions.add(bi);
        }
        this.thresh = new TreeMap();
        HashMap<Integer, Object[]> links = new HashMap<Integer, Object[]>();
        for (int i = aStart; i <= aEnd; ++i) {
            Type aElement = this.a.get(i);
            positions = (List)bMatches.get(aElement);
            if (positions == null) continue;
            Integer k = 0;
            ListIterator pit = positions.listIterator(positions.size());
            while (pit.hasPrevious()) {
                Integer j = (Integer)pit.previous();
                k = this.insert(j, k);
                if (k == null) continue;
                Object[] value = k > 0 ? (Object[])links.get(k - 1) : null;
                links.put(k, new Object[]{value, i, j});
            }
        }
        if (this.thresh.size() > 0) {
            Integer ti = this.thresh.lastKey();
            Object[] link = (Object[])links.get(ti);
            while (link != null) {
                Integer x = (Integer)link[1];
                Integer y = (Integer)link[2];
                matches.put(x, y);
                link = (Object[])link[0];
            }
        }
        int size = matches.size() == 0 ? 0 : 1 + (Integer)matches.lastKey();
        Integer[] ary = new Integer[size];
        for (Integer idx : matches.keySet()) {
            Integer val;
            ary[idx.intValue()] = val = (Integer)matches.get(idx);
        }
        return ary;
    }

    protected static boolean isNonzero(Integer i) {
        return i != null && i != 0;
    }

    protected boolean isGreaterThan(Integer index, Integer val) {
        Integer lhs = this.thresh.get(index);
        return lhs != null && val != null && lhs.compareTo(val) > 0;
    }

    protected boolean isLessThan(Integer index, Integer val) {
        Integer lhs = this.thresh.get(index);
        return lhs != null && (val == null || lhs.compareTo(val) < 0);
    }

    protected Integer getLastValue() {
        return this.thresh.get(this.thresh.lastKey());
    }

    protected void append(Integer value) {
        Integer addIdx = null;
        if (this.thresh.size() == 0) {
            addIdx = 0;
        } else {
            Integer lastKey = this.thresh.lastKey();
            addIdx = lastKey + 1;
        }
        this.thresh.put(addIdx, value);
    }

    protected Integer insert(Integer j, Integer k) {
        if (IncavaDiff.isNonzero(k) && this.isGreaterThan(k, j) && this.isLessThan(k - 1, j)) {
            this.thresh.put(k, j);
        } else {
            int high = -1;
            if (IncavaDiff.isNonzero(k)) {
                high = k;
            } else if (this.thresh.size() > 0) {
                high = this.thresh.lastKey();
            }
            if (high == -1 || j.compareTo(this.getLastValue()) > 0) {
                this.append(j);
                k = high + 1;
            } else {
                int low = 0;
                while (low <= high) {
                    int index = (high + low) / 2;
                    Integer val = this.thresh.get(index);
                    int cmp = j.compareTo(val);
                    if (cmp == 0) {
                        return null;
                    }
                    if (cmp > 0) {
                        low = index + 1;
                        continue;
                    }
                    high = index - 1;
                }
                this.thresh.put(low, j);
                k = low;
            }
        }
        return k;
    }
}

