/*
 * Decompiled with CFR 0.152.
 */
package foodev.jsondiff.jsonwrap.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import foodev.jsondiff.jsonwrap.JzonArray;
import foodev.jsondiff.jsonwrap.JzonElement;
import foodev.jsondiff.jsonwrap.JzonObject;
import foodev.jsondiff.jsonwrap.Wrapper;
import foodev.jsondiff.jsonwrap.gson.GsonJsonArray;
import foodev.jsondiff.jsonwrap.gson.GsonJsonNull;
import foodev.jsondiff.jsonwrap.gson.GsonJsonObject;
import foodev.jsondiff.jsonwrap.gson.GsonJsonPrimitive;

public class GsonWrapper
implements Wrapper {
    private static final JsonParser JSON = new JsonParser();

    public static JzonElement wrap(JsonElement el) {
        if (el == null || el.isJsonNull()) {
            return GsonJsonNull.INSTANCE;
        }
        if (el.isJsonArray()) {
            return new GsonJsonArray((JsonArray)el);
        }
        if (el.isJsonObject()) {
            return new GsonJsonObject((JsonObject)el);
        }
        if (el.isJsonPrimitive()) {
            return new GsonJsonPrimitive((JsonPrimitive)el);
        }
        throw new IllegalStateException();
    }

    @Override
    public JzonElement parse(String json) {
        return GsonWrapper.wrap(JSON.parse(json));
    }

    @Override
    public JzonElement wrap(Object o) {
        return GsonWrapper.wrap((JsonElement)o);
    }

    @Override
    public JzonObject createJsonObject() {
        return (JzonObject)GsonWrapper.wrap((JsonElement)new JsonObject());
    }

    @Override
    public JzonArray createJsonArray() {
        return (JzonArray)GsonWrapper.wrap((JsonElement)new JsonArray());
    }
}

