/*
 * Decompiled with CFR 0.152.
 */
package foodev.jsondiff.jsonwrap.jackson;

import foodev.jsondiff.jsonwrap.JzonArray;
import foodev.jsondiff.jsonwrap.JzonElement;
import foodev.jsondiff.jsonwrap.JzonObject;
import foodev.jsondiff.jsonwrap.Wrapper;
import foodev.jsondiff.jsonwrap.jackson.JacksonJsonArray;
import foodev.jsondiff.jsonwrap.jackson.JacksonJsonNull;
import foodev.jsondiff.jsonwrap.jackson.JacksonJsonObject;
import foodev.jsondiff.jsonwrap.jackson.JacksonJsonPrimitive;
import foodev.jsondiff.jsonwrap.jackson.JacksonWrapperException;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.ValueNode;

public class JacksonWrapper
implements Wrapper {
    private static final ObjectMapper JSON = new ObjectMapper();

    public static JzonElement wrap(JsonNode el) {
        if (el == null || el.isNull()) {
            return JacksonJsonNull.INSTANCE;
        }
        if (el.isArray()) {
            return new JacksonJsonArray((ArrayNode)el);
        }
        if (el.isObject()) {
            return new JacksonJsonObject((ObjectNode)el);
        }
        if (el.isValueNode()) {
            return new JacksonJsonPrimitive((ValueNode)el);
        }
        throw new IllegalStateException();
    }

    @Override
    public JzonElement parse(String json) {
        try {
            JsonParser parser = JSON.getJsonFactory().createJsonParser(json);
            parser.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            parser.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            return JacksonWrapper.wrap(parser.readValueAsTree());
        }
        catch (JsonProcessingException e) {
            throw new JacksonWrapperException("Failed to parse JSON", e);
        }
        catch (IOException e) {
            throw new JacksonWrapperException("IOException parsing a String?", e);
        }
    }

    @Override
    public JzonElement wrap(Object o) {
        return JacksonWrapper.wrap((JsonNode)o);
    }

    @Override
    public JzonObject createJsonObject() {
        return (JzonObject)JacksonWrapper.wrap((JsonNode)JSON.createObjectNode());
    }

    @Override
    public JzonArray createJsonArray() {
        return (JzonArray)JacksonWrapper.wrap((JsonNode)JSON.createArrayNode());
    }
}

