/*
 * Decompiled with CFR 0.152.
 */
package foodev.jsondiff.jsonwrap.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import foodev.jsondiff.jsonwrap.JzonArray;
import foodev.jsondiff.jsonwrap.JzonElement;
import foodev.jsondiff.jsonwrap.JzonObject;
import foodev.jsondiff.jsonwrap.Wrapper;
import foodev.jsondiff.jsonwrap.jackson2.Jackson2JsonArray;
import foodev.jsondiff.jsonwrap.jackson2.Jackson2JsonNull;
import foodev.jsondiff.jsonwrap.jackson2.Jackson2JsonObject;
import foodev.jsondiff.jsonwrap.jackson2.Jackson2JsonPrimitive;
import foodev.jsondiff.jsonwrap.jackson2.Jackson2WrapperException;
import java.io.IOException;

public class Jackson2Wrapper
implements Wrapper {
    private static final ObjectMapper JSON = new ObjectMapper();

    public static JzonElement wrap(JsonNode el) {
        if (el == null || el.isNull()) {
            return Jackson2JsonNull.INSTANCE;
        }
        if (el.isArray()) {
            return new Jackson2JsonArray((ArrayNode)el);
        }
        if (el.isObject()) {
            return new Jackson2JsonObject((ObjectNode)el);
        }
        if (el.isValueNode()) {
            return new Jackson2JsonPrimitive((ValueNode)el);
        }
        throw new IllegalStateException();
    }

    @Override
    public JzonElement parse(String json) {
        try {
            JsonParser parser = JSON.getJsonFactory().createJsonParser(json);
            parser.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            parser.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            return this.wrap(parser.readValueAsTree());
        }
        catch (JsonProcessingException e) {
            throw new Jackson2WrapperException("Failed to parse JSON", e);
        }
        catch (IOException e) {
            throw new Jackson2WrapperException("IOException parsing a String?", e);
        }
    }

    @Override
    public JzonElement wrap(Object o) {
        return Jackson2Wrapper.wrap((JsonNode)o);
    }

    @Override
    public JzonObject createJsonObject() {
        return (JzonObject)Jackson2Wrapper.wrap((JsonNode)JSON.createObjectNode());
    }

    @Override
    public JzonArray createJsonArray() {
        return (JzonArray)Jackson2Wrapper.wrap((JsonNode)JSON.createArrayNode());
    }
}

