/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.RedisBase;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class RO_scan
extends AbstractRedisOperation {
    private static final long CURSOR_START = 0L;
    private static final long DEFAULT_COUNT = 10L;
    private static final String MATCH = "match";
    private static final String COUNT = "count";

    RO_scan(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    Slice response() {
        Slice cursorSlice = this.params().get(0);
        long cursor = cursorSlice != null ? Utils.convertToLong(cursorSlice.toString()) : 0L;
        String match = RO_scan.extractParameter(this.params(), MATCH).map(Slice::toString).orElse("*");
        long count = RO_scan.extractParameter(this.params(), COUNT).map(s -> Utils.convertToLong(s.toString())).orElse(10L);
        String regex = Utils.createRegexFromGlob(match);
        List<Slice> matchingKeys = this.base().keys().stream().skip(cursor).limit(count).filter(x -> x.toString().matches(regex)).map(Response::bulkString).collect(Collectors.toList());
        if ((cursor += count) >= (long)this.base().keys().size()) {
            cursor = 0L;
        }
        ArrayList response = Lists.newArrayList((Object[])new Slice[]{Response.bulkString(Slice.create(String.valueOf(cursor))), Response.array(matchingKeys)});
        return Response.array(response);
    }

    private static Optional<Slice> extractParameter(List<Slice> params, String name) {
        for (int i = 0; i < params.size(); ++i) {
            String param = new String(params.get(i).data());
            if (!name.equalsIgnoreCase(param)) continue;
            return Optional.of(params.get(i + 1));
        }
        return Optional.empty();
    }
}

