/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.server.RedisService;
import com.github.fppt.jedismock.server.ServiceOptions;
import com.github.fppt.jedismock.storage.RedisBase;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;

public class RedisServer {
    private final int bindPort;
    private ServiceOptions options = ServiceOptions.defaultOptions();
    private ServerSocket server = null;
    private Thread service = null;
    private final Map<Integer, RedisBase> redisBases = new HashMap<Integer, RedisBase>();

    public RedisServer() throws IOException {
        this(0);
    }

    public RedisServer(int port) throws IOException {
        this.bindPort = port;
    }

    public static RedisServer newRedisServer() throws IOException {
        return new RedisServer();
    }

    public static RedisServer newRedisServer(int port) throws IOException {
        return new RedisServer(port);
    }

    public void setOptions(ServiceOptions options) {
        Preconditions.checkNotNull((Object)options);
        this.options = options;
    }

    public void start() throws IOException {
        Preconditions.checkState((this.server == null ? 1 : 0) != 0);
        Preconditions.checkState((this.service == null ? 1 : 0) != 0);
        this.server = new ServerSocket(this.bindPort);
        this.service = new Thread(new RedisService(this.server, this.redisBases, this.options));
        this.service.start();
    }

    public void stop() {
        Preconditions.checkNotNull((Object)this.service);
        Preconditions.checkState((boolean)this.service.isAlive());
        try {
            this.server.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.service.join(100L);
            if (this.service.isAlive()) {
                this.service.stop();
            }
        }
        catch (InterruptedException e) {
            this.service.stop();
        }
        this.server = null;
        this.service = null;
    }

    public String getHost() {
        Preconditions.checkNotNull((Object)this.server);
        return this.server.getInetAddress().getHostAddress();
    }

    public int getBindPort() {
        Preconditions.checkNotNull((Object)this.server);
        return this.server.getLocalPort();
    }
}

