/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.server;

import com.github.fppt.jedismock.commands.RedisCommand;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.OperationFactory;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisOperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RedisOperationExecutor.class);
    private final OperationExecutorState state;

    public RedisOperationExecutor(OperationExecutorState state) {
        this.state = state;
    }

    public synchronized Slice execCommand(RedisCommand command) {
        Preconditions.checkArgument((command.parameters().size() > 0 ? 1 : 0) != 0);
        List<Slice> params = command.parameters();
        List<Slice> commandParams = params.subList(1, params.size());
        String name = new String(params.get(0).data()).toLowerCase();
        try {
            Optional<RedisOperation> result = OperationFactory.buildMetaOperation(name, this.state, commandParams);
            if (result.isPresent()) {
                return result.get().execute();
            }
            RedisOperation redisOperation = OperationFactory.buildTxOperation(this.state.base(), name, commandParams);
            if (!this.state.isTransactionModeOn()) {
                return Response.clientResponse(name, redisOperation.execute());
            }
            this.state.tx().add(redisOperation);
            return Response.clientResponse(name, Response.OK);
        }
        catch (WrongValueTypeException | IllegalArgumentException | UnsupportedOperationException e) {
            LOG.error("Malformed request", (Throwable)e);
            return Response.error(e.getMessage());
        }
    }
}

