/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RO_zremrangebyscore
extends AbstractRedisOperation {
    private static final String LOWEST_POSSIBLE_SCORE = "-inf";
    private static final String HIGHEST_POSSIBLE_SCORE = "+inf";
    private static final String EXCLUSIVE_PREFIX = "(";

    RO_zremrangebyscore(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    Slice response() {
        Slice key = this.params().get(0);
        LinkedHashMap map = this.getDataFromBase(key, new LinkedHashMap());
        if (map == null || map.isEmpty()) {
            return Response.integer(0L);
        }
        String start = this.params().get(1).toString();
        double startScore = this.getStartScore(start);
        Predicate<Double> compareToStart = p -> start.startsWith(EXCLUSIVE_PREFIX) ? p.compareTo(startScore) > 0 : p.compareTo(startScore) >= 0;
        String end = this.params().get(2).toString();
        double endScore = this.getEndScore(end);
        Predicate<Double> compareToEnd = p -> end.startsWith(EXCLUSIVE_PREFIX) ? p.compareTo(endScore) < 0 : p.compareTo(endScore) <= 0;
        List values = map.values().stream().filter(compareToStart.and(compareToEnd)).collect(Collectors.toList());
        Map result = map.entrySet().stream().filter(entry -> compareToStart.and(compareToEnd).negate().test(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
        try {
            this.base().putValue(key, Utils.serializeObject(result));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return Response.integer(values.size());
    }

    private double getStartScore(String start) {
        if (LOWEST_POSSIBLE_SCORE.equalsIgnoreCase(start)) {
            return Double.MIN_VALUE;
        }
        if (start.startsWith(EXCLUSIVE_PREFIX)) {
            return Utils.convertToDouble(start.substring(1));
        }
        if (Character.isDigit(start.charAt(0))) {
            return Utils.convertToDouble(start);
        }
        throw new WrongValueTypeException("Valid start must be a number or start with '(' or be equal to '-inf'");
    }

    private double getEndScore(String end) {
        if (HIGHEST_POSSIBLE_SCORE.equalsIgnoreCase(end)) {
            return Double.MAX_VALUE;
        }
        if (end.startsWith(EXCLUSIVE_PREFIX)) {
            return Utils.convertToDouble(end.substring(1));
        }
        if (Character.isDigit(end.charAt(0))) {
            return Utils.convertToDouble(end);
        }
        throw new WrongValueTypeException("Valid end must be a number or start with '(' or be equal to '+inf'");
    }
}

