/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.RedisClient;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class OperationExecutorState {
    private final RedisClient owner;
    private final Map<Integer, RedisBase> redisBases;
    private AtomicBoolean isTransactionModeOn = new AtomicBoolean(false);
    private List<RedisOperation> tx = new ArrayList<RedisOperation>();
    private int selectedRedisBase = 0;

    public OperationExecutorState(RedisClient owner, Map<Integer, RedisBase> redisBases) {
        this.owner = owner;
        this.redisBases = redisBases;
    }

    public RedisBase base() {
        return this.redisBases.computeIfAbsent(this.selectedRedisBase, key -> new RedisBase());
    }

    public RedisClient owner() {
        return this.owner;
    }

    public List<RedisOperation> tx() {
        return this.tx;
    }

    public void changeActiveRedisBase(int selectedRedisBase) {
        this.selectedRedisBase = selectedRedisBase;
    }

    public void transactionMode(boolean isTransactionModeOn) {
        this.isTransactionModeOn.set(isTransactionModeOn);
    }

    public boolean isTransactionModeOn() {
        return this.isTransactionModeOn.get();
    }

    public void newTransaction() {
        if (this.isTransactionModeOn.get()) {
            throw new RuntimeException("Redis mock does not support more than one transaction");
        }
        this.transactionMode(true);
    }

    public void clearAll() {
        for (RedisBase redisBase : this.redisBases.values()) {
            redisBase.clear();
        }
    }
}

