/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.AutoValue_ExpiringKeyValueStorage;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.Set;

@AutoValue
public abstract class ExpiringKeyValueStorage {
    public abstract Table<Slice, Slice, Slice> values();

    public abstract Map<Slice, Long> ttls();

    public static ExpiringKeyValueStorage create() {
        return new AutoValue_ExpiringKeyValueStorage((Table<Slice, Slice, Slice>)HashBasedTable.create(), Maps.newHashMap());
    }

    public void delete(Slice key) {
        this.ttls().remove(key);
        this.values().row((Object)key).clear();
    }

    public void delete(Slice key1, Slice key2) {
        Preconditions.checkNotNull((Object)key1);
        Preconditions.checkNotNull((Object)key2);
        this.values().remove((Object)key1, (Object)key2);
        if (!this.values().containsRow((Object)key1)) {
            this.ttls().remove(key1);
        }
    }

    public void clear() {
        this.values().clear();
        this.ttls().clear();
    }

    public Slice get(Slice key) {
        return this.get(key, Slice.reserved());
    }

    public Map<Slice, Slice> getFieldsAndValues(Slice hash) {
        return this.values().row((Object)hash);
    }

    public Slice get(Slice key1, Slice key2) {
        Preconditions.checkNotNull((Object)key1);
        Preconditions.checkNotNull((Object)key2);
        Long deadline = this.ttls().get(key1);
        if (deadline != null && deadline != -1L && deadline <= System.currentTimeMillis()) {
            this.delete(key1);
            return null;
        }
        return (Slice)this.values().get((Object)key1, (Object)key2);
    }

    public Long getTTL(Slice key) {
        Preconditions.checkNotNull((Object)key);
        Long deadline = this.ttls().get(key);
        if (deadline == null) {
            return null;
        }
        if (deadline == -1L) {
            return deadline;
        }
        long now = System.currentTimeMillis();
        if (now < deadline) {
            return deadline - now;
        }
        this.delete(key);
        return null;
    }

    public long setTTL(Slice key, long ttl) {
        return this.setDeadline(key, ttl + System.currentTimeMillis());
    }

    public void put(Slice key, Slice value, Long ttl) {
        this.put(key, Slice.reserved(), value, ttl);
    }

    public void put(Slice key1, Slice key2, Slice value, Long ttl) {
        Preconditions.checkNotNull((Object)key1);
        Preconditions.checkNotNull((Object)key2);
        Preconditions.checkNotNull((Object)value);
        this.values().put((Object)key1, (Object)key2, (Object)value);
        if (ttl == null) {
            if (this.getTTL(key1) == null) {
                this.setDeadline(key1, -1L);
            }
        } else if (ttl != -1L) {
            this.setTTL(key1, ttl);
        } else {
            this.setDeadline(key1, -1L);
        }
    }

    public long setDeadline(Slice key, long deadline) {
        Preconditions.checkNotNull((Object)key);
        if (this.values().containsRow((Object)key)) {
            this.ttls().put(key, deadline);
            return 1L;
        }
        return 0L;
    }

    public boolean exists(Slice slice) {
        if (this.values().containsRow((Object)slice)) {
            Long deadline = this.ttls().get(slice);
            if (deadline != null && deadline != -1L && deadline <= System.currentTimeMillis()) {
                this.delete(slice, Slice.reserved());
                return false;
            }
            return true;
        }
        return false;
    }

    public Slice type(Slice slice) {
        if (!this.exists(slice)) {
            return Slice.create("none");
        }
        Slice value = this.get(slice, Slice.reserved());
        if (value == null) {
            return Slice.create("hash");
        }
        if (value.data()[0] == -84 && value.data()[1] == -19) {
            Object o = Utils.deserializeObject(value);
            if (o instanceof List) {
                return Slice.create("list");
            }
            if (o instanceof Set) {
                return Slice.create("set");
            }
            if (o instanceof Map) {
                return Slice.create("zset");
            }
            throw new IllegalStateException("Unknown value type");
        }
        return Slice.create("string");
    }
}

