/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.commands;

import com.github.fppt.jedismock.commands.RedisCommand;
import com.github.fppt.jedismock.exception.ParseErrorException;
import com.github.fppt.jedismock.server.SliceParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RedisCommandParser {
    @VisibleForTesting
    public static RedisCommand parse(String stringInput) throws ParseErrorException {
        Preconditions.checkNotNull((Object)stringInput);
        return RedisCommandParser.parse(new ByteArrayInputStream(stringInput.getBytes()));
    }

    public static RedisCommand parse(InputStream messageInput) throws ParseErrorException {
        Preconditions.checkNotNull((Object)messageInput);
        long count = SliceParser.consumeCount(messageInput);
        if (count == 0L) {
            throw new ParseErrorException();
        }
        RedisCommand command = RedisCommand.create();
        for (long i = 0L; i < count; ++i) {
            command.parameters().add(SliceParser.consumeParameter(messageInput));
        }
        return command;
    }
}

