/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.stream.Collectors;

class RO_set
extends AbstractRedisOperation {
    private final List<String> additionalParams = this.params().stream().skip(2L).map(Slice::toString).collect(Collectors.toList());

    RO_set(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    Slice response() {
        Slice key = this.params().get(0);
        Slice value = this.params().get(1);
        if (this.nx()) {
            Slice old = this.base().getValue(key);
            if (old == null) {
                this.base().putValue(key, value, this.ttl());
                return Response.OK;
            }
            return Response.NULL;
        }
        if (this.xx()) {
            Slice old = this.base().getValue(key);
            if (old == null) {
                return Response.NULL;
            }
            this.base().putValue(key, value, this.ttl());
            return Response.OK;
        }
        this.base().putValue(key, value, this.ttl());
        return Response.OK;
    }

    private boolean nx() {
        return this.additionalParams.stream().anyMatch("nx"::equalsIgnoreCase);
    }

    private boolean xx() {
        return this.additionalParams.stream().anyMatch("xx"::equalsIgnoreCase);
    }

    private Long ttl() {
        String previous = null;
        for (String param : this.additionalParams) {
            if ("ex".equalsIgnoreCase(previous)) {
                return 1000L * Utils.convertToLong(param);
            }
            if ("px".equalsIgnoreCase(previous)) {
                return Utils.convertToLong(param);
            }
            previous = param;
        }
        return null;
    }
}

