/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.RedisBase;
import com.github.fppt.jedismock.RedisCommand;
import com.github.fppt.jedismock.RedisCommandParser;
import com.github.fppt.jedismock.Response;
import com.github.fppt.jedismock.ServiceOptions;
import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.commands.RedisOperationExecutor;
import com.github.fppt.jedismock.exception.EOFException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClient
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClient.class);
    private final AtomicBoolean running;
    private final RedisOperationExecutor executor;
    private final Socket socket;
    private final ServiceOptions options;
    private final InputStream in;
    private final OutputStream out;

    public RedisClient(RedisBase base, Socket socket, ServiceOptions options) throws IOException {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)socket);
        Preconditions.checkNotNull((Object)options);
        this.executor = new RedisOperationExecutor(base, this);
        this.socket = socket;
        this.options = options;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.running = new AtomicBoolean(true);
    }

    @Override
    public void run() {
        int count = 0;
        while (this.running.get()) {
            Optional<RedisCommand> command = this.nextCommand();
            if (!command.isPresent()) continue;
            Slice response = this.executor.execCommand(command.get());
            this.sendResponse(response, command.toString());
            if (this.options.getCloseSocketAfterSeveralCommands() == 0 || this.options.getCloseSocketAfterSeveralCommands() != ++count) continue;
            break;
        }
        LOG.debug("Mock redis connection shutting down.");
    }

    private Optional<RedisCommand> nextCommand() {
        try {
            return Optional.of(RedisCommandParser.parse(this.in));
        }
        catch (EOFException eOFException) {
            return Optional.empty();
        }
    }

    public void sendResponse(Slice response, String respondingTo) {
        try {
            if (!response.equals(Response.SKIP)) {
                this.out.write(response.data());
            }
        }
        catch (IOException e) {
            LOG.error("unable to send [" + response + "] as response to [" + respondingTo + "]", (Throwable)e);
        }
    }

    public void close() {
        this.running.set(false);
        Utils.closeQuietly(this.socket);
        Utils.closeQuietly(this.in);
        Utils.closeQuietly(this.out);
    }
}

