/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.RedisBase;
import com.github.fppt.jedismock.RedisClient;
import com.github.fppt.jedismock.ServiceOptions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class RedisService
implements Runnable {
    private final ServerSocket server;
    private final RedisBase base;
    private final ServiceOptions options;

    public RedisService(ServerSocket server, RedisBase base, ServiceOptions options) {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)options);
        this.server = server;
        this.base = base;
        this.options = options;
    }

    @Override
    public void run() {
        while (!this.server.isClosed()) {
            try {
                Socket socket = this.server.accept();
                Thread t = new Thread(new RedisClient(this.base, socket, this.options));
                t.start();
            }
            catch (IOException iOException) {}
        }
    }
}

