/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.commands;

import com.github.fppt.jedismock.RedisBase;
import com.github.fppt.jedismock.Response;
import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.SliceParser;
import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.commands.RO_lrange;
import com.github.fppt.jedismock.commands.RO_rpoplpush;
import java.util.Arrays;
import java.util.List;

class RO_brpoplpush
extends RO_rpoplpush {
    private long count = 0L;

    RO_brpoplpush(RedisBase base, List<Slice> params) {
        super(base, params, 3);
    }

    @Override
    void doOptionalWork() {
        Slice source = this.params().get(0);
        long timeout = Utils.convertToLong(this.params().get(2).toString());
        for (long currentSleep = 0L; this.count == 0L && currentSleep < timeout * 1000L; currentSleep += 100L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.count = this.getCount(source);
        }
    }

    @Override
    Slice response() {
        if (this.count != 0L) {
            return super.response();
        }
        return Response.NULL;
    }

    private long getCount(Slice source) {
        Slice index = new Slice("0");
        List<Slice> commands = Arrays.asList(source, index, index);
        Slice result = new RO_lrange(this.base(), commands).execute();
        return SliceParser.consumeCount(result.data());
    }
}

