/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.commands;

import com.github.fppt.jedismock.RedisBase;
import com.github.fppt.jedismock.Response;
import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.commands.AbstractRedisOperation;
import java.util.Arrays;
import java.util.List;

class RO_setbit
extends AbstractRedisOperation {
    RO_setbit(RedisBase base, List<Slice> params) {
        super(base, params, 3, null, null);
    }

    @Override
    Slice response() {
        long original;
        Slice value = this.base().rawGet(this.params().get(0));
        byte bit = Utils.convertToByte(this.params().get(2).toString());
        int pos = Utils.convertToNonNegativeInteger(this.params().get(1).toString());
        if (value == null) {
            byte[] data = new byte[pos / 8 + 1];
            Arrays.fill(data, (byte)0);
            data[pos / 8] = (byte)(bit << pos % 8);
            this.base().rawPut(this.params().get(0), new Slice(data), -1L);
            return Response.integer(0L);
        }
        if (pos / 8 >= value.length()) {
            byte[] data = new byte[pos / 8 + 1];
            Arrays.fill(data, (byte)0);
            for (int i = 0; i < value.length(); ++i) {
                data[i] = value.data()[i];
            }
            data[pos / 8] = (byte)(bit << pos % 8);
            original = 0L;
            this.base().rawPut(this.params().get(0), new Slice(data), -1L);
        } else {
            byte[] data = value.data();
            original = (data[pos / 8] & 1 << pos % 8) != 0 ? 1L : 0L;
            int n = pos / 8;
            data[n] = (byte)(data[n] | (byte)(1 << pos % 8));
            int n2 = pos / 8;
            data[n2] = (byte)(data[n2] & (byte)(bit << pos % 8));
            this.base().rawPut(this.params().get(0), new Slice(data), -1L);
        }
        return Response.integer(original);
    }
}

