/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.RedisClient;
import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.storage.ExpiringKeyValueStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class RedisBase {
    private final ExpiringKeyValueStorage keyValueStorage = ExpiringKeyValueStorage.create();
    private final Map<Slice, Set<RedisClient>> subscribers = new ConcurrentHashMap<Slice, Set<RedisClient>>();
    private final Set<RedisBase> syncBases = ConcurrentHashMap.newKeySet();

    public void addSyncBase(RedisBase base) {
        this.syncBases.add(base);
    }

    public Set<Slice> keys() {
        return this.keyValueStorage.values().rowMap().keySet();
    }

    public Slice getValue(Slice key) {
        return this.keyValueStorage.get(key);
    }

    public Slice getValue(Slice key1, Slice key2) {
        return this.keyValueStorage.get(key1, key2);
    }

    public Long getTTL(Slice key) {
        return this.keyValueStorage.getTTL(key);
    }

    private void syncBases(Consumer<RedisBase> syncFunction) {
        for (RedisBase base : this.syncBases) {
            syncFunction.accept(base);
        }
    }

    public long setTTL(Slice key, long ttl) {
        long result = this.keyValueStorage.setTTL(key, ttl);
        this.syncBases(base -> base.setTTL(key, ttl));
        return result;
    }

    public long setDeadline(Slice key, long deadline) {
        long result = this.keyValueStorage.setDeadline(key, deadline);
        this.syncBases(base -> base.setDeadline(key, deadline));
        return result;
    }

    public void clear() {
        this.keyValueStorage.clear();
        this.subscribers.clear();
        this.syncBases.clear();
    }

    public void putValue(Slice key, Slice value) {
        this.putValue(key, value, -1L);
    }

    public void putValue(Slice key, Slice value, Long ttl) {
        this.keyValueStorage.put(key, value, ttl);
        this.syncBases(base -> base.putValue(key, value, ttl));
    }

    public void putValue(Slice key1, Slice key2, Slice value, Long ttl) {
        this.keyValueStorage.put(key1, key2, value, ttl);
        this.syncBases(base -> base.putValue(key1, key2, value, ttl));
    }

    public void deleteValue(Slice key) {
        this.keyValueStorage.delete(key);
        this.syncBases(base -> base.deleteValue(key));
    }

    public void deleteValue(Slice key1, Slice key2) {
        this.keyValueStorage.delete(key1, key2);
        this.syncBases(base -> base.deleteValue(key1, key2));
    }

    public void addSubscriber(Slice channel, RedisClient client) {
        HashSet<RedisClient> newClient = new HashSet<RedisClient>();
        newClient.add(client);
        this.subscribers.merge(channel, newClient, (currentSubscribers, newSubscribers) -> {
            currentSubscribers.addAll(newSubscribers);
            return currentSubscribers;
        });
    }

    public boolean removeSubscriber(Slice channel, RedisClient client) {
        if (this.subscribers.containsKey(channel)) {
            this.subscribers.get(channel).remove(client);
            return true;
        }
        return false;
    }

    public Set<RedisClient> getSubscribers(Slice channel) {
        if (this.subscribers.containsKey(channel)) {
            return this.subscribers.get(channel);
        }
        return Collections.emptySet();
    }

    public List<Slice> getSubscriptions(RedisClient client) {
        ArrayList<Slice> subscriptions = new ArrayList<Slice>();
        this.subscribers.forEach((channel, subscribers) -> {
            if (subscribers.contains(client)) {
                subscriptions.add((Slice)channel);
            }
        });
        return subscriptions;
    }
}

