/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.exception.EOFException;
import com.github.fppt.jedismock.exception.ParseErrorException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SliceParser {
    @VisibleForTesting
    public static byte consumeByte(InputStream messageInput) throws EOFException {
        int b;
        try {
            b = messageInput.read();
        }
        catch (IOException e) {
            throw new EOFException();
        }
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    @VisibleForTesting
    public static void expectByte(InputStream messageInput, byte c) throws ParseErrorException, EOFException {
        if (SliceParser.consumeByte(messageInput) != c) {
            throw new ParseErrorException();
        }
    }

    @VisibleForTesting
    public static long consumeLong(InputStream messageInput) throws ParseErrorException {
        long ret = 0L;
        boolean hasLong = false;
        while (true) {
            byte c;
            try {
                c = SliceParser.consumeByte(messageInput);
            }
            catch (EOFException e) {
                throw new ParseErrorException();
            }
            if (c == 13) break;
            if (!SliceParser.isNumber(c)) {
                throw new ParseErrorException();
            }
            ret = ret * 10L + (long)c - 48L;
            hasLong = true;
        }
        if (!hasLong) {
            throw new ParseErrorException();
        }
        return ret;
    }

    @VisibleForTesting
    public static Slice consumeSlice(InputStream messageInput, long len) throws ParseErrorException {
        ByteArrayDataOutput bo = ByteStreams.newDataOutput();
        for (long i = 0L; i < len; ++i) {
            try {
                bo.write((int)SliceParser.consumeByte(messageInput));
                continue;
            }
            catch (EOFException e) {
                throw new ParseErrorException();
            }
        }
        return Slice.create(bo.toByteArray());
    }

    @VisibleForTesting
    public static long consumeCount(InputStream messageInput) throws ParseErrorException {
        try {
            SliceParser.expectByte(messageInput, (byte)42);
            long count = SliceParser.consumeLong(messageInput);
            SliceParser.expectByte(messageInput, (byte)10);
            return count;
        }
        catch (EOFException e) {
            throw new ParseErrorException();
        }
    }

    public static long consumeCount(byte[] message) throws ParseErrorException {
        ByteArrayInputStream stream = new ByteArrayInputStream(message);
        return SliceParser.consumeCount(stream);
    }

    private static boolean isNumber(byte c) {
        return 48 <= c && c <= 57;
    }

    public static Slice consumeParameter(InputStream messageInput) throws ParseErrorException {
        try {
            SliceParser.expectByte(messageInput, (byte)36);
            long len = SliceParser.consumeLong(messageInput);
            SliceParser.expectByte(messageInput, (byte)10);
            Slice para = SliceParser.consumeSlice(messageInput, len);
            SliceParser.expectByte(messageInput, (byte)13);
            SliceParser.expectByte(messageInput, (byte)10);
            return para;
        }
        catch (EOFException e) {
            throw new ParseErrorException();
        }
    }

    public static Slice consumeParameter(byte[] message) throws ParseErrorException {
        ByteArrayInputStream stream = new ByteArrayInputStream(message);
        return SliceParser.consumeParameter(stream);
    }
}

