/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.commands;

import com.github.fppt.jedismock.RedisBase;
import com.github.fppt.jedismock.Response;
import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.commands.AbstractRedisOperation;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class RO_lrem
extends AbstractRedisOperation {
    RO_lrem(RedisBase base, List<Slice> params) {
        super(base, params, 3, null, null);
    }

    @Override
    Slice response() {
        Slice key = this.params().get(0);
        int numRemove = Utils.convertToInteger(new String(this.params().get(1).data()));
        Slice target = this.params().get(2);
        Slice data = this.base().getValue(key);
        if (data == null) {
            return Response.integer(0L);
        }
        LinkedList list = (LinkedList)Utils.deserializeObject(data);
        int numRemoved = 0;
        Iterator iterator = numRemove < 0 ? list.descendingIterator() : list.iterator();
        numRemove = Math.abs(numRemove);
        while (iterator.hasNext()) {
            Slice element = (Slice)iterator.next();
            if (!element.equals(target) || numRemove != 0 && numRemoved >= numRemove) continue;
            iterator.remove();
            ++numRemoved;
        }
        this.base().putValue(key, Utils.serializeObject(list));
        return Response.integer(numRemoved);
    }
}

