/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.AutoValue_Slice;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Arrays;

@AutoValue
public abstract class Slice
implements Comparable<Slice>,
Serializable {
    private static final String RESERVED_SLICE_NAME = "Reserved String In Jedis Mock";
    private static final byte[] RESERVED_SLICE_BYTES = "Reserved String In Jedis Mock".getBytes();
    private static Slice RESERVED_SLICE = null;
    private static final long serialVersionUID = 247772234876073528L;

    public abstract byte[] data();

    public static Slice create(byte[] data) {
        if (Arrays.equals(data, RESERVED_SLICE_BYTES)) {
            throw new RuntimeException("Cannot create key/value in mock due to [Reserved String In Jedis Mock] being reserved");
        }
        return new AutoValue_Slice(data);
    }

    public static Slice create(String data) {
        return Slice.create((byte[])data.getBytes().clone());
    }

    public static synchronized Slice reserved() {
        if (RESERVED_SLICE == null) {
            RESERVED_SLICE = new AutoValue_Slice(RESERVED_SLICE_BYTES);
        }
        return RESERVED_SLICE;
    }

    public int length() {
        return this.data().length;
    }

    public String toString() {
        return new String(this.data());
    }

    public boolean equals(Object b) {
        return b instanceof Slice && Arrays.equals(this.data(), ((Slice)b).data());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data());
    }

    @Override
    public int compareTo(Slice b) {
        int len1 = this.data().length;
        int len2 = b.data().length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte b2;
            byte b1 = this.data()[k];
            if (b1 == (b2 = b.data()[k])) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }
}

