/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.commands;

import com.github.fppt.jedismock.RedisBase;
import com.github.fppt.jedismock.RedisClient;
import com.github.fppt.jedismock.Response;
import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.commands.AbstractRedisOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RO_unsubscribe
extends AbstractRedisOperation {
    private static final Logger LOG = LoggerFactory.getLogger(RO_unsubscribe.class);
    private final RedisClient client;

    RO_unsubscribe(RedisBase base, RedisClient client, List<Slice> params) {
        super(base, params, null, null, null);
        this.client = client;
    }

    @Override
    Slice response() {
        List<Slice> channelsToUbsubscribeFrom;
        if (this.params().isEmpty()) {
            LOG.debug("No channels specified therefore unsubscribing from all channels");
            channelsToUbsubscribeFrom = this.base().getSubscriptions(this.client);
        } else {
            channelsToUbsubscribeFrom = this.params();
        }
        for (Slice channel : channelsToUbsubscribeFrom) {
            LOG.debug("Unsubscribing from channel [" + channel + "]");
            if (!this.base().removeSubscriber(channel, this.client)) continue;
            int numSubscriptions = this.base().getSubscriptions(this.client).size();
            Slice response = Response.unsubscribe(channel, numSubscriptions);
            this.client.sendResponse(Response.clientResponse("unsubscribe", response), "unsubscribe");
        }
        return Response.SKIP;
    }
}

