/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.commands;

import com.github.fppt.jedismock.RedisBase;
import com.github.fppt.jedismock.RedisClient;
import com.github.fppt.jedismock.RedisCommand;
import com.github.fppt.jedismock.Response;
import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.commands.RO_append;
import com.github.fppt.jedismock.commands.RO_brpoplpush;
import com.github.fppt.jedismock.commands.RO_decr;
import com.github.fppt.jedismock.commands.RO_decrby;
import com.github.fppt.jedismock.commands.RO_del;
import com.github.fppt.jedismock.commands.RO_exec;
import com.github.fppt.jedismock.commands.RO_exists;
import com.github.fppt.jedismock.commands.RO_expire;
import com.github.fppt.jedismock.commands.RO_expireat;
import com.github.fppt.jedismock.commands.RO_flushall;
import com.github.fppt.jedismock.commands.RO_get;
import com.github.fppt.jedismock.commands.RO_getbit;
import com.github.fppt.jedismock.commands.RO_getset;
import com.github.fppt.jedismock.commands.RO_hdel;
import com.github.fppt.jedismock.commands.RO_hegetall;
import com.github.fppt.jedismock.commands.RO_hget;
import com.github.fppt.jedismock.commands.RO_hmget;
import com.github.fppt.jedismock.commands.RO_hmset;
import com.github.fppt.jedismock.commands.RO_hset;
import com.github.fppt.jedismock.commands.RO_incr;
import com.github.fppt.jedismock.commands.RO_incrby;
import com.github.fppt.jedismock.commands.RO_keys;
import com.github.fppt.jedismock.commands.RO_lindex;
import com.github.fppt.jedismock.commands.RO_llen;
import com.github.fppt.jedismock.commands.RO_lpop;
import com.github.fppt.jedismock.commands.RO_lpush;
import com.github.fppt.jedismock.commands.RO_lpushx;
import com.github.fppt.jedismock.commands.RO_lrange;
import com.github.fppt.jedismock.commands.RO_lrem;
import com.github.fppt.jedismock.commands.RO_mget;
import com.github.fppt.jedismock.commands.RO_mset;
import com.github.fppt.jedismock.commands.RO_pexpire;
import com.github.fppt.jedismock.commands.RO_pexpireat;
import com.github.fppt.jedismock.commands.RO_pfadd;
import com.github.fppt.jedismock.commands.RO_pfcount;
import com.github.fppt.jedismock.commands.RO_pfmerge;
import com.github.fppt.jedismock.commands.RO_ping;
import com.github.fppt.jedismock.commands.RO_psetex;
import com.github.fppt.jedismock.commands.RO_pttl;
import com.github.fppt.jedismock.commands.RO_publish;
import com.github.fppt.jedismock.commands.RO_quit;
import com.github.fppt.jedismock.commands.RO_rpop;
import com.github.fppt.jedismock.commands.RO_rpoplpush;
import com.github.fppt.jedismock.commands.RO_rpush;
import com.github.fppt.jedismock.commands.RO_sadd;
import com.github.fppt.jedismock.commands.RO_set;
import com.github.fppt.jedismock.commands.RO_setbit;
import com.github.fppt.jedismock.commands.RO_setex;
import com.github.fppt.jedismock.commands.RO_setnx;
import com.github.fppt.jedismock.commands.RO_sinter;
import com.github.fppt.jedismock.commands.RO_smembers;
import com.github.fppt.jedismock.commands.RO_spop;
import com.github.fppt.jedismock.commands.RO_strlen;
import com.github.fppt.jedismock.commands.RO_subscribe;
import com.github.fppt.jedismock.commands.RO_ttl;
import com.github.fppt.jedismock.commands.RO_unsubscribe;
import com.github.fppt.jedismock.commands.RedisOperation;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisOperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RedisOperationExecutor.class);
    private final RedisClient owner;
    private final RedisBase base;
    private boolean transactionModeOn;
    private List<RedisOperation> transaction;

    public RedisOperationExecutor(RedisBase base, RedisClient owner) {
        this.base = base;
        this.owner = owner;
        this.transactionModeOn = false;
        this.transaction = new ArrayList<RedisOperation>();
    }

    private RedisOperation buildSimpleOperation(String name, List<Slice> params) {
        switch (name) {
            case "set": {
                return new RO_set(this.base, params);
            }
            case "setex": {
                return new RO_setex(this.base, params);
            }
            case "psetex": {
                return new RO_psetex(this.base, params);
            }
            case "setnx": {
                return new RO_setnx(this.base, params);
            }
            case "setbit": {
                return new RO_setbit(this.base, params);
            }
            case "append": {
                return new RO_append(this.base, params);
            }
            case "get": {
                return new RO_get(this.base, params);
            }
            case "getbit": {
                return new RO_getbit(this.base, params);
            }
            case "ttl": {
                return new RO_ttl(this.base, params);
            }
            case "pttl": {
                return new RO_pttl(this.base, params);
            }
            case "expire": {
                return new RO_expire(this.base, params);
            }
            case "pexpire": {
                return new RO_pexpire(this.base, params);
            }
            case "incr": {
                return new RO_incr(this.base, params);
            }
            case "incrby": {
                return new RO_incrby(this.base, params);
            }
            case "decr": {
                return new RO_decr(this.base, params);
            }
            case "decrby": {
                return new RO_decrby(this.base, params);
            }
            case "pfcount": {
                return new RO_pfcount(this.base, params);
            }
            case "pfadd": {
                return new RO_pfadd(this.base, params);
            }
            case "pfmerge": {
                return new RO_pfmerge(this.base, params);
            }
            case "mget": {
                return new RO_mget(this.base, params);
            }
            case "mset": {
                return new RO_mset(this.base, params);
            }
            case "getset": {
                return new RO_getset(this.base, params);
            }
            case "strlen": {
                return new RO_strlen(this.base, params);
            }
            case "del": {
                return new RO_del(this.base, params);
            }
            case "exists": {
                return new RO_exists(this.base, params);
            }
            case "expireat": {
                return new RO_expireat(this.base, params);
            }
            case "pexpireat": {
                return new RO_pexpireat(this.base, params);
            }
            case "lpush": {
                return new RO_lpush(this.base, params);
            }
            case "rpush": {
                return new RO_rpush(this.base, params);
            }
            case "lpushx": {
                return new RO_lpushx(this.base, params);
            }
            case "lrange": {
                return new RO_lrange(this.base, params);
            }
            case "llen": {
                return new RO_llen(this.base, params);
            }
            case "lpop": {
                return new RO_lpop(this.base, params);
            }
            case "rpop": {
                return new RO_rpop(this.base, params);
            }
            case "lindex": {
                return new RO_lindex(this.base, params);
            }
            case "rpoplpush": {
                return new RO_rpoplpush(this.base, params);
            }
            case "brpoplpush": {
                return new RO_brpoplpush(this.base, params);
            }
            case "subscribe": {
                return new RO_subscribe(this.base, this.owner, params);
            }
            case "unsubscribe": {
                return new RO_unsubscribe(this.base, this.owner, params);
            }
            case "publish": {
                return new RO_publish(this.base, params);
            }
            case "flushall": {
                return new RO_flushall(this.base, params);
            }
            case "lrem": {
                return new RO_lrem(this.base, params);
            }
            case "quit": {
                return new RO_quit(this.base, this.owner, params);
            }
            case "exec": {
                this.transactionModeOn = false;
                return new RO_exec(this.base, this.transaction, params);
            }
            case "ping": {
                return new RO_ping(this.base, params);
            }
            case "keys": {
                return new RO_keys(this.base, params);
            }
            case "sadd": {
                return new RO_sadd(this.base, params);
            }
            case "smembers": {
                return new RO_smembers(this.base, params);
            }
            case "spop": {
                return new RO_spop(this.base, params);
            }
            case "hget": {
                return new RO_hget(this.base, params);
            }
            case "hset": {
                return new RO_hset(this.base, params);
            }
            case "hdel": {
                return new RO_hdel(this.base, params);
            }
            case "hgetall": {
                return new RO_hegetall(this.base, params);
            }
            case "sinter": {
                return new RO_sinter(this.base, params);
            }
            case "hmget": {
                return new RO_hmget(this.base, params);
            }
            case "hmset": {
                return new RO_hmset(this.base, params);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported operation '%s'", name));
    }

    public synchronized Slice execCommand(RedisCommand command) {
        Preconditions.checkArgument((command.parameters().size() > 0 ? 1 : 0) != 0);
        List<Slice> params = command.parameters();
        List<Slice> commandParams = params.subList(1, params.size());
        String name = new String(params.get(0).data()).toLowerCase();
        try {
            if (name.equals("multi")) {
                this.newTransaction();
                return Response.clientResponse(name, Response.OK);
            }
            RedisOperation redisOperation = this.buildSimpleOperation(name, commandParams);
            if (!this.transactionModeOn) {
                return Response.clientResponse(name, redisOperation.execute());
            }
            this.transaction.add(redisOperation);
            return Response.clientResponse(name, Response.OK);
        }
        catch (WrongValueTypeException | IllegalArgumentException | UnsupportedOperationException e) {
            LOG.error("Malformed request", (Throwable)e);
            return Response.error(e.getMessage());
        }
    }

    private void newTransaction() {
        if (this.transactionModeOn) {
            throw new RuntimeException("Redis mock does not support more than one transaction");
        }
        this.transactionModeOn = true;
    }
}

