/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.Slice;
import com.github.fppt.jedismock.storage.AutoValue_ExpiringKeyValueStorage;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;

@AutoValue
public abstract class ExpiringKeyValueStorage {
    public abstract Table<Slice, Slice, Slice> values();

    public abstract Table<Slice, Slice, Long> ttls();

    public static ExpiringKeyValueStorage create() {
        return new AutoValue_ExpiringKeyValueStorage((Table<Slice, Slice, Slice>)HashBasedTable.create(), (Table<Slice, Slice, Long>)HashBasedTable.create());
    }

    public void delete(Slice key) {
        this.delete(key, Slice.reserved());
    }

    public void delete(Slice key1, Slice key2) {
        Preconditions.checkNotNull((Object)key1);
        Preconditions.checkNotNull((Object)key2);
        this.values().remove((Object)key1, (Object)key2);
        this.ttls().remove((Object)key1, (Object)key2);
    }

    public void clear() {
        this.values().clear();
        this.ttls().clear();
    }

    public Slice get(Slice key) {
        return this.get(key, Slice.reserved());
    }

    public Map<Slice, Slice> getFieldsAndValues(Slice hash) {
        return this.values().row((Object)hash);
    }

    public Slice get(Slice key1, Slice key2) {
        Preconditions.checkNotNull((Object)key1);
        Preconditions.checkNotNull((Object)key2);
        Long deadline = (Long)this.ttls().get((Object)key1, (Object)key2);
        if (deadline != null && deadline != -1L && deadline <= System.currentTimeMillis()) {
            this.delete(key1, key2);
            return null;
        }
        return (Slice)this.values().get((Object)key1, (Object)key2);
    }

    public Long getTTL(Slice key) {
        return this.getTTL(key, Slice.reserved());
    }

    public Long getTTL(Slice key1, Slice key2) {
        Preconditions.checkNotNull((Object)key1);
        Preconditions.checkNotNull((Object)key2);
        Long deadline = (Long)this.ttls().get((Object)key1, (Object)key2);
        if (deadline == null) {
            return null;
        }
        if (deadline == -1L) {
            return deadline;
        }
        long now = System.currentTimeMillis();
        if (now < deadline) {
            return deadline - now;
        }
        this.delete(key1, key1);
        return null;
    }

    public long setTTL(Slice key, long ttl) {
        return this.setTTL(key, Slice.reserved(), ttl);
    }

    public long setTTL(Slice key1, Slice key2, long ttl) {
        return this.setDeadline(key1, key2, ttl + System.currentTimeMillis());
    }

    public void put(Slice key, Slice value, Long ttl) {
        this.put(key, Slice.reserved(), value, ttl);
    }

    public void put(Slice key1, Slice key2, Slice value, Long ttl) {
        Preconditions.checkNotNull((Object)key1);
        Preconditions.checkNotNull((Object)key2);
        Preconditions.checkNotNull((Object)value);
        this.values().put((Object)key1, (Object)key2, (Object)value);
        if (ttl != null) {
            if (ttl != -1L) {
                this.setTTL(key1, key2, ttl);
            } else {
                this.setDeadline(key1, key2, -1L);
            }
        }
    }

    public long setDeadline(Slice key, long deadline) {
        return this.setDeadline(key, Slice.reserved(), deadline);
    }

    public long setDeadline(Slice key1, Slice key2, long deadline) {
        Preconditions.checkNotNull((Object)key1);
        Preconditions.checkNotNull((Object)key2);
        if (this.values().contains((Object)key1, (Object)key2)) {
            this.ttls().put((Object)key1, (Object)key2, (Object)deadline);
            return 1L;
        }
        return 0L;
    }
}

